/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar.webview.jsapi;

import java.util.LinkedHashMap;
import java.util.Map;
import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.component.business.activitybar.webview.jsapi.IApiModuleManager;
import tv.athena.live.utils.ALog;

public class ApiModuleManager
implements IApiModuleManager {
    private static final String TAG = "ApiModuleManager";
    private Map<String, IJsApiModule> apiModuleMap = new LinkedHashMap<String, IJsApiModule>();

    @Override
    public void addModule(IJsApiModule apiModule) {
        if (apiModule.moduleName() != null && apiModule.moduleName().length() > 0) {
            this.apiModuleMap.put(apiModule.moduleName(), apiModule);
        } else {
            ALog.w((String)TAG, (String)"invalid module name, skip mapping.");
        }
    }

    @Override
    public void removeModule(IJsApiModule apiModule) {
        this.apiModuleMap.remove(apiModule);
        apiModule.release();
    }

    @Override
    public void removeModuleByName(String name) {
        IJsApiModule apiModule = this.apiModuleMap.get(name);
        if (apiModule != null) {
            this.removeModule(apiModule);
        }
    }

    @Override
    public IJsApiModule getModule(String name) {
        return this.apiModuleMap.get(name);
    }

    public void release() {
        for (Map.Entry<String, IJsApiModule> entry : this.apiModuleMap.entrySet()) {
            entry.getValue().release();
        }
        this.apiModuleMap.clear();
    }
}

