/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import tv.athena.live.api.activitybar.bean.ActivityBarConfig;
import tv.athena.live.api.activitybar.bean.EntryData;
import tv.athena.live.api.activitybar.bean.WebViewFeature;
import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.api.activitybar.service.IWebViewUIClient;
import tv.athena.live.base.arch.IComponentView;
import tv.athena.live.base.manager.ComponentContext;
import tv.athena.live.component.business.activitybar.ActivityBarViewModel;
import tv.athena.live.component.business.activitybar.webview.WebViewUrlCommonParams;
import tv.athena.live.component.business.activitybar.webview.fragment.WebViewDialogFragment;
import tv.athena.live.component.business.activitybar.webview.fragment.WebViewFragment;
import tv.athena.live.component.business.activitybar.webview.jsapi.JsSupportWebApiAdapter;
import tv.athena.live.utils.ALog;
import tv.athena.util.FP;

class ActivityBarView
implements IComponentView<ActivityBarViewModel> {
    private static final String TAG = "ActivityBarView";
    private ActivityBarViewModel viewModel;
    private ComponentContext context;
    private int resId = -100;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private static final int ERROR_ID = -100;
    private ActivityBarConfig config;
    private static final String DIALOG = "WebViewDialogFragment";
    private static final String ACTIVITY = "activityBar";

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    public void onInitView(ArrayMap<String, Integer> viewResId) {
        if (viewResId == null || this.context == null) {
            return;
        }
        Integer id = (Integer)viewResId.get((Object)"activity_bar_layout");
        this.setId(id);
    }

    private boolean valid(Integer resId) {
        if (resId == null || resId <= 0) {
            return false;
        }
        View view = this.context.getActivity().findViewById(resId.intValue());
        return view != null && view instanceof ViewGroup;
    }

    public void setId(Integer id) {
        if (this.valid(id)) {
            this.resId = id;
        }
    }

    private String getUserName() {
        Long uid = this.context.getCommonViewModel().getMyUid();
        if (uid == null) {
            return "";
        }
        return String.valueOf(uid);
    }

    public boolean isReady() {
        return this.resId != -100;
    }

    public void showActivity(ActivityBarConfig config, String url, final EntryData data) {
        this.config = config;
        final View mAttachedView = this.context.getActivity().findViewById(this.resId);
        mAttachedView.setVisibility(4);
        WebViewFeature feature = new WebViewFeature(19);
        if (config != null) {
            url = WebViewUrlCommonParams.addCommonParams(url, config.getUrlCommonParams());
        }
        final WebViewFragment actEntryFragment = WebViewFragment.newInstance((Context)this.context.getActivity().getApplication(), url, feature);
        actEntryFragment.setActivityBarConfig(config);
        actEntryFragment.setIJsSupportWebApi(new JsSupportWebApiAdapter(){

            public Activity getActivity() {
                return ActivityBarView.this.context.getActivity();
            }

            @Override
            public void showPopupWebView(final String url, final String configUIJson) {
                ALog.i((String)"JavaScriptInterface", (String)("ActivityBarView, showPopupWebView url=" + url));
                ActivityBarView.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ActivityBarView.this.showPopView(url, configUIJson);
                    }
                });
            }

            @Override
            public void closePopupWebView() {
                ActivityBarView.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ActivityBarView.this.closePopView();
                    }
                });
            }

            @Override
            public EntryData getEntryData() {
                return data;
            }

            @Override
            public long getSid() {
                return ActivityBarView.this.context.getCommonViewModel().getSid();
            }

            @Override
            public String getOwnerName() {
                return ActivityBarView.this.getUserName();
            }

            public void loadJavascript(final String json) {
                ActivityBarView.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ActivityBarView.this.loadJavaScript(json);
                    }
                });
            }

            @Override
            public long getOwnerUid() {
                return ActivityBarView.this.context.getCommonViewModel().getMyUid();
            }
        });
        FragmentTransaction transaction = this.context.getActivity().getSupportFragmentManager().beginTransaction();
        transaction.replace(this.resId, (Fragment)actEntryFragment, ACTIVITY);
        transaction.commitAllowingStateLoss();
        actEntryFragment.setWebViewUIClient(new IWebViewUIClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
            }

            public void onReceivedTitle(WebView view, String title) {
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return false;
            }

            public void onPageFinished(WebView view, String url) {
                mAttachedView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (mAttachedView != null) {
                            mAttachedView.setVisibility(0);
                        }
                    }
                }, 400L);
                actEntryFragment.setWebViewUIClient(null);
            }
        });
    }

    public void onBindViewModel(ActivityBarViewModel viewModel) {
        this.viewModel = viewModel;
    }

    private boolean isActivityFinish() {
        return this.context.getActivity() == null || this.context.getActivity().isDestroyed() || this.context.getActivity().isFinishing();
    }

    public void showPopView(String url, String configUIJson) {
        if (FP.empty((CharSequence)url) || this.isActivityFinish()) {
            return;
        }
        WebViewFeature feature = new WebViewFeature(115);
        if (this.config != null) {
            url = WebViewUrlCommonParams.addCommonParams(url, this.config.getUrlCommonParams());
        }
        WebViewDialogFragment webViewDialogFragment = WebViewDialogFragment.newInstance(url, feature.getFeatureValue(), configUIJson);
        try {
            webViewDialogFragment.setActivityBarConfig(this.config);
            webViewDialogFragment.setOwnerName(this.getUserName());
            if (this.context.getCommonViewModel().getSid() != null) {
                webViewDialogFragment.setSid(this.context.getCommonViewModel().getSid());
            }
            webViewDialogFragment.setOwnerUid(this.context.getCommonViewModel().getMyUid());
            if (!webViewDialogFragment.isAdded()) {
                webViewDialogFragment.show(this.context.getActivity().getSupportFragmentManager(), DIALOG);
            } else {
                ALog.i((String)TAG, (String)"DialogFragment is add");
            }
        }
        catch (IllegalStateException e) {
            ALog.d((String)TAG, (String)"mWebViewDialogFragment.show error ", (Throwable)e);
        }
    }

    public void loadJavaScript(String data) {
        this.loadJavaScript(data, null);
    }

    public void loadJavaScript(String data, ValueCallback<String> callback) {
        if (this.isActivityFinish() || TextUtils.isEmpty((CharSequence)data)) {
            return;
        }
        WebViewFragment fragment = (WebViewFragment)this.context.getActivity().getSupportFragmentManager().findFragmentByTag(ACTIVITY);
        if (fragment != null) {
            if (callback == null) {
                callback = new ValueCallback<String>(){

                    public void onReceiveValue(String value) {
                        ALog.d((String)ActivityBarView.TAG, (String)("onReceiveValue: " + value));
                    }
                };
            }
            fragment.loadJavaScript(data, callback);
        }
    }

    public void closePopView() {
        ALog.d((String)TAG, (String)"close");
        if (this.isActivityFinish()) {
            return;
        }
        WebViewDialogFragment dialog = (WebViewDialogFragment)this.context.getActivity().getSupportFragmentManager().findFragmentByTag(DIALOG);
        if (dialog != null && dialog.isAdded()) {
            dialog.dismissAllowingStateLoss();
        }
    }

    public void close() {
        this.closePopView();
        if (this.config != null && this.config.getIJsApiModules() != null) {
            for (IJsApiModule module : this.config.getIJsApiModules()) {
                if (module == null) continue;
                module.release();
            }
            this.config.getIJsApiModules().clear();
        }
    }
}

