package tv.athena.live.component.business.wath

import android.os.Build
import android.view.View
import android.view.ViewGroup
import com.yy.liveplatform.proto.nano.LpfLiveroomtemplateV2
import tv.athena.live.api.roominfov2.RoomInfoV2Api
import tv.athena.live.api.wath.AudienceCDNStatus
import tv.athena.live.api.wath.AudienceLineStreamInfoListener
import tv.athena.live.api.wath.MicInfoListener
import tv.athena.live.api.wath.RoomInfoV2Listener
import tv.athena.live.api.wath.bean.LineStreamInfo
import tv.athena.live.base.arch.IComponentViewModel
import tv.athena.live.base.manager.CommonViewModel
import tv.athena.live.basesdk.thunderblotwrapper.AbscThunderEventListener
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandle
import tv.athena.live.utils.ALog
import tv.athena.live.utils.UUidUtil
import java.lang.ref.WeakReference
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.ConcurrentLinkedQueue

/**
 * Created by chf on 2019-12-30.
 * 观看模块处理
 */
class WatchViewModel : IComponentViewModel, RoomInfoV2Api.RoomInfoV2Listener {

    companion object {
        private const val TAG = "WatchViewModel"
        const val JOIN_UIDS = "join_uids"
        private val UUID = UUidUtil.getUUID32()
    }

    private val mViewPlayContainer = ConcurrentLinkedQueue<WeakReference<ViewGroup>>()
    private var mComponent: WatchComponent? = null
    private var mCommonViewModel: CommonViewModel? = null
    private var mThunderHandle: ThunderHandle? = null
    private var mRoomInfoV2Api: RoomInfoV2Api? = null
    private var micPositionHandle: MicPositionHandle? = null
    private var mRoomInfoDispatch = RoomInfoDispatch()
    private var mAudienceLineStreamHandle = AudienceLineStreamHandle()
    private var mAbscThunderEventListener: AbscThunderEventListener? = null
    private val mCacheVideoPositionUids = ConcurrentHashMap<String, Int>()
    fun onAllComponentsReady() {
    }

    fun destroy() {
        synchronized(this) {
            ALog.i(TAG, "destroy $this")
            for (v in mViewPlayContainer) {
                val viewGroup = v.get()
                viewGroup?.post {
                    viewGroup.removeAllViews()
                }
            }
            mRoomInfoV2Api?.removeRoomInfoV2Listener(this)
            mViewPlayContainer.clear()
            micPositionHandle?.onDestroy()
            mRoomInfoDispatch.onDestroy()
            mAudienceLineStreamHandle.onDestroy()

            mAbscThunderEventListener?.let {
                mThunderHandle?.unRegisterRtcEventListener(it)
            }
            mCacheVideoPositionUids.clear()
        }
    }

    fun onCreate(component: WatchComponent) {
        ALog.i(TAG, "onCreate($component)")
        setComponent(component)
    }

    fun setComponent(component: WatchComponent) {
        this.mComponent = component
        this.mCommonViewModel = component.componentContext.commonViewModel
        this.mThunderHandle = mComponent?.componentManager?.componentContext?.thunderHandle
        this.mRoomInfoV2Api =
            component.componentManager.getOtherComponentApi(RoomInfoV2Api::class.java)
        mRoomInfoV2Api?.addRoomInfoV2Listener(this)
        micPositionHandle = MicPositionHandle(component)
        ALog.i(TAG, "setComponent init all params $this")
    }

    private fun checkViewVisible(view: ViewGroup?) {
        if (view?.parent != null) {
            val viewVisible = view.visibility == View.VISIBLE
            var isAttachedToWindow = false
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                isAttachedToWindow = view.isAttachedToWindow
            }
            ALog.i(TAG, "checkViewVisible " +
                "[ view == $view  ; " +
                "  visible = $viewVisible " +
                "  viewAttach = $isAttachedToWindow ]")
            checkViewVisible(view.parent as? ViewGroup)
        }
    }

    /**
     * 开/关音频播放数据回调
     *
     * @param enablePlay true:打开 false:播放
     * @return 0:成功, 其它错误参见{@link BlitzEngineConstant.BlitzRet}
     */
    fun enableAudioDataIndication(viewGroup: ViewGroup, enablePlay: Boolean): Int {
        var value = -100
        return value
    }

    /**
     * 打开关闭音频播放频谱数据回调
     * @param enable true:打开 false:关闭 如果打开了，会收到回调
     * @see BlitzMediaPlayerEventHandler#onAudioPlaySpectrumData
     */

    fun enableAudioPlaySpectrum(viewGroup: ViewGroup, enable: Boolean): Int {
        var value = -100
        return value
    }

    /**
     * 打开关闭渲染音频数据回调
     *
     * @param enable     打开渲染音频数据回调
     * @param sampleRate 设置需要回调数据的采样率，取值范围[-1,8000,16000,44100,48000]
     * @param channel    设置需要回调数据的声道数，取值范围[-1,1,2]
     *                   <br> 只要sampleRate和channel其中一个参数的取值为-1，回调的数据是没有经过重采样的原始数据
     * 打开后通过以下接口进行回调
     * @see BlitzMediaPlayerEventHandler#onAudioRenderPcmData
     * @return 0:成功, 其它错误参见{@link BlitzEngineConstant.BlitzRet}
     */
    fun enableRenderPcmDataCallBack(
        viewGroup: ViewGroup,
        enable: Boolean,
        sampleRate: Int,
        channel: Int
    ): Int {
        var value = -100
        return value
    }

    /**
     * 设置音频播放频谱数据回调信息
     *
     * @param spectrumLen      频谱数据的长度 [12 - 256]，默认是256
     * @param notifyIntervalMS 频谱回调的间隔，必须是10的倍数，默认是30MS
     */
    fun setAudioPlaySpectrumInfo(
        viewGroup: ViewGroup,
        spectrumLen: Int,
        notifyIntervalMS: Int
    ): Int {
        var value = -100
        return value
    }

    /**
     * 启用说话者音量提示
     *
     * @param interval     <=0:禁用音量提示功能; >0 返回音量提示的间隔,单位毫秒,建议大于200毫秒
     * @param moreThanThd 从<moreThanThd到>=moreThanThd，立即回调一次 <=0无效
     * @param lessThanThd 从>=lessThanThd到<lessThanThd，立即回调一次 <=0无效
     * @param smooth      平滑系数，未实现
     * @return 0:成功, 其它错误参见{@link BlitzEngineConstant.BlitzRet}
     */
    fun setAudioVolumeIndication(
        viewGroup: ViewGroup,
        interval: Int,
        moreThanThd: Int,
        lessThanThd: Int,
        smooth: Int
    ): Int {
        var value = -100
        return value
    }

    override fun onRoomInfoV2Change(roomInfoV2: LpfLiveroomtemplateV2.LiveRoomInfoV2) {
        //需要处理 roomInfoV2 用于通知
        ALog.i(TAG, "onRoomInfoV2Change")
        mRoomInfoDispatch.handleRoomInfoV2(roomInfoV2)
        micPositionHandle?.handleRoomInfoV2(roomInfoV2)
        mAudienceLineStreamHandle.handleRoomInfoV2(roomInfoV2)
    }

    fun setRoomInfoListener(listenerBuilder: RoomInfoV2Listener.() -> Unit) {
        getLiveRoomInfoV2()
        mRoomInfoDispatch.registerListenerBuilder(listenerBuilder)
    }

    fun setMicInfoListener(micInfoListener: MicInfoListener.() -> Unit) {
        //设置接口，都主动请求一下房间数据
        getLiveRoomInfoV2()
        micPositionHandle?.setMicInfoListener(micInfoListener)
    }

    fun setLineStreamInfoListener(listener: AudienceLineStreamInfoListener.() -> Unit) {
        //设置接口，都主动请求一下房间数据
        getLiveRoomInfoV2()
        mAudienceLineStreamHandle.setLineStreamInfoListener(listener)
    }

    fun getCdnLineStreamInfo(): List<LineStreamInfo>? {
        return mAudienceLineStreamHandle.getCdnLineStreamInfo()
    }

    fun getMicInfos(): HashMap<Int, LpfLiveroomtemplateV2.LiveInterconnectStreamInfo>? {
        return micPositionHandle?.getMicInfos()
    }

    private fun getLiveRoomInfoV2() {
        mCommonViewModel?.streamRoomId?.let {
            ALog.i(TAG, "getLiveRoomInfoV2() streamRoomId = $it")
            mComponent
                ?.componentManager
                ?.getOtherComponentApi(RoomInfoV2Api::class.java)
                ?.getLiveRoomInfoRespV2(it)
        }
    }

    fun getAudienceCDNStatus(): AudienceCDNStatus? {
        return mAudienceLineStreamHandle?.getAudienceCDNStatus()
    }

    fun onLeave() {
        ALog.i(TAG, "onLeave---------------- $this ")
        mRoomInfoV2Api?.removeRoomInfoV2Listener(this)
        mAbscThunderEventListener?.let {
            mThunderHandle?.unRegisterRtcEventListener(it)
        }
    }
}
