package tv.athena.live.component.business.wath

import android.view.ViewGroup
import com.yy.liveplatform.proto.nano.LpfLiveroomtemplateV2
import tv.athena.live.api.wath.AudienceCDNStatus
import tv.athena.live.api.wath.AudienceLineStreamInfoListener
import tv.athena.live.api.wath.MicInfoListener
import tv.athena.live.api.wath.RoomInfoV2Listener
import tv.athena.live.api.wath.WatchComponentApi
import tv.athena.live.api.wath.bean.LineStreamInfo
import tv.athena.live.base.arch.IComponentApi
import tv.athena.live.utils.ALog

/**
 * Created by chf on 202/2/18
 */
class WatchApiImpl(private val mComponent: WatchComponent) : WatchComponentApi {

    private val TAG = "WatchApiImpl"

    init {
        ALog.i(TAG, "init WatchApiImpl")
    }

    override fun getApiKey(): Class<out IComponentApi> {
        return WatchComponentApi::class.java
    }

    override fun setRoomInfoListener(listenerBuilder: RoomInfoV2Listener.() -> Unit) {
        this.mComponent.viewModel?.setRoomInfoListener(listenerBuilder)
    }

    override fun setMicInfoListener(micInfoListener: MicInfoListener.() -> Unit) {
        this.mComponent.viewModel?.setMicInfoListener(micInfoListener)
    }

    override fun setLineStreamInfoListener(listener: AudienceLineStreamInfoListener.() -> Unit) {
        this.mComponent.viewModel?.setLineStreamInfoListener(listener)
    }

    override fun getCdnLineStreamInfo(): List<LineStreamInfo>? {
        return this.mComponent.viewModel?.getCdnLineStreamInfo()
    }

    override fun enableAudioDataIndication(viewGroup: ViewGroup, enablePlay: Boolean): Int? {
        return this.mComponent.viewModel?.enableAudioDataIndication(viewGroup, enablePlay)
    }

    override fun enableAudioPlaySpectrum(viewGroup: ViewGroup, enable: Boolean): Int? {
        return this.mComponent.viewModel?.enableAudioPlaySpectrum(viewGroup, enable)
    }

    override fun enableRenderPcmDataCallBack(
        viewGroup: ViewGroup,
        enable: Boolean,
        sampleRate: Int,
        channel: Int
    ): Int? {
        return this.mComponent.viewModel?.enableRenderPcmDataCallBack(viewGroup, enable, sampleRate,
            channel)
    }

    override fun setAudioPlaySpectrumInfo(
        viewGroup: ViewGroup,
        spectrumLen: Int,
        notifyIntervalMS: Int
    ): Int? {
        return this.mComponent.viewModel?.setAudioPlaySpectrumInfo(viewGroup, spectrumLen,
            notifyIntervalMS)
    }

    override fun setAudioVolumeIndication(
        viewGroup: ViewGroup,
        interval: Int,
        moreThanThd: Int,
        lessThanThd: Int,
        smooth: Int
    ): Int? {
        return this.mComponent.viewModel?.setAudioVolumeIndication(viewGroup,
            interval,
            moreThanThd,
            lessThanThd,
            smooth)
    }

    override fun getMicInfos(): HashMap<Int, LpfLiveroomtemplateV2.LiveInterconnectStreamInfo>? {
        return this.mComponent.viewModel?.getMicInfos()
    }

    override fun getAudienceCDNStatus(): AudienceCDNStatus? {
        return this.mComponent.viewModel?.getAudienceCDNStatus()
    }
}
