package tv.athena.live.component.business.wath

import com.yy.liveplatform.proto.nano.LpfLiveinfo
import com.yy.liveplatform.proto.nano.LpfLiveroomtemplateV2
import com.yy.liveplatform.proto.nano.LpfUser
import tv.athena.live.api.wath.RoomInfoV2Listener
import tv.athena.live.api.wath.bean.RoomInfoV2Wrapper
import tv.athena.live.utils.ALog

/**
 *  @author chf create on 2020/2/17
 *
 *  @description 这是RoomInfo信息分发处理类，作用通知业务端
 *  外部，当前房间的状态：标题，Owner信息，频道信息等
 *
 */
class RoomInfoDispatch {
    private val TAG = "RoomInfoDispatch"

    private var mListenerBuilder: V2ListenerBuilder? = null

    //默认的 LiveBzType值， 业务开播类型
    private var mLiveBzType = -1

    //默认的 owUserInfo
    private var mOwUserInfo: LpfUser.UserInfo? = null

    //默认的 频道信息
    private var mChannelInfo: LpfLiveinfo.ChannelLiveInfo? = null

    //默认的 RoomInfoV2 拓展字段
    private var mRoomInfoV2Extend: String? = null

    //默认的 频道当前的状况
    private var mChannelClose: Boolean = false

    //默认的 频道内的开播状态
    private var mLiveStatus: Int? = -1

    private var mRoomInfoV2Wrapper: RoomInfoV2Wrapper? = null

    init {
        ALog.i(TAG, "init")
    }

    fun onDestroy() {
        this.mListenerBuilder = null
        this.mLiveBzType = -1
        this.mOwUserInfo = null
        this.mChannelInfo = null
        this.mRoomInfoV2Extend = null
    }

    fun registerListenerBuilder(listenerBuilder: RoomInfoV2Listener.() -> Unit) {
        val builder = V2ListenerBuilder().also(listenerBuilder)
        mListenerBuilder = builder
        ALog.i(TAG, "registerListenerBuilder ($listenerBuilder) -- $mListenerBuilder")
    }

    fun handleRoomInfoV2(roomInfoV2: LpfLiveroomtemplateV2.LiveRoomInfoV2) {
        //todo 这里处理roomInfoV2
        val liveBzType = roomInfoV2.liveBzType
        val owUserInfo = roomInfoV2.owUser
        val channelInfo = roomInfoV2.channelInfo
        val extend = roomInfoV2.extend
        val channelClose = roomInfoV2.channelInfo?.channelClose
        val liveStatus = roomInfoV2.channelInfo?.liveStatus

        notifyLiveBzTypeChange(liveBzType)
        notifyOwUserInfoChange(owUserInfo)
        notifyChannelInfoChange(channelInfo)
        notifyRoomInfoV2ExtendChange(extend)
        notifyChannelCloseChange(channelClose)
        notifyLiveStatusChange(liveStatus)

        mRoomInfoV2Wrapper = RoomInfoV2Wrapper(liveBzType, owUserInfo, channelInfo, extend, channelClose, liveStatus)
    }

    fun getRoomInfoV2Wrapper(): RoomInfoV2Wrapper? {
        return mRoomInfoV2Wrapper
    }

    private fun notifyLiveStatusChange(liveStatus: Int?) {
        ALog.i(TAG, "notifyLiveStatusChange $liveStatus -- $mLiveStatus")
        liveStatus?.let {
            if (mLiveStatus != liveStatus) {
                mListenerBuilder?.mLiveStatusChangeAction?.invoke(it)
                mLiveStatus = it
            }
        }
    }

    private fun notifyChannelCloseChange(channelClose: Boolean?) {
        channelClose?.let {
            if (mChannelClose != it) {
                ALog.i(TAG, "notifyChannelCloseChange $channelClose -- $mChannelClose")
                mListenerBuilder?.mChannelCloseChangeAction?.invoke(channelClose)
                mChannelClose = it
            }
        }
    }

    /**
     * 通知房间LiveBzType 变化
     * @param liveBzType 业务开播类型
     */
    private fun notifyLiveBzTypeChange(liveBzType: Int?) {
        liveBzType?.let {
            if (mLiveBzType != it) {
                ALog.i(TAG, "notifyLiveBzTypeChange [$liveBzType : $mLiveBzType]")
                mListenerBuilder?.mLiveBzTypeChangeAction?.invoke(it)
                mLiveBzType = it
            }
        }
    }

    /**
     *  通知房间所属 UserInfo 变化
     *  @param owUserInfo 用户信息
     */
    private fun notifyOwUserInfoChange(owUserInfo: LpfUser.UserInfo?) {
        owUserInfo?.let {
            if (mOwUserInfo.toString() != it.toString()) {
                ALog.i(TAG, "notifyOwUserInfoChange $owUserInfo")
                mListenerBuilder?.mOwUserInfoChangeAction?.invoke(it)
                mOwUserInfo = it
            }
        }
    }

    /**
     *  通知频道信息变化
     *  @param channelLiveInfo 频道相关信息
     */
    private fun notifyChannelInfoChange(channelLiveInfo: LpfLiveinfo.ChannelLiveInfo?) {
        channelLiveInfo?.let {
            if (mChannelInfo.toString() != it.toString()) {
                ALog.i(TAG, "notifyChannelInfoChange $channelLiveInfo")
                mListenerBuilder?.mChannelInfoChangeAction?.invoke(it)
                mChannelInfo = it
            }
        }
    }

    /**
     *  通知 RoomInfoV2 拓展字段变化
     *  @param msg 拓展字段
     */
    private fun notifyRoomInfoV2ExtendChange(msg: String?) {
        msg?.let {
            if (mRoomInfoV2Extend.toString() != it) {
                ALog.i(TAG, "notifyRoomInfoV2ExtendChange $msg")
                mListenerBuilder?.mRoomInfoV2ExtendChangeAction?.invoke(it)
                mRoomInfoV2Extend = it
            }
        }
    }

    inner class V2ListenerBuilder : RoomInfoV2Listener {
        // 通知房间LiveBzType
        internal var mLiveBzTypeChangeAction: ((liveBzType: Int) -> Unit)? = null

        // 通知房间Ow信息
        internal var mOwUserInfoChangeAction: ((owUserInfo: LpfUser.UserInfo) -> Unit)? = null

        // 通知房间频道相关信息
        internal var mChannelInfoChangeAction: ((channelInfo: LpfLiveinfo.ChannelLiveInfo) -> Unit)? = null

        //extend 字段也作为回调给出去
        internal var mRoomInfoV2ExtendChangeAction: ((msg: String) -> Unit)? = null

        //通知房间所属频道 开关状态 当前情况
        internal var mChannelCloseChangeAction: ((channelClose: Boolean) -> Unit)? = null

        //通知房间内开播状态
        internal var mLiveStatusChangeAction: ((liveStatus: Int) -> Unit)? = null

        override fun onLiveBzTypeChange(action: (liveBzType: Int) -> Unit) {
            this.mLiveBzTypeChangeAction = action
        }

        override fun onOwUserInfoChange(action: (owUserInfo: LpfUser.UserInfo) -> Unit) {
            this.mOwUserInfoChangeAction = action
        }

        override fun onChannelInfoChange(action: (channelInfo: LpfLiveinfo.ChannelLiveInfo) -> Unit) {
            this.mChannelInfoChangeAction = action
        }

        override fun onRoomInfoV2ExtendChange(action: (msg: String) -> Unit) {
            this.mRoomInfoV2ExtendChangeAction = action
        }

        override fun onChannelCloseChange(action: (channelClose: Boolean) -> Unit) {
            this.mChannelCloseChangeAction = action
        }

        override fun onLiveStatusChange(action: (liveStatus: Int) -> Unit) {
            this.mLiveStatusChangeAction = action
        }
    }
}