package tv.athena.live.component.business.videoarea

import android.view.ViewGroup
import tv.athena.live.api.videoarea.VideoAreaComponentApi
import tv.athena.live.base.arch.IComponentApi

/**
 * Created by qiushunming on 2019-08-07.
 */
class VideoApiImpl(private val mComponent: VideoAreaComponent) : VideoAreaComponentApi {
    override fun getApiKey(): Class<out IComponentApi> {
        return VideoAreaComponentApi::class.java
    }

    override fun switchVideoContainer(sid: String, remoteUid: String, viewContainer: ViewGroup) {
        val viewModel = this.mComponent.viewModel ?: return
        viewModel.switchRemotePreviewContainer(sid, remoteUid, viewContainer)
    }
}
