package tv.athena.live.component.business.link_mic.repository

import com.yy.liveplatform.proto.nano.LpfLiveinterconnect
import com.yy.liveplatform.proto.nano.LpfMedia
import tv.athena.live.utils.ServiceUtils
import tv.athena.live.component.business.broadcasting.repository.BroadcastRepository

class LinkMicRepository {
    //pb servicename
    private val serviceName = "lpfMedia"

    //function 获取可连麦用户列表
    private val getInterConnectUserList = "getInterconnectUserList"

    //function 更新邀请开关
    private val updateInviteSwitch = "updateInviteSwitch"

    //function 获取连麦邀请开关信息
    private val getInviteSwitch = "getInviteSwitch"

    //function 发送/取消 连麦邀请
    private val inviteLiveInterConnect = "inviteLiveInterconnect"

    //function 发送多人 连麦邀请
    private val batchInviteLiveInterconnect = "batchInviteLiveInterconnect"

    //function 邀请单播
    private val inviteLiveInterConnectUnicast = "inviteLiveInterconnectUnicast"

    //function 响应邀请结果
    private val replyInviteLiveInterConnect = "replyInviteLiveInterconnect"

    //function 邀请结果单播
    private val inviteLiveInterConnectResultUnicast = "inviteLiveInterconnectResultUnicast"

    //function 关闭连麦
    private val closeLiveInterConnect = "closeLiveInterconnect"

    //function 连麦断开单播
    private val liveInterConnectEndUnicast = "liveInterconnectEndUnicast"

    //function 连麦心跳
    private val liveInterConnectHeartbeat = "liveInterconnectHeartbeat"

    //function 观众申请连麦
    private val applyConnect = "applyConnect"

    //function 观众申请连麦列表
    private val getApplyconnectList = "getApplyConnectList"

    //function 对位置进行操作(关闭音频、锁住)
    private val opLivePosition = "opLivePosition"

    // function 连麦直连（省略握手)
    private val directLiveInterconnect = "directLiveInterconnect"

    /**
     *   获取可连麦用户列表
     */
    fun getInterConnectUserListReq(
        req: LpfLiveinterconnect.GetInterconnectUserListReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.GetInterconnectUserListResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = getInterConnectUserList
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 更新邀请开关
     */
    fun updateInviteSwitch(
        req: LpfLiveinterconnect.UpdateInviteSwitchResp,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.UpdateInviteSwitchResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = updateInviteSwitch
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 获取连麦邀请开关信息
     */
    fun getInviteSwitchReq(
        req: LpfLiveinterconnect.GetInviteSwitchReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.GetInviteSwitchResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = getInviteSwitch
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 发送 、 取消 连麦邀请
     */
    fun inviteLiveInterConnectReq(
        req: LpfLiveinterconnect.InviteLiveInterconnectReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.InviteLiveInterconnectResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = inviteLiveInterConnect
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 发送多人连麦邀请
     */
    fun batchInviteLiveInterconnectReq(
        req: LpfLiveinterconnect.BatchInviteLiveInterconnectReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.BatchInviteLiveInterconnectResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = batchInviteLiveInterconnect
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 响应连麦邀请
     */
    fun replyInviteLiveInterConnectReq(
        req: LpfLiveinterconnect.ReplyInviteLiveInterconnectReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.ReplyInviteLiveInterconnectResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = replyInviteLiveInterConnect
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 断开连麦
     */
    fun closeLiveInterConnectReq(
        req: LpfLiveinterconnect.CloseLiveInterconnectReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.CloseLiveInterconnectResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = closeLiveInterConnect
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 连麦心跳
     */
    fun liveInterConnectHeartBeatReq(
        req: LpfLiveinterconnect.LiveInterconnectHeartbeatReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.LiveInterconnectHeartbeatResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = liveInterConnectHeartbeat
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     *  观众申请连麦
     */
    fun sendApplyConnectReq(
        req: LpfLiveinterconnect.ApplyConnectReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.ApplyConnectResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = applyConnect
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     *  观众申请连麦列表
     */
    fun getApplyConnectListReq(
        req: LpfLiveinterconnect.GetApplyConnectListReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.GetApplyConnectListResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = getApplyconnectList
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    fun getLiveToken(
        req: LpfMedia.GetLiveTokenReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfMedia.GetLiveTokenResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = BroadcastRepository.FUNC_GET_LIVE_TOKEN
        serviceReq.mServerName = BroadcastRepository.FUNC_MEDIA_SERVER_NAME
        ServiceUtils.send(serviceReq, callback)
    }

    fun opLivePositionReq(
        req: LpfLiveinterconnect.OpLivePositionReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.OpLivePositionResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = opLivePosition
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }

    /**
     * 连麦直连（省略握手）
     */
    fun directLiveInterconnectReq(
        req: LpfLiveinterconnect.DirectLiveInterconnectReq,
        callback: ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.DirectLiveInterconnectResp>
    ) {
        val serviceReq = ServiceUtils.ServiceReq()
        serviceReq.mReqParam = req
        serviceReq.mFunctionName = directLiveInterconnect
        serviceReq.mServerName = serviceName
        ServiceUtils.send(serviceReq, callback)
    }
}