package tv.athena.live.component.business.link_mic

import android.arch.lifecycle.LifecycleOwner
import android.arch.lifecycle.MutableLiveData
import android.arch.lifecycle.Observer
import android.view.ViewGroup
import com.yy.liveplatform.proto.nano.LpfLiveinterconnect
import com.yy.liveplatform.proto.nano.LpfLiveinterconnect.ASSIGN_INVITE
import com.yy.liveplatform.proto.nano.LpfLiveinterconnect.ApplyConnectReq.APPLY
import com.yy.liveplatform.proto.nano.LpfLiveinterconnect.ApplyConnectReq.CANCEL
import com.yy.liveplatform.proto.nano.LpfMedia
import org.jetbrains.annotations.NotNull
import tv.athena.core.axis.Axis
import tv.athena.live.api.IDataCallback
import tv.athena.live.api.broadcast.IBroadcastComponentApi
import tv.athena.live.api.link_mic.ILinkMicService
import tv.athena.live.api.roominfo.RoomInfoApi
import tv.athena.live.api.videoarea.VideoAreaComponentApi
import tv.athena.live.base.arch.IComponentViewModel
import tv.athena.live.base.manager.ComponentContext
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandle
import tv.athena.live.component.business.broadcasting.BroadcastViewModel
import tv.athena.live.component.business.link_mic.repository.LinkMicRepository
import tv.athena.live.utils.ALog
import tv.athena.live.utils.ServiceUtils
import tv.athena.service.api.MessageResponse
import tv.athena.service.api.ServiceFailResult

/**
 *  create by chenhaofeng 2019/8/27
 *  可查看  lpf_liveinterconnect.proto 文件 定义的与服务端接口
 */
class LinkMicViewModel(val component: LinkMicComponent) : IComponentViewModel,
    ILinkMicService.LinkMicUnicastListener {
    companion object {
        const val TAG = "LinkMicViewModel"
        const val IN_VALIED_SID = -1000
    }

    private var mComponentContext: ComponentContext? = null
    private val mLinkMicRepository = LinkMicRepository()
    private var mThunderHandle: ThunderHandle? = null

    private var mVideoAreaComponentApi: VideoAreaComponentApi? = null
    private var mBroadcastApi: IBroadcastComponentApi? = null

    //是否连麦标志
    private var hasLink = HashMap<String, String>()
    private val mApplyConnectUpdateUnicast = MutableLiveData<LpfLiveinterconnect.ApplyConnectUpdateUnicast>()

    private val mLinkHeartCountDownUtil =
        LinkHeartCountDownUtil(Long.MAX_VALUE, 3000, mLinkMicRepository)

    init {
        /*mComponentContext = component.componentContext
        mThunderHandle = mComponentContext?.thunderHandle
        mVideoAreaComponentApi =
            component.componentManager.getOtherComponentApi(VideoAreaComponentApi::class.java)
        mBroadcastApi =
            component.componentManager.getOtherComponentApi(IBroadcastComponentApi::class.java)
        Axis.getService(ILinkMicService::class.java)?.addLinkMicUnicastListener(this)*/
    }

    fun onCreate(component: LinkMicComponent) {
        mComponentContext = component.componentContext
        mThunderHandle = mComponentContext?.thunderHandle
        mVideoAreaComponentApi =
            component.componentManager.getOtherComponentApi(VideoAreaComponentApi::class.java)
        mBroadcastApi =
            component.componentManager.getOtherComponentApi(IBroadcastComponentApi::class.java)
        Axis.getService(ILinkMicService::class.java)?.addLinkMicUnicastListener(this)
    }

    fun onDestroy() {
        mLinkHeartCountDownUtil.cancel()
        Axis.getService(ILinkMicService::class.java)?.removeLinkMicUnicastListener(this)
        Axis.getService(ILinkMicService::class.java)?.removeLinkMicUnicastListener(this)
    }

    private fun resetData() {
        ALog.i(TAG, "resetData()")
    }

    override fun onInviteLiveInterconnect(info: LpfLiveinterconnect.InviteLiveInterconnectUnicast) {
        //todo 修改连麦状态 被邀请状态
        ALog.i(TAG,
            "handleInviteLiveInterconnectUnicast" +
                "[isCancelInvite : ${info.isCancelInvite}]")
    }

    override fun onInviteLiveInterconnectResult(
        info: LpfLiveinterconnect.InviteLiveInterconnectResultUnicast
    ) {
        val isAccept = info.isAccept
        ALog.i(TAG, "handInviteLiveInterconnectResultUnicast [isAccept : $isAccept]")
        if (isAccept) {
            val sid = info.inviteUserInfo?.sid
            val currentId = mComponentContext?.commonViewModel?.sid
            if (currentId != null && currentId != sid) {
                ALog.i(TAG,
                    "handInviteLiveInterconnectResultUnicast [sid : $sid ] != [currentId : $currentId]")
                return
            }
            sid?.let {
                component.componentManager.getOtherComponentApi(RoomInfoApi::class.java)?.getLiveRoomInfo(it)
            }
        }
    }

    override fun onLiveInterconnectEnd(info: LpfLiveinterconnect.LiveInterconnectEndUnicast) {
        //修改连麦状态 断开连麦
        ALog.i(TAG,
            "handleLiveInterconnectEndUnicast 处理连麦断开单播 businessType = ${info.businessType} " +
                "连麦个数：${hasLink.size}")
    }

    /**
     * 申请连麦列表发生改变
     */
    override fun onApplyConnectListUpdated(info: LpfLiveinterconnect.ApplyConnectUpdateUnicast) {
        mApplyConnectUpdateUnicast.value = info
    }

    /**
     * 监听连麦申请列表变化
     */
    fun observeApplyListUpdateEvent(
        owner: LifecycleOwner,
        observer: Observer<LpfLiveinterconnect.ApplyConnectUpdateUnicast>
    ) {
        mApplyConnectUpdateUnicast.observe(owner, observer)
    }

    /**
     *  获取连麦接口
     *  @owner : 有生命周期的LifecycleOwner
     *  @oberver: 观察者，数据变化 回调
     */
    fun getInterConnectUserList(
        callBack: IDataCallback<LpfLiveinterconnect.GetInterconnectUserListResp>?
    ) {
        val sid = mComponentContext?.commonViewModel?.sid
        if (sid == null) {
            ALog.i(TAG, "getInterConnectUserList sid == null")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号未初始化")
            return
        }
        if (sid <= 0L) {
            ALog.i(TAG, "getInterConnectUserList [sid: $sid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号值异常")
            return
        }
        val req = LpfLiveinterconnect.GetInterconnectUserListReq()
        req.sid = sid
        req.businessType = 1
        ALog.i(TAG, "getInterConnectUserList [req: $req]")
        mLinkMicRepository.getInterConnectUserListReq(req,
            object : ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect
            .GetInterconnectUserListResp>() {
                override fun get(): LpfLiveinterconnect.GetInterconnectUserListResp {
                    return LpfLiveinterconnect.GetInterconnectUserListResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: Exception?) {
                    ALog.i(TAG,
                        "getInterConnectUserList onMessageFail ${errorCode.getResultCode()} -- ${ex?.message}")
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.GetInterconnectUserListResp>
                ) {
                    ALog.i(TAG,
                        "getInterConnectUserList onMessageSuccess [code : ${response.message.code}] " +
                            " [list: ${response.message.connectInfoUserList.size}] ")
                    when (response.message.code) {
                        0 -> callBack?.onDataLoaded(response.message)
                        else -> callBack?.onDataNotAvailable(response.message.code,
                            response.descption)
                    }
                }
            })
    }

    /**
     *  指定某个人连麦
     *  @param inviteUid  邀请的用户 uid
     *  @param inviteSid   邀请的用户 sid
     *  @param position 邀请用户应该在什么位置开播 , 默认是1，业务可根据自己的需要使用透传
     *  @param businessType 需要向直播中台服务端 申请bussinessType 传过来
     *  @param mediaType 指定连麦的媒体类型
     *  @param extend  业务拓展字段
     */
    fun sendInviteReq(
        inviteUid: Long,
        inviteSid: Long,
        position: Int,
        @NotNull businessType: Int,
        mediaType: Int,
        extend: String?,
        callBack: IDataCallback<LpfLiveinterconnect.InviteLiveInterconnectResp>?
    ) {
        sendInviteReq(inviteUid, inviteSid, position, extend, businessType, ASSIGN_INVITE, mediaType, callBack)
    }

    /**
     *  指定取消对某个人连麦
     *  取消邀请
     *  @param inviteUid  邀请的用户 uid
     *  @param inviteSid   邀请的用户 sid
     * @param businessType 需要向直播中台服务端 申请bussinessType 传过来
     */
    fun cancelSendInviteReq(
        inviteUid: Long,
        inviteSid: Long,
        @NotNull businessType: Int,
        callBack: IDataCallback<LpfLiveinterconnect.InviteLiveInterconnectResp>?
    ) {
        cancelInviteReq(inviteUid, inviteSid, businessType, ASSIGN_INVITE, callBack)
    }

    /**
     *  @param inviteUid  邀请的用户 uid
     *  @param inviteSid   邀请的用户 sid
     *  @param position 邀请用户应该在什么位置开播 , 默认是1，业务可根据自己的需要使用透传
     *  @param businessType 需要向直播中台服务端 申请bussinessType 传过来
     *  @param inviteType  InviteType = 1 指定某个人； 2 为随机邀请
     */
    private fun sendInviteReq(
        inviteUid: Long,
        inviteSid: Long,
        position: Int = 1,
        extend: String? = "",
        @NotNull businessType: Int,
        @NotNull inviteType: Int,
        mediaType: Int,
        callBack: IDataCallback<LpfLiveinterconnect.InviteLiveInterconnectResp>?
    ) {
        val sid = mComponentContext?.commonViewModel?.sid
        if (sid == null) {
            ALog.i(TAG, "sendInviteReq sid == null")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号没有初始化")
            return
        }
        if (sid <= 0) {
            ALog.i(TAG, "sendInviteReq [sid : $sid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号值异常")
            return
        }
        if (inviteUid <= 0) {
            ALog.i(TAG, "sendInviteReq [inviteUid : $inviteUid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "inviteUid 值异常")
            return
        }
        if (inviteSid <= 0) {
            ALog.i(TAG, "sendInviteReq [inviteSid : $inviteSid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "inviteSid 值异常")
            return
        }
        val req = LpfLiveinterconnect.InviteLiveInterconnectReq()
        req.sid = sid
        req.inviteUid = inviteUid
        req.inviteSid = inviteSid
        req.inviteType = inviteType // 指定用户邀请， 可查看pb 文件
        req.position = position
        req.isCancelInvite = false
        req.extend = extend
        req.businessType = businessType
        req.mediaType = mediaType
        ALog.i(TAG, "sendInviteReq [req : $req]")

        mLinkMicRepository.inviteLiveInterConnectReq(req,
            object : ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect
            .InviteLiveInterconnectResp>() {
                override fun get(): LpfLiveinterconnect.InviteLiveInterconnectResp {
                    return LpfLiveinterconnect.InviteLiveInterconnectResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: java.lang.Exception?) {
                    ALog.i(TAG, "sendInviteReq onMessageFail " +
                        "${errorCode.getResultCode()} -- ${ex?.message}")
                    //这里是新的
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.InviteLiveInterconnectResp>
                ) {
                    ALog.i(TAG, "sendInviteReq onMessageSuccess [code : ${response.message.code}] ")
                    when (response.message.code) {
                        0 -> {
                            callBack?.onDataLoaded(response.message)
                        }
                        else -> {
                            callBack?.onDataNotAvailable(response.message.code, response.message.extend)
                        }
                    }
                }
            })
    }

    /**
     * 批量邀请
     *
     *  @param inviteUidArray  邀请的用户列表 uid
     *  @param inviteSid   邀请的用户 sid
     *  @param startPosition 邀请用户应该在什么位置开播 , 默认是0，由服务器分配
     *  @param businessType 需要向直播中台服务端 申请bussinessType 传过来
     */
    fun sendBatchInviteReq(
        inviteUidArray: LongArray,
        inviteSid: Long,
        startPosition: Int = 0,
        extend: String? = "",
        @NotNull businessType: Int,
        callBack: IDataCallback<LpfLiveinterconnect.BatchInviteLiveInterconnectResp>?
    ) {
        val sid = mComponentContext?.commonViewModel?.sid
        if (sid == null) {
            ALog.i(TAG, "sendBatchInviteReq sid == null")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号没有初始化")
            return
        }
        if (sid <= 0) {
            ALog.i(TAG, "sendBatchInviteReq [sid : $sid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号值异常")
            return
        }
        if (inviteUidArray.isEmpty()) {
            ALog.i(TAG, "sendBatchInviteReq [inviteUidArray : $inviteUidArray]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "inviteUid 值异常")
            return
        }
        if (inviteSid <= 0) {
            ALog.i(TAG, "sendBatchInviteReq [inviteSid : $inviteSid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "inviteSid 值异常")
            return
        }
        val req = LpfLiveinterconnect.BatchInviteLiveInterconnectReq()
        req.sid = sid
        req.inviteUids = inviteUidArray
        req.position = startPosition
        req.extend = extend
        req.businessType = businessType  //
        ALog.i(TAG, "sendBatchInviteReq [req : $req]")

        mLinkMicRepository.batchInviteLiveInterconnectReq(req,
            object : ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.BatchInviteLiveInterconnectResp>() {
                override fun get(): LpfLiveinterconnect.BatchInviteLiveInterconnectResp {
                    return LpfLiveinterconnect.BatchInviteLiveInterconnectResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: java.lang.Exception?) {
                    ALog.i(TAG, "sendBatchInviteReq onMessageFail " +
                        "${errorCode.getResultCode()} -- ${ex?.message}")
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.BatchInviteLiveInterconnectResp>
                ) {
                    ALog.i(TAG, "sendBatchInviteReq onMessageSuccess [code : ${response.message.code}] ")
                    when (response.message.code) {
                        0 -> {
                            callBack?.onDataLoaded(response.message)
                        }
                        else -> {
                            callBack?.onDataNotAvailable(response.message.code, response.message.message)
                        }
                    }
                }
            })
    }

    private fun cancelInviteReq(
        inviteUid: Long,
        inviteSid: Long,
        @NotNull businessType: Int,
        @NotNull inviteType: Int,
        callBack: IDataCallback<LpfLiveinterconnect.InviteLiveInterconnectResp>?
    ) {
        val sid = mComponentContext?.commonViewModel?.sid
        if (sid == null) {
            ALog.i(TAG, "cancelSendInviteReq sid == null")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号没有初始化")
            return
        }
        if (sid <= 0) {
            ALog.i(TAG, "cancelSendInviteReq [sid : $sid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号 值异常")
            return
        }
        if (inviteUid <= 0) {
            ALog.i(TAG, "cancelSendInviteReq [inviteUid : $inviteUid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "inviteUid 值异常")
            return
        }
        if (inviteSid <= 0) {
            ALog.i(TAG, "cancelSendInviteReq [inviteSid : $inviteSid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "inviteSid 值异常")
            return
        }

        val req = LpfLiveinterconnect.InviteLiveInterconnectReq()
        req.sid = sid
        req.inviteUid = inviteUid
        req.inviteSid = inviteSid
        req.inviteType = inviteType
        req.isCancelInvite = true
        req.businessType = businessType  //
        ALog.i(TAG, "cancelInviteReq [req : $req]")

        mLinkMicRepository.inviteLiveInterConnectReq(req,
            object : ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect
            .InviteLiveInterconnectResp>() {
                override fun get(): LpfLiveinterconnect.InviteLiveInterconnectResp {
                    return LpfLiveinterconnect.InviteLiveInterconnectResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: java.lang.Exception?) {
                    ALog.i(TAG, "cancelSendInviteReq onMessageFail " +
                        "${errorCode.getResultCode()} - ${errorCode.description}")
                    //todo 发起邀请失败需要返回信息
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.InviteLiveInterconnectResp>
                ) {
                    ALog.i(TAG, "cancelSendInviteReq onMessageSuccess [${response.message.code}] ")
                    when (response.message.code) {
                        0 -> {
                            //这里是新的暂时可用
                            callBack?.onDataLoaded(response.message)
                        }
                        //处理邀请失败各种问题
                        else -> {
                            callBack?.onDataNotAvailable(response.message.code, response.message.extend)
                        }
                    }
                }
            })
    }

    /**
     *  被邀请方 接受 响应连麦邀请结果
     *
     *  @param replyInviteUserInfo  B 邀请 A, A 回复B， 那么这里填写的时 B的信息，邀请方信息
     *  @param businessType 需要向直播中台服务端 申请 bussinessType 传过来
     *  @param mediaType 连麦媒体类型，忽略或者把邀请接口带来的mediaType传进来即可
     */
    fun acceptInviteLiveInterconnectReq(
        replyInviteUserInfo: LpfLiveinterconnect.LiveInterconnectInfo,
        businessType: Int,
        position: Int,
        mediaType: Int,
        extend: String? = "",
        callBack: IDataCallback<LpfLiveinterconnect.ReplyInviteLiveInterconnectResp>? = null
    ) {
        val sid = mComponentContext?.commonViewModel?.sid
        if (sid == null) {
            ALog.i(TAG, "acceptInviteLiveInterconnectReq sid == null")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号没有初始化")
            return
        }
        if (sid <= 0) {
            ALog.i(TAG, "acceptInviteLiveInterconnectReq [sid: $sid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号值异常")
            return
        }
        val req = LpfLiveinterconnect.ReplyInviteLiveInterconnectReq()
        req.sid = sid
        req.isAccept = true
        req.replyInviteUserInfo = replyInviteUserInfo
        req.businessType = businessType  //普通连麦
        req.isAutoReject = false //是否时自动取消， 倒计时结束调用
        req.position = position
        req.mediaType = mediaType
        req.extend = extend
        ALog.i(TAG, "acceptInviteLiveInterconnectReq [req : $req]")
        mLinkMicRepository.replyInviteLiveInterConnectReq(req,
            object : ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect
            .ReplyInviteLiveInterconnectResp>() {
                override fun get(): LpfLiveinterconnect.ReplyInviteLiveInterconnectResp {
                    return LpfLiveinterconnect.ReplyInviteLiveInterconnectResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: java.lang.Exception?) {
                    //回复连麦失败处理
                    ALog.i(TAG,
                        "acceptInviteLiveInterconnectReq onMessageFail [code : ${errorCode.getResultCode()}]")
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.ReplyInviteLiveInterconnectResp>
                ) {
                    ALog.i(TAG,
                        "acceptInviteLiveInterconnectReq onMessageSuccess [code : ${response.message.code}]")
                    when (response.message.code) {
                        0 -> {
                            callBack?.onDataLoaded(response.message)
                            component.componentManager.getOtherComponentApi(RoomInfoApi::class.java)
                                ?.getLiveRoomInfo(sid)
                        }
                        else -> {
                            callBack?.onDataNotAvailable(response.message.code, response.descption)
                        }
                    }
                }
            })
    }

    /**
     * 被邀请方 拒绝 响应连麦邀请结果
     *
     *  @param isAutoReject 是否时超时处理，倒计时关闭后设置
     *  @param businessType 需要向直播中台服务端 申请bussinessType 传过来
     *  @param 响应对方的信息  B 邀请 A, A 回复B， 那么这里填写的时 B的信息，邀请方信息
     */
    fun refuseInviteLiveInterconnectReq(
        replyInviteUserInfo: LpfLiveinterconnect.LiveInterconnectInfo,
        businessType: Int,
        position: Int,
        isAutoReject: Boolean = false,
        callBack: IDataCallback<LpfLiveinterconnect.ReplyInviteLiveInterconnectResp>?
    ) {
        val sid = mComponentContext?.commonViewModel?.sid
        if (sid == null) {
            ALog.i(TAG, "refuseInviteLiveInterconnectReq sid == null")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号为初始化")
            return
        }
        Axis.getService(ILinkMicService::class.java)
            ?.refuseInviteLiveInterconnectReq(sid, replyInviteUserInfo,
                businessType, position, isAutoReject, callBack)
    }

    /**
     * 断开连麦
     * @param businessType 需要向直播中台服务端 申请bussinessType 传过来
     */
    fun closeLiveInterconnectReq(
        closeUid: Long,
        businessType: Int,
        extend: String? = "",
        callBack: IDataCallback<LpfLiveinterconnect.CloseLiveInterconnectResp>? = null
    ) {
        val sid = mComponentContext?.commonViewModel?.sid
        if (sid == null) {
            ALog.i(TAG, "closeLiveInterconnectReq sid == null")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号未初始化")
            return
        }
        if (sid <= 0) {
            ALog.i(TAG, "closeLiveInterconnectReq [sid : $sid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "当前频道号值异常")
            return
        }
        if (closeUid <= 0) {
            ALog.i(TAG, "closeLiveInterconnectReq [closeUid : $closeUid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "closeUid 值异常")
            return
        }
        val req = LpfLiveinterconnect.CloseLiveInterconnectReq()
        req.sid = sid
        req.businessType = businessType
        req.closeUid = closeUid
        req.extend = extend
        ALog.i(TAG, "closeLiveInterconnectReq [req : $req]")
        mLinkMicRepository.closeLiveInterConnectReq(req,
            object : ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect
            .CloseLiveInterconnectResp>() {
                override fun get(): LpfLiveinterconnect.CloseLiveInterconnectResp {
                    return LpfLiveinterconnect.CloseLiveInterconnectResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: java.lang.Exception?) {
                    ALog.i(TAG,
                        "closeLiveInterconnectReq onMessageFail [code : ${errorCode.getResultCode()}]")
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.CloseLiveInterconnectResp>
                ) {
                    ALog.i(TAG,
                        "closeLiveInterconnectReq onMessageSuccess [code : ${response.message.code}]")
                    //这里是新的
                    when (response.message.code) {
                        0 -> callBack?.onDataLoaded(response.message)
                        else -> callBack?.onDataNotAvailable(response.message.code,
                            response.descption)
                    }
                    //断开连麦成功主动再去查一次房间信息
                    component.componentManager.getOtherComponentApi(RoomInfoApi::class.java)
                        ?.getLiveRoomInfo(sid)
                }
            })
        //reset 所有数据
        resetData()
    }

    fun switchVideoContainer(sid: String, remoteUid: String, viewContainer: ViewGroup, businessType: Int) {
        component.componentManager.getOtherComponentApi(VideoAreaComponentApi::class.java)
            ?.switchVideoContainer(sid, remoteUid, viewContainer)
        hasLink[remoteUid] = sid
    }

    /**
     * 同频道，观众申请连麦
     * @param anchorUid  主播uid
     * @param businessType 这个需要浩津提供 businessType
     * @param connectOpType  pb文件定义是否申请，取消
     * @param owner 有生命周期组件
     * @param observer 观察者
     */
    private fun sendApplyConnectReq(
        anchorUid: Long,
        businessType: Int,
        sid: Long,
        connectOpType: Int,
        callBack: IDataCallback<LpfLiveinterconnect.ApplyConnectResp>?
    ) {
        if (anchorUid <= 0) {
            ALog.i(TAG, "sendApplyConnectReq [anchorUid : $anchorUid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "anchorUid 值异常")
            return
        }
        if (sid <= 0) {
            ALog.i(TAG, "sendApplyConnectReq [sid : $sid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "sid 值异常")
            return
        }
        val req = LpfLiveinterconnect.ApplyConnectReq()
        req.sid = sid
        req.anchorUid = anchorUid
        req.businessType = businessType
        req.opType = connectOpType
        ALog.i(TAG,
            "sendApplyConnectReq [req : $req]")
        mLinkMicRepository.sendApplyConnectReq(req,
            object :
                ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.ApplyConnectResp>() {
                override fun get(): LpfLiveinterconnect.ApplyConnectResp {
                    return LpfLiveinterconnect.ApplyConnectResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: java.lang.Exception?) {
                    ALog.i(TAG, "sendApplyConnectReq onMessageFail $errorCode ")
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.ApplyConnectResp>
                ) {
                    ALog.i(TAG,
                        "sendApplyConnectReq onMessageSuccess [code : ${response.message.code}]")
                    when (response.message.code) {
                        0 -> callBack?.onDataLoaded(response.message)
                        else -> callBack?.onDataNotAvailable(response.message.code,
                            response.descption)
                    }
                }
            })
    }

    /**
     * 观众申请连麦
     *
     */
    fun applyConnectReq(
        anchorUid: Long,
        businessType: Int,
        sid: Long,
        callback: IDataCallback<LpfLiveinterconnect.ApplyConnectResp>?
    ) {
        sendApplyConnectReq(anchorUid, businessType, sid, APPLY, callback)
    }

    /**
     * 观众取消连麦
     */
    fun cancelApplyConnectReq(
        anchorUid: Long,
        businessType: Int,
        sid: Long,
        callback: IDataCallback<LpfLiveinterconnect.ApplyConnectResp>?
    ) {
        sendApplyConnectReq(anchorUid, businessType, sid, CANCEL, callback)
    }

    /**
     * 获取观众申请连麦列表
     */
    fun getApplyConnectListReq(
        anchorUid: Long,
        businessType: Int,
        sid: Long,
        callBack: IDataCallback<LpfLiveinterconnect.GetApplyConnectListResp>?
    ) {
        val req = LpfLiveinterconnect.GetApplyConnectListReq()
        if (anchorUid <= 0) {
            ALog.i(TAG, "getApplyConnectListReq [anchorUid : $anchorUid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "anchorUid 值异常")
            return
        }
        if (sid <= 0) {
            ALog.i(TAG, "getApplyConnectListReq [sid : $sid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "sid 值异常")
            return
        }
        req.sid = sid
        req.anchorUid = anchorUid
        req.businessType = businessType
        ALog.i(TAG,
            "getApplyConnectListReq [req : $req]")
        mLinkMicRepository.getApplyConnectListReq(req,
            object :
                ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.GetApplyConnectListResp>() {
                override fun get(): LpfLiveinterconnect.GetApplyConnectListResp {
                    return LpfLiveinterconnect.GetApplyConnectListResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: java.lang.Exception?) {
                    ALog.i(TAG, "getApplyConnectListReq onMessageFail $errorCode ")
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.GetApplyConnectListResp>
                ) {
                    ALog.i(TAG,
                        "getApplyConnectListReq onMessageSuccess [code : ${response.message.code}]")
                    when (response.message.code) {
                        0 -> callBack?.onDataLoaded(response.message)
                        else -> callBack?.onDataNotAvailable(response.message.code,
                            response.descption)
                    }
                }
            })
    }

    /**
     * takeMic 后续应该迁移到开播模块，以后LinkeMicViewModel 模块纯粹是用来进行
     * 连麦握手
     *
     */
    fun takeMic(
        uid: String,
        isEnable: Boolean,
        businessType: Int,
        callBack: IDataCallback<Int>?
    ) {
        ALog.i(TAG, "takeMic($uid, $isEnable, $businessType)")
        if (isEnable) {
            val sid = mComponentContext?.commonViewModel?.sid
            if (sid == null) {
                ALog.i(TAG, "takeMic sid == null")
                return
            }
            if (sid <= 0) {
                ALog.i(TAG, "takeMic [sid : $sid] invalied")
                return
            }
            ALog.i(TAG, "takeMic [sid: $sid)")
            val req = LpfMedia.GetLiveTokenReq()
            req.sid = sid
            mLinkMicRepository.getLiveToken(req,
                object : ServiceUtils.SvcResultCusRetryCallBack<LpfMedia.GetLiveTokenResp>() {
                    override fun get(): LpfMedia.GetLiveTokenResp {
                        return LpfMedia.GetLiveTokenResp()
                    }

                    override fun onMessageFail(
                        errorCode: ServiceFailResult,
                        ex: java.lang.Exception?
                    ) {
                        ALog.i(BroadcastViewModel.TAG, "getLiveToken() onMessageFail() $errorCode")
                        callBack?.onDataNotAvailable(errorCode.getResultCode(),
                            errorCode.description)
                    }

                    override fun onMessageSuccess(
                        response: MessageResponse<LpfMedia.GetLiveTokenResp>
                    ) {
                        ALog.i(BroadcastViewModel.TAG, "takeMic $isEnable")
                        val code = response.message.code
                        when (code) {
                            0 -> {
                                hasLink[uid] = sid.toString()
                                //updateVideoEncoderConfig(businessType)
                                mBroadcastApi?.takeMic(isEnable)
                                mThunderHandle
                                    ?.updateToken(response.message.token.toByteArray())
                                callBack?.onDataLoaded(0)
                            }
                            else -> {
                                ALog.i(TAG, "getLiveToken() code = $code")
                                callBack?.onDataNotAvailable(code, response.descption)
                            }
                        }
                    }
                })
        } else {
            hasLink.remove(uid)
            //updateVideoEncoderConfig(businessType)
            mBroadcastApi?.takeMic(isEnable)
            callBack?.onDataLoaded(0)
            ALog.i(TAG, "takeMic size = ${hasLink.size}")
        }
    }

    /**
     *  仅仅用来操作锁住麦位
     *  @param opType  1 为open  2为
     */
    fun opLivePositionReq(
        opUid: Long,
        opPosition: Int,
        opObject: Int,
        opType: Int,
        callBack: IDataCallback<LpfLiveinterconnect.OpLivePositionResp>?
    ) {
        val req = LpfLiveinterconnect.OpLivePositionReq()
        val sid = mComponentContext?.commonViewModel?.sid
        if (opUid <= 0) {
            ALog.i(TAG, "opLivePositionReq [opUid : $opUid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "opUid 值异常")
            return
        }
        if (sid == null) {
            ALog.i(TAG, "opLivePositionReq sid == null")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "sid 当前值未初始化")
            return
        }
        if (sid <= 0) {
            ALog.i(TAG, "opLivePositionReq [sid: $sid]")
            callBack?.onDataNotAvailable(IN_VALIED_SID, "sid 值异常")
            return
        }
        req.sid = sid
        req.opUid = opUid
        req.opPosition = opPosition
        req.opObject = opObject
        req.opType = opType
        ALog.i(TAG, "opLivePositionReq [req: $req]")
        mLinkMicRepository.opLivePositionReq(req,
            object :
                ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.OpLivePositionResp>() {
                override fun get(): LpfLiveinterconnect.OpLivePositionResp {
                    return LpfLiveinterconnect.OpLivePositionResp()
                }

                override fun onMessageFail(
                    errorCode: ServiceFailResult,
                    ex: java.lang.Exception?
                ) {
                    ALog.i(TAG, "opLivePositionReq onMessageFail $errorCode")
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.OpLivePositionResp>
                ) {
                    val code = response.message.code
                    if (code == 0) {
                        ALog.i(TAG, "opLivePositionReq success")
                        callBack?.onDataLoaded(response.message)
                    } else {
                        ALog.i(TAG,
                            "opLivePositionReq fail code:${response.message.code},message:${
                                response.message
                                    .message
                            }")
                        callBack?.onDataNotAvailable(response.message.code,
                            response.descption)
                    }
                }
            })
    }


    /**
     * 连麦直连（省略握手）
     * @param businessType 连麦类型
     * @param mediaType 用户使用媒体类型 （LpfMedia.MT_AUD LpfMedia.MT_VIDEO LpfMedia.MT_NONE)
     * @param connectTuple 直连数组信息
     */
    fun directLiveInterconnectReq(
        businessType: Int,
        mediaType: Int,
        connectTuple: Array<LpfLiveinterconnect.ConnectTuple>,
        callBack: IDataCallback<LpfLiveinterconnect.DirectLiveInterconnectResp>?
    ) {
        val req = LpfLiveinterconnect.DirectLiveInterconnectReq()
        req.businessType = businessType
        req.mediaType = mediaType
        req.connectTuples = connectTuple
        mLinkMicRepository.directLiveInterconnectReq(req,
            object :
                ServiceUtils.SvcResultCusRetryCallBack<LpfLiveinterconnect.DirectLiveInterconnectResp>() {
                override fun get(): LpfLiveinterconnect.DirectLiveInterconnectResp {
                    return LpfLiveinterconnect.DirectLiveInterconnectResp()
                }

                override fun onMessageFail(errorCode: ServiceFailResult, ex: java.lang.Exception?) {
                    ALog.i(TAG, "directLiveInterconnectReq onMessageFail $errorCode ")
                    callBack?.onDataNotAvailable(errorCode.getResultCode(), errorCode.description)
                }

                override fun onMessageSuccess(
                    response: MessageResponse<LpfLiveinterconnect.DirectLiveInterconnectResp>
                ) {
                    ALog.i(TAG,
                        "directLiveInterconnectReq onMessageSuccess [code : ${response.message.code}]")
                    if (response.message.code == 0) {
                        callBack?.onDataLoaded(response.message)
                    } else {
                        callBack?.onDataNotAvailable(response.message.code, response.descption)
                    }
                }
            })
    }
}