package tv.athena.live.component.business.broadcasting.accessibility.time

import android.os.CountDownTimer
import tv.athena.live.component.business.broadcasting.BroadcastViewModel
import tv.athena.live.utils.ALog

/**
 *    create by chenhaofeng 2019-07-23
 *
 *
 */
class TimerApiImpl : ITimerApi {
    private val TAG = BroadcastViewModel.TAG
    var second = 0L
    private var mObserveTimeListener: ObserTimeListener? = null
    private var hasStartTime = false

    companion object {
        var MIN_IN_SEC = 60
        var HOUR_IN_MIN = 60 * 60
        var SECOND: Long = 0
        var MINUTE: Long = 0
        var HOUR: Long = 0

        @JvmStatic
        val FINAL_TIME: StringBuilder by lazy {
            StringBuilder("00:00:00")
        }
    }

    private val mCountDownTimer: CountDownTimer = object : CountDownTimer(Long.MAX_VALUE, 1000) {
        override fun onFinish() {
        }

        override fun onTick(millisUntilFinished: Long) {
            HOUR = second / HOUR_IN_MIN
            MINUTE = (second % HOUR_IN_MIN) / MIN_IN_SEC
            SECOND = (second % HOUR_IN_MIN) % MIN_IN_SEC
            FINAL_TIME.delete(0, FINAL_TIME.length)
            FINAL_TIME.append(if (HOUR < 10) "0$HOUR" else HOUR)
                .append(":")
                .append(if (MINUTE < 10) "0$MINUTE" else MINUTE)
                .append(":")
                .append(if (SECOND < 10) "0$SECOND" else SECOND)
            second++
            mObserveTimeListener?.changeLiveTime(second)
            mObserveTimeListener?.changeLiveTimeStr(
                FINAL_TIME.toString())
        }
    }

    override fun startTimer() {
        ALog.i(TAG, "startTimer [hasStartTime : $hasStartTime]")
        if (!hasStartTime) {
            mCountDownTimer.start()
            return
        }
    }

    override fun stopTimer() {
        ALog.i(TAG, "stopTimer() second = $second")
        second = 0
        SECOND = 0
        MINUTE = 0
        HOUR = 0
        mCountDownTimer.cancel()
        hasStartTime = false
    }

    override fun addObserTimeListener(listener: ObserTimeListener) {
        ALog.i(TAG, "addObserTimeListener  $listener")
        this.mObserveTimeListener = listener
    }
}