package tv.athena.live.component.business.broadcasting

import com.yy.liveplatform.proto.nano.LpfMedia
import tv.athena.live.api.IDataCallback
import tv.athena.live.api.broadcast.bean.StartLiveParams

interface IBroadcast {
    fun setComponent(component: BroadcastComponent)

    fun onLeave()

    fun onDestroy()

    /**
     * 上传封面
     */
    fun uploadCoverUrl(imagePath: String, callback: IDataCallback<String>?)

    /**
     * 开启推流
     * @param title 开播标题
     * @param uploadCoverUrl 开播上传的封面地址
     * @param liveBzType 开播类型
     * @param extend 拓展字段
     */
    fun startLive(
        title: String,
        coverUrl: String,
        extend: String?,
        liveBzType: Int,
        audioSourceType: Int,
        callBack: IDataCallback<Int>?
    )

    fun startLive(startLiveParams: StartLiveParams)

    /**
     * @param callback 该回调只是回调 调用服务端 endLive 接口成功后，服务端返回的数据
     * 如果请求失败，并不会妨碍到客户端SDK 调用leaveRoom
     * 如果不需要回调数据 ，可以直接使用 @link { stopLive() }
     */
    fun stopLive(extend: String? = null, callback: IDataCallback<LpfMedia.EndLiveResp>?)

    fun startPublishStream()

    fun stopPublishStream()

    fun takeMic(isEnable: Boolean)

    fun checkLivePermission(
        liveBzType: Int,
        callBack: IDataCallback<LpfMedia.CheckLivePermissionResp>
    )

    /**
     * 改变房间类型
     * @param liveBzType 房间类型
     * @param callBack 结果回调
     */
    fun changeLiveRoomType(liveBzType: Int, callBack: IDataCallback<LpfMedia.ChangeLiveRoomTypeResp>)

    /**
     * 改变麦位媒体类型
     * @param mediaType 媒体类型
     * @param callBack 结果回调
     * @see LpfMedia.MT_NONE
     * @see LpfMedia.MT_AV
     * @see LpfMedia.MT_AUD
     * @see LpfMedia.MT_VIDEO
     */
    fun changeLiveMediaType(mediaType: Int, callBack: IDataCallback<LpfMedia.UpdateMediaTypeResp>)
}