package tv.athena.live.component.business.broadcasting

import tv.athena.live.api.broadcast.IBroadcastComponentApi
import tv.athena.live.base.mvvmImpl.MvvmComponent
import tv.athena.live.utils.ALog

/**
 *    create by chenhaofeng 2019-08-13
 *
 *
 */

class BroadcastComponent :
    MvvmComponent<IBroadcastComponentApi, BroadcastView, BroadcastViewModel>() {
    private val TAG = "BroadcastComponent"
    private var mBroadcastView: BroadcastView? = null
    private var mBroadcastViewModel: BroadcastViewModel? = null
    private var mBroadcastComponentApiImpl: IBroadcastComponentApi? = null
    override fun onAllComponentsReady() {
        (mBroadcastComponentApiImpl as? BroadcastComponentApiImpl)?.setComponent(this)
    }

    override fun onCreateApi(): IBroadcastComponentApi {
        val thunderHandle = componentManager.componentContext.thunderHandle
        mBroadcastComponentApiImpl = BroadcastComponentApiImpl(thunderHandle!!)
        return mBroadcastComponentApiImpl!!
    }

    override fun onCreateView(): BroadcastView {
        mBroadcastView = BroadcastView().apply {
            setComponent(this@BroadcastComponent)
        }
        return mBroadcastView!!
    }

    override fun onCreateViewModel(): BroadcastViewModel {
        mBroadcastViewModel = BroadcastViewModel().apply {
            setComponent(this@BroadcastComponent)
        }
        return mBroadcastViewModel!!
    }

    override fun onCreate() {
        super.onCreate()
        ALog.i(TAG, "onCreate")
        mBroadcastViewModel?.onCreate(this@BroadcastComponent)
        (mBroadcastComponentApiImpl as? BroadcastComponentApiImpl)?.onCreate(this)
    }

    override fun onLeave() {
        mBroadcastComponentApiImpl?.onLeave()
        mBroadcastViewModel?.onLeave()
    }

    override fun onDestroy() {
        super.onDestroy()
        ALog.i(TAG, "onDestroy")
        mBroadcastViewModel?.onDestroy()
        mBroadcastView?.onDestroy()
        mBroadcastComponentApiImpl?.onDestroy()
    }
}