package tv.athena.live.component.business.audience;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;

import com.yy.liveplatform.proto.nano.LpfUser;

import java.util.List;

import tv.athena.live.api.audience.AudienceApi;
import tv.athena.live.base.arch.IComponentApi;

/**
 * liaojidong
 *
 * @Data 2019/8/21
 */
public class AudienceApiImpl implements AudienceApi {
    private AudienceComponent mComponent;

    public AudienceApiImpl(AudienceComponent component) {
        this.mComponent = component;
    }

    @Override
    public void observeChannelUsers(LifecycleOwner owner, Observer<List<LpfUser.UserInfo>> observer) {
        if (this.mComponent != null
            && this.mComponent.getViewModel() != null) {
            this.mComponent.getViewModel().observeChannelUsers(owner, observer);
        }
    }

    @Override
    public void observeUserCount(LifecycleOwner owner, Observer<String> observer) {
        if (this.mComponent != null
            && this.mComponent.getViewModel() != null) {
            this.mComponent.getViewModel().observeUserCount(owner, observer);
        }
    }

    @Override
    public void getChannelUsers(int pageSize,
                                int offset,
                                OnChannelQueryListener listener) {
        if (this.mComponent != null
            && this.mComponent.getViewModel() != null) {
            this.mComponent.getViewModel().getChannelUsers(pageSize, offset, listener);
        }
    }

    @Override
    public Class<? extends IComponentApi> getApiKey() {
        return AudienceApi.class;
    }
}
