package tv.athena.live.component.business.activitybar.webview.jsapi

import tv.athena.live.api.activitybar.service.IJsApiModule
import java.util.concurrent.ConcurrentHashMap

object JsApiModuleEx {
    private var modules: MutableMap<String, IJsApiModule> = ConcurrentHashMap()

    val all: Map<String, IJsApiModule>
        get() = modules

    fun addJsApiModule(iApiModule: IJsApiModule) {
        val apiModule = modules.remove(iApiModule.moduleName())
        apiModule?.release()
        modules[iApiModule.moduleName()] = iApiModule
    }

    fun clear() {
        for (key in modules.entries) {
            key?.value?.release()
        }
        modules.clear()
    }
}
