package tv.athena.live.component.business.activitybar.webview.jsapi;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.Looper;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;

import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.api.activitybar.service.IJsSupportWebApi;
import tv.athena.live.utils.ALog;
import tv.athena.live.component.business.activitybar.webview.model.ResultData;
import tv.athena.live.component.business.activitybar.webview.util.JsonParser;

import java.lang.ref.WeakReference;

public class JavaScriptInterface {
    private static final String TAG = "JavaScriptInterface";

    private WeakReference<WebView> webViewHolder = null;
    private WeakReference<IJsSupportWebApi> jsWebApiHodler = null;
    public static final String INVOKE_WEB_METHOD =
        "javascript:try{window.YYApiCore.invokeWebMethod('%s',JSON.parse(%s))}catch(e){if(console)console.log(e)}";

    public JavaScriptInterface(WebView view, IJsSupportWebApi webApi) {
        if (view != null) {
            webViewHolder = new WeakReference<>(view);
        }
        if (webApi != null) {
            jsWebApiHodler = new WeakReference<>(webApi);
        }
    }

    private ApiModuleManager v2ApiModuleManager = new ApiModuleManager();

    public void addApiModule(IJsApiModule module) {
        v2ApiModuleManager.addModule(module);
    }

    public void removeApiModule(String moduleName) {
        v2ApiModuleManager.removeModuleByName(moduleName);
    }

    @TargetApi(11)
    public void release() {
        if (v2ApiModuleManager != null) {
            v2ApiModuleManager.release();
        }
    }

    /*
     * web端API将此方法包装为 invokeClientMethod
     * */
    @JavascriptInterface
    public String invoke(final String module, final String name, final String parameters, final String callback) {
        ALog.i(TAG,
            "JavascriptInterface invoke module = " + module + ", name = " + name
                + ", parameters = " + parameters + ", callback = " + callback);
        try {
            IJsApiModule apiModule = v2ApiModuleManager.getModule(module);
            if (apiModule != null) {
                IJsSupportWebApi webApi = null;
                if (jsWebApiHodler != null) {
                    webApi = jsWebApiHodler.get();
                }
                String result = apiModule.invoke(name, parameters, callback, webApi);
                return result;
            }
        } catch (Throwable e) {
            ALog.e(TAG, "invoke module = " + module + ", name = " + name + ", parameters = " + parameters +
                ", error happen e = " + e, e);
        }
        return JsonParser.toJson(new ResultData(-1));
    }

    private Handler mtHandler = new Handler(Looper.getMainLooper());

    private void invokeJSCallback(final String cbName, final String jsonParam) {
        if (webViewHolder != null) {
            final WebView webView = webViewHolder.get();
            if (webView != null) {
                mtHandler.post(() -> {
                    try {
                        String invokeStr = String.format(INVOKE_WEB_METHOD, cbName, jsonParam);
                        webView.loadUrl(invokeStr);
                    } catch (Exception e) {
                        ALog.e(TAG, "", e);
                    }
                });
            }
        }
    }

    private IJsApiModule.IJSCallback genJSCallback(final String callbackName) {
        if (callbackName != null && callbackName.length() > 0) {
            return param -> invokeJSCallback(callbackName, param);
        }
        return null;
    }

}
