package tv.athena.live.component.business.activitybar.webview.jsapi;

import java.util.LinkedHashMap;
import java.util.Map;

import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.utils.ALog;

public class ApiModuleManager implements IApiModuleManager {
    private static final String TAG = "ApiModuleManager";

    private Map<String, IJsApiModule> apiModuleMap = new LinkedHashMap<>();

    public ApiModuleManager() {
        /*
         * 数据API在此静态注册
         * UI上下文相关API在ACT动态注册
         * */
    }

    @Override
    public void addModule(IJsApiModule apiModule) {
        if (apiModule.moduleName() != null && apiModule.moduleName().length() > 0) {
            apiModuleMap.put(apiModule.moduleName(), apiModule);
        } else {
            ALog.w(TAG, "invalid module name, skip mapping.");
        }
    }

    @Override
    public void removeModule(IJsApiModule apiModule) {
        apiModuleMap.remove(apiModule);
        apiModule.release();
    }

    @Override
    public void removeModuleByName(String name) {
        IJsApiModule apiModule = apiModuleMap.get(name);
        if (apiModule != null) {
            removeModule(apiModule);
        }
    }

    @Override
    public IJsApiModule getModule(String name) {
        return apiModuleMap.get(name);
    }

    public void release() {
        for (Map.Entry<String, IJsApiModule> entry : apiModuleMap.entrySet()) {
            entry.getValue().release();
        }
        apiModuleMap.clear();
    }
}