package tv.athena.live.component.business.activitybar.webview.fragment;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.ValueCallback;
import android.widget.FrameLayout;

import tv.athena.live.api.activitybar.bean.ActivityBarConfig;
import tv.athena.live.api.activitybar.bean.EntryData;
import tv.athena.live.api.activitybar.service.IWebViewUIClient;
import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.api.activitybar.service.IJsSupportWebApi;
import tv.athena.live.component.business.activitybar.utils.ActivityUtils;
import tv.athena.live.component.business.activitybar.webview.model.WebViewParam;
import tv.athena.live.component.business.activitybar.webview.util.HttpsParser;

import org.json.JSONException;
import org.json.JSONObject;

import tv.athena.live.utils.ALog;
import tv.athena.live.utils.UIUtils;
import tv.athena.util.FP;

/**
 * Created by xudadade on 2019/3/26
 */
public class WebViewDialogFragment extends DialogFragment implements IJsSupportWebApi {
    final static private String TAG = "WebViewDialogFragment";
    private WebViewFragment mWebViewFragment;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private IWebViewUIClient mIWebViewUIClient;
    protected String mPageDefBackStyle;
    private long mOwnerUid;
    private long mSid;
    private String mOwnerName;
    private DialogBuilder mDialogBuilder;

    private Activity activity;

    private ActivityBarConfig config;
    private int mStyle = ActivityUtils.NO_SET;
    private int mHeight = -1;
    private int mWidth = -1;
    private String mGravity;
    private boolean isFullScreen = false;
    private boolean isShowTitle = false;

    public static WebViewDialogFragment newInstance(String url, int feature,
                                                    String configJson) {
        WebViewDialogFragment fragment = new WebViewDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("url", HttpsParser.convertToHttps(url));
        bundle.putInt("feature", feature);
        bundle.putString("configUI", configJson);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void setActivityBarConfig(ActivityBarConfig config) {
        this.config = config;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (mWebViewFragment != null) {
            mWebViewFragment.setIJsSupportWebApi(this);
            mWebViewFragment.onCreate(savedInstanceState);
        }
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (mOnDismissListener != null) {
            mOnDismissListener.onDismiss(dialog);
        }
    }

    @NonNull
    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (mDialogBuilder != null) {
            return mDialogBuilder.onCreateDialog();
        }
        /*int style = R.style.transparent;
        if (mStyle > 0) {
            style = mStyle;
        }*/

        int gravity = Gravity.BOTTOM;
        if (!TextUtils.isEmpty(mGravity)) {
            switch (mGravity) {
                case "TOP":
                    gravity = Gravity.TOP;
                    break;
                case "CENTER":
                    gravity = Gravity.CENTER;
                    break;
                default:
                    gravity = Gravity.BOTTOM;
                    break;
            }
        }
        //  R.style.GrowWebviewDialog
        Dialog dialog = new Dialog(getActivity()) {
            @Override
            public void onBackPressed() {
                ALog.i(TAG, "onBackPressed");
                if (!onBackPressedHandler()) {
                    super.onBackPressed();
                }
            }
        };

        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setCanceledOnTouchOutside(true);
        Window window = dialog.getWindow();
        window.setDimAmount(0.2f);
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.gravity = gravity;
        lp.width = WindowManager.LayoutParams.MATCH_PARENT;
        window.setAttributes(lp);
        //window.getAttributes().windowAnimations = R.style.WebviewDialogAnimation;
        return dialog;
    }

    public void setWebViewUIClient(IWebViewUIClient client) {
        mIWebViewUIClient = client;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        View view = mWebViewFragment.onCreateView(inflater, container, savedInstanceState);
        addTitle();
        return view;
    }

    private void addTitle() {
        FrameLayout fl = mWebViewFragment.getTitleContainer();
        if (fl == null) {
            return;
        }
        if (isShowTitle) {
            if (config != null && config.getIConfigNavigation() != null) {
                View titleView = config.getIConfigNavigation().getTitleView();
                if (titleView != null) {
                    FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(
                        FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.MATCH_PARENT
                    );
                    fl.addView(titleView, lp);
                    fl.setVisibility(View.VISIBLE);
                }

                View back = config.getIConfigNavigation().getBackView();
                if (back != null) {
                    if (!back.hasOnClickListeners()) {
                        back.setOnClickListener(dismissLisnener);
                    }
                }
            }
        } else {
            fl.setVisibility(View.GONE);
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        mWebViewFragment.onViewCreated(view, savedInstanceState);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (mWebViewFragment != null) {
            mWebViewFragment.onDestroy();
        }

    }

    @Override
    public void onStop() {
        super.onStop();
        if (mWebViewFragment != null) {
            mWebViewFragment.onStop();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        if (mWebViewFragment != null) {
            mWebViewFragment.onPause();
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (mWebViewFragment != null) {
            mWebViewFragment.onConfigurationChanged(newConfig);
        }
    }

    @Override
    public void onResume() {
        super.onResume();

        ViewGroup.LayoutParams layoutParams = getView().getLayoutParams();
        layoutParams.height = mHeight;
        layoutParams.width = mWidth;
        getView().setLayoutParams(layoutParams);

        if (mWebViewFragment != null) {
            mWebViewFragment.onResume();
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (mWebViewFragment != null) {
            mWebViewFragment.onDestroyView();
        }
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (mWebViewFragment != null) {
            mWebViewFragment.onActivityCreated(savedInstanceState);
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        activity = getActivity();
        if (mWebViewFragment == null) {
            Bundle bundle = getArguments();
            String url = "";
            int feature = 0;
            if (bundle != null) {
                url = bundle.getString("url", "");
                feature = bundle.getInt("feature");
                String configUIJson = bundle.getString("configUI", "");
                readConfig(configUIJson);
            }
            mWebViewFragment = WebViewFragment.newInstance(getActivity(), url, feature);
            mWebViewFragment.setActivityBarConfig(config);
            mWebViewFragment.onAttach(context);
            mWebViewFragment.setWebViewUIClient(mIWebViewUIClient);
        }
    }

    private void readConfig(String configUIJson) {
        if (TextUtils.isEmpty(configUIJson)) {
            return;
        }
        try {
            JSONObject object = new JSONObject(configUIJson);
            isFullScreen = object.optBoolean("isFullScreen", false);
            isShowTitle = object.optBoolean("isShowTitle", false);

            int width = object.optInt("width", ActivityUtils.NO_SET);
            int screenWidth = UIUtils.getScreenWidth(activity);
            if (width <= ActivityUtils.NO_SET || width > screenWidth) {
                mWidth = ViewGroup.LayoutParams.MATCH_PARENT;
            } else {
                mWidth = width;
            }

            int height = object.optInt("height", ActivityUtils.NO_SET);
            int screenHeight = UIUtils.getScreenHeight(activity);
            if (isFullScreen) {
                mHeight = ViewGroup.LayoutParams.MATCH_PARENT;
            } else {
                if (height <= ActivityUtils.NO_SET || height > screenHeight) {
                    mHeight = screenHeight / 2;
                } else {
                    mHeight = height;
                }
            }
            mStyle = object.optInt("style");
            mGravity = object.optString("gravity");
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mWebViewFragment != null) {
            mWebViewFragment.setIJsSupportWebApi(null);
            mWebViewFragment.onDetach();
            mWebViewFragment.setWebViewUIClient(null);
            mWebViewFragment = null;
        }

    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (mWebViewFragment != null) {
            mWebViewFragment.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(context, attrs, savedInstanceState);
        if (mWebViewFragment != null) {
            mWebViewFragment.onInflate(context, attrs, savedInstanceState);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if (mWebViewFragment != null) {
            mWebViewFragment.onStart();
        }
    }

    public void setOwnerUid(long ownerUid) {
        this.mOwnerUid = ownerUid;
    }

    public void setSid(long sid) {
        this.mSid = sid;
    }

    public void setOwnerName(String ownerName) {
        this.mOwnerName = ownerName;
    }

    private View.OnClickListener dismissLisnener = view -> {
        ALog.i(TAG, "finishActivityListener clicked");
        if (!onBackPressedHandler()) {
            dismissAllowingStateLoss();
        }
    };

    private boolean onBackPressedHandler() {
        boolean isHandler = false;
        ALog.i(TAG, "站点默认回退方式  mPageDefBackStyle:" + mPageDefBackStyle);
        if (FP.empty(mPageDefBackStyle)) {
            mPageDefBackStyle = WebViewParam.BACK_STYLE_HISTORY;
        }
        if (mPageDefBackStyle != null && mPageDefBackStyle.equals(WebViewParam.BACK_STYLE_HISTORY)) {
            if (mWebViewFragment != null && mWebViewFragment.getWebView().canGoBack()) {
                isHandler = true;
                mWebViewFragment.getWebView().goBack();
            }
        }
        return isHandler;
    }

    @Override
    public long getOwnerUid() {
        return mOwnerUid;
    }

    @Override
    public long getSid() {
        return mSid;
    }

    @Override
    public String getOwnerName() {
        return mOwnerName;
    }

    @Override
    public void showProgressDialog(String label, boolean cancelable, int timeout) {
        if (mWebViewFragment != null) {
            mWebViewFragment.showLoading();
        }
    }

    @Override
    public void hideProgressDialog() {
        if (mWebViewFragment != null) {
            mWebViewFragment.hideLoading();
        }
    }

    @Override
    public void loadJavascript(String json) {
        if (mWebViewFragment != null) {
            mWebViewFragment.loadJavaScript(json, new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    ALog.d(TAG, "onReceiveValue: " + value);
                }
            });
        }
    }

    @Override
    public void showPopupWebView(String url, String configUIJson) {

    }

    @Override
    public void closePopupWebView() {
        dismissAllowingStateLoss();
    }

    @Override
    public EntryData getEntryData() {
        return null;
    }

    @Override
    public void configNavigation(String param, IJsApiModule.IJSCallback callback) {
        if (config != null && config.getIConfigNavigation() != null) {
            config.getIConfigNavigation().configNavigation(param, callback);
        }
    }

    @Override
    public String getBroadcastData() {
        return null;
    }

    public interface DialogBuilder {
        Dialog onCreateDialog();
    }


}
