package tv.athena.live.component.business.activitybar;

import android.text.TextUtils;

import com.yy.liveplatform.proto.nano.LpfActivity;

import tv.athena.annotation.MessageBinding;
import tv.athena.core.sly.Sly;
import tv.athena.live.api.activitybar.ActivityBarApi;
import tv.athena.live.base.mvvmImpl.MvvmComponent;
import tv.athena.live.component.business.activitybar.utils.ActivityUtils;
import tv.athena.live.component.business.activitybar.webview.jsapi.JsApiModuleEx;
import tv.athena.live.utils.ALog;
import tv.athena.service.api.event.ServiceBroadcastEvent;
import tv.athena.service.api.event.ServiceUnicastEvent;

/**
 * @author baiting
 */

public class ActivityBarComponent extends MvvmComponent<ActivityBarApi,
    ActivityBarView, ActivityBarViewModel> {

    private final static String TAG = "ActivityBarComponent";

    @Override
    public void onCreate() {
        Sly.Companion.subscribe(this);
    }

    @Override
    protected ActivityBarApi onCreateApi() {
        ActivityBarApiImpl impl = new ActivityBarApiImpl();
        impl.setContext(mComponentContext);
        return impl;
    }

    @Override
    protected ActivityBarView onCreateView() {
        ActivityBarView view = new ActivityBarView();
        view.setContext(mComponentContext);
        return view;
    }

    @Override
    protected ActivityBarViewModel onCreateViewModel() {
        return new ActivityBarViewModel(mComponentContext);
    }

    @Override
    public void onAllComponentsReady() {
        ((ActivityBarApiImpl) getApi()).bindActivityBarView(mView);

    }

    // 幸运礼物中奖单播
    @MessageBinding
    public void onActivityDataBroadcastEvent(ServiceUnicastEvent event) {
        if (event == null || TextUtils.isEmpty(event.getFuncName())) {
            return;
        }
        onActivityBroadcast(event.getFuncName(), "ActivityWindow", event.getMessage());
        onActivityDataBroadcast(event.getFuncName(), "ActivityData", event.getMessage());
    }

    @MessageBinding
    public void onActivityBroadcastEvent(ServiceBroadcastEvent event) {
        if (event == null) {
            return;
        }
        onActivityBroadcast(event.getFuncName(), null, event.getMessage());
        onActivityDataBroadcast(event.getFuncName(), null, event.getMessage());
    }

    private void onActivityBroadcast(String func, String type, byte[] message) {
        if (func.equals(ActivityUtils.ActivityWindowListBroadcast)) {
            try {
                ALog.e(TAG, "ActivityBroadcast: " + func);
                LpfActivity.ActivityWindowListBroadcast mWindowList =
                    LpfActivity.ActivityWindowListBroadcast.parseFrom(message);
                saveData(mWindowList.showUrl, mWindowList.activityWindowData);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void saveData(String url, String data) {
        ((ActivityBarApiImpl) getApi()).saveBroadcastData(url, data);
    }

    private void onActivityDataBroadcast(String func, String type, byte[] message) {
        if (func.equals(ActivityUtils.ActivityDataBroadcast)) {
            try {
                ALog.e(TAG, "ActivityDataBroadcast: " + func);
                LpfActivity.ActivityWindowListBroadcast mWindowData =
                    LpfActivity.ActivityWindowListBroadcast.parseFrom(message);
                saveData(null, mWindowData.activityWindowData);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

        if (getApi() != null) {
            ((ActivityBarApiImpl) getApi()).clearObserver();
        }
        JsApiModuleEx.INSTANCE.clear();
        getView().close();
        Sly.Companion.unSubscribe(this);
    }

    @Override
    public void onLeave() {
    }
}
