/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.vid;

import androidx.lifecycle.MutableLiveData;
import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.wallet.base.IUserIdModel;
import com.yy.hiyo.wallet.base.vid.UserIDConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.money.api.vipid.GetLevelConfReq;
import net.ihago.money.api.vipid.GetLevelConfRes;
import net.ihago.money.api.vipid.LevelConfItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\u0010H\u0002J \u0010\u0015\u001a\u00020\u00102\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0017j\b\u0012\u0004\u0012\u00020\u0006`\u0018H\u0002R&\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/yy/hiyo/wallet/vid/UserIDConfigModel;", "Lcom/yy/hiyo/wallet/base/IUserIdModel;", "()V", "userIDList", "Landroidx/lifecycle/MutableLiveData;", "", "Lcom/yy/hiyo/wallet/base/vid/UserIDConfig;", "getUserIDList", "()Landroidx/lifecycle/MutableLiveData;", "setUserIDList", "(Landroidx/lifecycle/MutableLiveData;)V", "getIDConfig", "id", "", "getLabelList", "getTasksConfig", "", "version", "", "initConfig", "loadFromLocal", "saveToFile", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "Companion", "wallet_billDebug"})
public final class UserIDConfigModel
implements IUserIdModel {
    @NotNull
    private MutableLiveData<List<UserIDConfig>> userIDList = new MutableLiveData();
    @NotNull
    public static final String TAG = "UserIDConfigModel";
    @NotNull
    public static final String VID_CONFIGS = "vid_configs";
    @NotNull
    public static final String KEY_ID_CONFIG_VERSION = "id_config_version";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final MutableLiveData<List<UserIDConfig>> getUserIDList() {
        return this.userIDList;
    }

    public final void setUserIDList(@NotNull MutableLiveData<List<UserIDConfig>> mutableLiveData) {
        Intrinsics.checkParameterIsNotNull(mutableLiveData, (String)"<set-?>");
        this.userIDList = mutableLiveData;
    }

    @Nullable
    public MutableLiveData<List<UserIDConfig>> getLabelList() {
        return this.userIDList;
    }

    private final void initConfig() {
        this.loadFromLocal();
        String string2 = SettingFlags.getStringValue((String)KEY_ID_CONFIG_VERSION, (String)"0");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SettingFlags.getStringVa\u2026Y_ID_CONFIG_VERSION, \"0\")");
        this.getTasksConfig(string2);
    }

    @Nullable
    public UserIDConfig getIDConfig(long id2) {
        MLog.info((Object)TAG, (String)("getIDConfig " + id2), (Object[])new Object[0]);
        List list = (List)this.userIDList.getValue();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UserIDConfig it = (UserIDConfig)element$iv;
                boolean bl = false;
                if (it.getId() != id2) continue;
                return it;
            }
        }
        return null;
    }

    private final void getTasksConfig(String version) {
        MLog.info((Object)TAG, (String)"getTasksConfig", (Object[])new Object[0]);
        GetLevelConfReq req = new GetLevelConfReq.Builder().version(version).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetLevelConfRes>(this){
            final /* synthetic */ UserIDConfigModel this$0;

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                return true;
            }

            public void onResponse(@NotNull GetLevelConfRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)"UserIDConfigModel", (String)("getTasksConfig onResponse code:" + code), (Object[])new Object[0]);
                boolean bl = false;
                ArrayList<UserIDConfig> list = new ArrayList<UserIDConfig>();
                if (ProtoManager.isSuccessCode((long)code)) {
                    SettingFlags.setStringValue((String)"id_config_version", (String)message.version);
                    Object object = message.level_configs;
                    if (object != null && (object = object.entrySet()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Map.Entry it = (Map.Entry)element$iv;
                            boolean bl2 = false;
                            K k = it.getKey();
                            Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
                            long l = ((Number)k).longValue();
                            String string2 = ((LevelConfItem)it.getValue()).bg_url;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.value.bg_url");
                            String string3 = ((LevelConfItem)it.getValue()).id_url;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.value.id_url");
                            String string4 = ((LevelConfItem)it.getValue()).jump_url;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.value.jump_url");
                            list.add(new UserIDConfig(l, string2, string3, string4));
                        }
                    }
                    this.this$0.getUserIDList().setValue(list);
                    UserIDConfigModel.access$saveToFile(this.this$0, list);
                }
            }

            public boolean needToken() {
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void saveToFile(ArrayList<UserIDConfig> data) {
        ArrayList<UserIDConfig> arrayList = data;
        MLog.info((Object)TAG, (String)("saveToFile " + (arrayList != null ? Integer.valueOf(arrayList.size()) : null)), (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(data){
            final /* synthetic */ ArrayList $data;

            public final void run() {
                String fileData = JsonParser.toJson((Object)this.$data);
                FileStorageUtils.getInstance().saveToFile(true, fileData, "vid_configs");
            }
            {
                this.$data = arrayList;
            }
        });
    }

    private final void loadFromLocal() {
        MLog.info((Object)TAG, (String)"loadFromLocal", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(this){
            final /* synthetic */ UserIDConfigModel this$0;

            public final void run() {
                String fileData = FileStorageUtils.getInstance().getStrFromFile(true, "vid_configs");
                try {
                    List list = JsonParser.parseJsonList((String)fileData, UserIDConfig.class);
                    this.this$0.getUserIDList().postValue(new ArrayList<E>(list));
                    MLog.info((Object)"UserIDConfigModel", (String)("loadFromLocal: " + list.size()), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            {
                this.this$0 = userIDConfigModel;
            }
        });
    }

    public UserIDConfigModel() {
        this.initConfig();
    }

    public static final /* synthetic */ void access$saveToFile(UserIDConfigModel $this, ArrayList data) {
        $this.saveToFile(data);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/yy/hiyo/wallet/vid/UserIDConfigModel$Companion;", "", "()V", "KEY_ID_CONFIG_VERSION", "", "TAG", "VID_CONFIGS", "wallet_billDebug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

