/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.result;

import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketBehavior;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.PacketShareInfo;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.redpacket.room.presenter.IPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.PacketResult;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.ui.IRedPacketResultUICallback;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.ui.PacketResultPanel;
import java.util.List;
import net.ihago.money.api.redpacket.PacketInfo;
import net.ihago.money.api.redpacket.WinnerInfo;

public class PacketResultPresenter
implements IPacketPresenter,
IRedPacketResultUICallback {
    public static final String TAG = "FTRedPacketResultPresenter";
    private RedPacketParam mPacketParam;
    PacketResult mPacketResult;
    IRedPacketBehavior iRedPacketBehavior;

    @Override
    public void onCreate(RedPacketParam createParam) {
        this.mPacketParam = createParam;
        this.iRedPacketBehavior = createParam.getBehavior();
    }

    public boolean showPacketResult(PacketResult packetResult) {
        MLog.info((Object)TAG, (String)"showPacketResult packetId: %s", (Object[])new Object[]{packetResult == null ? "" : packetResult.getPacketId()});
        PanelLayer panelLayer = this.mPacketParam.getBehavior().getPanelLayer();
        PacketResultPanel panel = new PacketResultPanel(panelLayer.getContext(), this, this.mPacketParam.getRoomId());
        panel.showBalckMask(true);
        this.updatePanelView(packetResult, panel);
        panelLayer.showPanel((BasePanel)panel, false);
        return true;
    }

    private void updatePanelView(PacketResult packetResult, PacketResultPanel panel) {
        if (packetResult == null || packetResult.getWinnerInfos() == null || packetResult.getPacketInfo() == null) {
            MLog.error((Object)TAG, (String)"updatePanelView data is null", (Object[])new Object[0]);
            return;
        }
        this.mPacketResult = packetResult;
        List<WinnerInfo> winnerInfos = packetResult.getWinnerInfos();
        PacketInfo packetInfo = packetResult.getPacketInfo();
        boolean isWinner = this.isWinner(packetResult.getWinnerInfos(), AccountUtil.getUid());
        MLog.info((Object)TAG, (String)"updatePanelView isWinner: %b, senderUid: %d", (Object[])new Object[]{isWinner, packetInfo.sender});
        if (isWinner) {
            panel.updatePanelView(0, packetResult);
        } else if (packetInfo.sender == AccountUtil.getUid()) {
            panel.updatePanelView(10, packetResult);
        } else {
            panel.updatePanelView(11, packetResult);
        }
        panel.updateWinnerList(winnerInfos);
    }

    private boolean isWinner(List<WinnerInfo> winnerInfos, long uid) {
        if (FP.empty(winnerInfos)) {
            return false;
        }
        for (WinnerInfo info : winnerInfos) {
            if (info.uid != uid) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onBtnShareClick() {
        if (this.iRedPacketBehavior != null) {
            PacketShareInfo info = new PacketShareInfo(this.mPacketResult.getPacketInfo().id, this.mPacketResult.getShareInfo().share_pic_url, this.mPacketResult.getShareInfo().im_pic_url);
            this.iRedPacketBehavior.sharePacket(info);
        }
    }
}

