/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.foreshow.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.DR;
import com.yy.hiyo.wallet.redpacket.room.presenter.foreshow.ui.ForeShowHeadView;

public class ForeShowView
extends YYFrameLayout {
    private static final String TAG = "ForeShowView";
    static final int COUNTDOWN_STRAR_MILLISECOND = 3;
    static final int COUNTDOWN_STRAR_GAP = 1000;
    int mCurrentSec = 0;
    ForeShowHeadView mForeShowHadView;
    RecycleImageView mCountdownView;
    private int[] yellowCountDown = new int[]{R.drawable.red_packet_yellow_0, R.drawable.red_packet_yellow_1, R.drawable.red_packet_yellow_2, R.drawable.red_packet_yellow_3};
    ICountdownFinishCallback mICountdownFinishCallback;
    CountDownRunnable mCountDownTimer;
    public static final int SHOW_ANI_DURATION = 800;
    protected static final Interpolator mShowAnimInterpolator = new Interpolator(){

        public float getInterpolation(float input) {
            return (float)((double)input == 1.0 ? 1.0 : 1.001 * (-Math.pow(2.0, -10.0f * input) + 1.0));
        }
    };
    protected AnimatorSet mShowAnim = this.createShowAnimation();
    protected Animator mHideAnim = this.createHideAnimation();

    public ForeShowView(Context context) {
        super(context);
        this.initView();
    }

    public ForeShowView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public void setCountdownFinishCallback(ICountdownFinishCallback iCountdownFinishCallback) {
        this.mICountdownFinishCallback = iCountdownFinishCallback;
    }

    public void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_foreshow, (ViewGroup)this, true);
        this.setVisibility(8);
        View mForeShowBgView = this.findViewById(R.id.foreshow_bg);
        this.mForeShowHadView = (ForeShowHeadView)this.findViewById(R.id.foreshow_head);
        this.mCountdownView = (RecycleImageView)this.findViewById(R.id.countdown);
        DyResLoader.INSTANCE.loadNineImg(this.getContext(), mForeShowBgView, DR.foreshow_background9);
    }

    public void showView() {
        this.setVisibility(0);
        this.mShowAnim.start();
    }

    private void hideView() {
        this.mHideAnim.start();
    }

    public void updateUserHeadInfo(String imgUrl, String nickName) {
        this.mForeShowHadView.updateAvator(imgUrl);
        this.mForeShowHadView.updateUserName(nickName);
    }

    public void startCountDown() {
        this.mCurrentSec = 3;
        this.mCountdownView.setVisibility(0);
        this.mCountdownView.setImageResource(this.yellowCountDown[this.getIndex()]);
        if (this.mCountDownTimer != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCountDownTimer);
        }
        this.mCountDownTimer = new CountDownRunnable();
        this.countDown(this.mCountDownTimer);
    }

    public void countDown(CountDownRunnable countDownRunnable) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)countDownRunnable);
        YYTaskExecutor.postToMainThread((Runnable)countDownRunnable, (long)1000L);
    }

    private int getIndex() {
        return this.mCurrentSec > 3 ? this.mCurrentSec % 3 : this.mCurrentSec;
    }

    public AnimatorSet createShowAnimation() {
        AnimatorSet aniSet = new AnimatorSet();
        ObjectAnimator tranAni = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.5f, 1.0f});
        ObjectAnimator scaleAniX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{0.5f, 1.0f});
        ObjectAnimator scaleAniY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{0.5f, 1.0f});
        aniSet.play((Animator)tranAni).with((Animator)scaleAniX).with((Animator)scaleAniY);
        aniSet.setDuration(800L);
        aniSet.setInterpolator((TimeInterpolator)mShowAnimInterpolator);
        aniSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                ForeShowView.this.startCountDown();
            }
        });
        return aniSet;
    }

    public Animator createHideAnimation() {
        ObjectAnimator tranAni = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        tranAni.setDuration(800L);
        tranAni.setInterpolator((TimeInterpolator)mShowAnimInterpolator);
        tranAni.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                MLog.info((Object)"RedPacket", (String)"onAnimationEnd ", (Object[])new Object[0]);
                ForeShowView.this.finish();
            }
        });
        return tranAni;
    }

    public void destroy() {
        this.mICountdownFinishCallback = null;
        this.mCountDownTimer = null;
        this.mHideAnim.cancel();
        this.mShowAnim.cancel();
    }

    private void finish() {
        if (this.getVisibility() != 0) {
            return;
        }
        MLog.info((Object)"RedPacket", (String)"finish ", (Object[])new Object[0]);
        this.setVisibility(8);
        if (this.mCountdownView != null) {
            this.mCountdownView.setImageDrawableToNull();
        }
        if (this.mICountdownFinishCallback != null) {
            this.mICountdownFinishCallback.onCountDownFinish();
        }
    }

    public static interface ICountdownFinishCallback {
        public void onCountDownFinish();
    }

    class CountDownRunnable
    implements Runnable {
        CountDownRunnable() {
        }

        @Override
        public void run() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)ForeShowView.TAG, (String)"CountDownRunnable mCurrentSec: %d", (Object[])new Object[]{ForeShowView.this.mCurrentSec});
            }
            --ForeShowView.this.mCurrentSec;
            if (ForeShowView.this.mCurrentSec >= 1) {
                ForeShowView.this.mCountdownView.setImageResource(ForeShowView.this.yellowCountDown[ForeShowView.this.getIndex()]);
                if (ForeShowView.this.mCurrentSec > 1) {
                    ForeShowView.this.countDown(this);
                } else {
                    ForeShowView.this.mCountdownView.setVisibility(0);
                    ForeShowView.this.hideView();
                }
            }
        }
    }
}

