/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.foreshow.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.wallet.R;

public class ForeShowHeadView
extends YYFrameLayout {
    RecycleImageView mItemLightView;
    HeadFrameImageView mImgAvator;
    RecycleImageView mLeftStar;
    RecycleImageView mRightStar;
    YYTextView mTvUserName;

    public ForeShowHeadView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ForeShowHeadView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_foreshow_headview, (ViewGroup)this, true);
        this.mItemLightView = (RecycleImageView)this.findViewById(R.id.foreshow_head_light);
        this.mImgAvator = (HeadFrameImageView)this.findViewById(R.id.img_avtor);
        this.mTvUserName = (YYTextView)this.findViewById(R.id.tv_username);
        this.mLeftStar = (RecycleImageView)this.findViewById(R.id.foreshow_left_start);
        this.mRightStar = (RecycleImageView)this.findViewById(R.id.foreshow_right_start);
        this.mLeftStar.setScaleX(0.7f);
        this.mLeftStar.setScaleY(0.7f);
        this.mLeftStar.setRotation(-45.0f);
        this.updateAvator(null);
    }

    public void updateAvator(@NonNull String url) {
        ImageLoader.loadImage((ImageView)this.mImgAvator.getCircleImageView(), (String)(url + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)1));
    }

    public void updateUserName(@NonNull String name) {
        this.mTvUserName.setText((CharSequence)name);
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.startAnim();
            this.startLeftStarAnim();
            this.startRightStarAnim();
        } else {
            this.mItemLightView.clearAnimation();
            this.mLeftStar.clearAnimation();
            this.mRightStar.clearAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mItemLightView.clearAnimation();
        this.mLeftStar.clearAnimation();
        this.mRightStar.clearAnimation();
    }

    private void startAnim() {
        this.mItemLightView.clearAnimation();
        RotateAnimation backLightAnim = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        backLightAnim.setDuration(8000L);
        backLightAnim.setFillAfter(true);
        backLightAnim.setInterpolator((Interpolator)new LinearInterpolator());
        backLightAnim.setRepeatMode(1);
        backLightAnim.setRepeatCount(-1);
        this.mItemLightView.setAnimation((Animation)backLightAnim);
    }

    private void startLeftStarAnim() {
        this.mLeftStar.clearAnimation();
        AnimationSet aniSet = new AnimationSet(true);
        AlphaAnimation alphaAni = new AlphaAnimation(0.3f, 1.0f);
        alphaAni.setRepeatMode(2);
        alphaAni.setRepeatCount(-1);
        ScaleAnimation scaleAni = new ScaleAnimation(0.5f, 1.0f, 0.5f, 1.0f, 1, 0.0f, 1, 0.0f);
        scaleAni.setRepeatMode(2);
        scaleAni.setRepeatMode(-1);
        aniSet.addAnimation((Animation)alphaAni);
        aniSet.addAnimation((Animation)scaleAni);
        aniSet.setDuration(500L);
        aniSet.setInterpolator((Interpolator)new LinearInterpolator());
        this.mLeftStar.setAnimation((Animation)aniSet);
    }

    private void startRightStarAnim() {
        this.mRightStar.clearAnimation();
        AnimationSet aniSet = new AnimationSet(true);
        AlphaAnimation alphaAni = new AlphaAnimation(1.0f, 0.3f);
        alphaAni.setRepeatMode(2);
        alphaAni.setRepeatCount(-1);
        ScaleAnimation scaleAni = new ScaleAnimation(0.5f, 1.0f, 0.5f, 1.0f, 1, 0.0f, 1, 0.0f);
        scaleAni.setRepeatMode(2);
        scaleAni.setRepeatMode(-1);
        aniSet.addAnimation((Animation)alphaAni);
        aniSet.addAnimation((Animation)scaleAni);
        aniSet.setDuration(500L);
        aniSet.setInterpolator((Interpolator)new LinearInterpolator());
        this.mRightStar.setAnimation((Animation)aniSet);
    }
}

