/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.config.SceneOptConfigItem;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.BaseFloatingItem;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.IFloatingViewUICallback;
import java.util.Random;
import net.ihago.money.api.redpacket.GearId;
import net.ihago.money.api.redpacket.PacketInfo;

public class RedPacketFloatingView
extends YYFrameLayout
implements View.OnClickListener {
    public static final String TAG = "RedPacketFloatingView";
    private Random mRandom;
    private BaseFloatingItem mFloatingItem;
    private ObjectAnimator mFloatAnimator;
    private ViewGroup.LayoutParams mLayoutParams;
    private RecycleImageView redPacketIv;
    private int mWidth;
    private int mHeight;
    private int mRangeX;
    private int mRangeY;
    private int mScreenWidth;
    private int mScreenHeight;
    private volatile boolean mClicked;
    private volatile boolean mIsActive;
    IFloatingViewUICallback iFloatingViewUICallback;

    public RedPacketFloatingView(Context context, IFloatingViewUICallback iFloatingViewUICallback) {
        super(context);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_redpacket_float, (ViewGroup)this);
        this.redPacketIv = (RecycleImageView)view.findViewById(R.id.iv_redpacket);
        this.mRandom = new Random();
        this.mWidth = ResolutionUtils.dip2Px((float)55.0f);
        this.mHeight = ResolutionUtils.dip2Px((float)55.0f);
        this.mScreenWidth = ResolutionUtils.getScreenWidth((Context)context);
        this.mScreenHeight = ResolutionUtils.getScreenHeight((Context)context);
        this.mLayoutParams = new ViewGroup.LayoutParams(this.mWidth, this.mHeight);
        this.iFloatingViewUICallback = iFloatingViewUICallback;
    }

    public void setRedPacketInfo(BaseFloatingItem item) {
        this.mFloatingItem = item;
        if (this.mFloatingItem != null) {
            ImageLoader.loadImage((ImageView)this.redPacketIv, (String)this.mFloatingItem.imgUrl);
        }
    }

    public void enterAnim(final ViewGroup layer) {
        this.mIsActive = true;
        this.setOnClickListener(this::onClick);
        long delay = (long)((float)this.getInterval() * this.getPackageIntervalGain());
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!RedPacketFloatingView.this.mIsActive) {
                    return;
                }
                if (RedPacketFloatingView.this.getParent() != null) {
                    ((ViewGroup)RedPacketFloatingView.this.getParent()).removeView((View)RedPacketFloatingView.this);
                }
                float randomXY = RedPacketFloatingView.this.getScale();
                RedPacketFloatingView.this.setScaleX(randomXY);
                RedPacketFloatingView.this.setScaleY(randomXY);
                layer.addView((View)RedPacketFloatingView.this, RedPacketFloatingView.this.mLayoutParams);
                RedPacketFloatingView.this.mRangeX = RedPacketFloatingView.this.mRandom.nextInt(RedPacketFloatingView.this.mScreenWidth - RedPacketFloatingView.this.mWidth);
                if (LanguageUtils.isRtl()) {
                    RedPacketFloatingView.this.mRangeX = -RedPacketFloatingView.this.mRangeX;
                }
                RedPacketFloatingView.this.mRangeY = RedPacketFloatingView.this.mScreenHeight;
                float startY = -randomXY * (float)RedPacketFloatingView.this.mHeight;
                MLog.info((Object)"enterAnim", (String)"mRangeY = %s", (Object[])new Object[]{RedPacketFloatingView.this.mRangeY});
                RedPacketFloatingView.this.setTranslationX(RedPacketFloatingView.this.mRangeX);
                if (RedPacketFloatingView.this.mFloatAnimator == null) {
                    RedPacketFloatingView.this.mFloatAnimator = ObjectAnimator.ofFloat((Object)((Object)RedPacketFloatingView.this), (String)"translationY", (float[])new float[]{startY, RedPacketFloatingView.this.mRangeY});
                }
                RedPacketFloatingView.this.mFloatAnimator.setDuration(RedPacketFloatingView.this.getDuration());
                RedPacketFloatingView.this.mFloatAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationCancel(Animator animation) {
                        super.onAnimationCancel(animation);
                        if (!RedPacketFloatingView.this.mClicked) {
                            RedPacketFloatingView.this.onStop();
                        }
                    }

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        if (!RedPacketFloatingView.this.mClicked) {
                            RedPacketFloatingView.this.onStop();
                        }
                    }
                });
                RedPacketFloatingView.this.mFloatAnimator.start();
                if (RedPacketFloatingView.this.iFloatingViewUICallback != null) {
                    RedPacketFloatingView.this.iFloatingViewUICallback.onViewShowing();
                }
            }
        }, (long)delay);
    }

    private float getPackageIntervalGain() {
        if (this.mFloatingItem == null || !(this.mFloatingItem.data instanceof PacketInfo)) {
            return 1.0f;
        }
        SceneOptConfigItem configItem = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).getConfigItem("red_packet");
        boolean isHighPerfScene = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).isInHighPerfScene();
        if (configItem != null && isHighPerfScene) {
            return configItem.redPacketIntervalGain;
        }
        return 1.0f;
    }

    private float getScale() {
        GearId gearId = this.getGearId();
        if (gearId == GearId.Middle) {
            return this.mRandom.nextFloat() * 0.4f + 0.8f;
        }
        if (gearId == GearId.High) {
            return this.mRandom.nextFloat() * 0.4f + 1.0f;
        }
        return this.mRandom.nextFloat() * 0.4f + 0.8f;
    }

    private long getInterval() {
        GearId gearId = this.getGearId();
        if (gearId == GearId.Middle) {
            return this.getInterval(3, 6);
        }
        if (gearId == GearId.High) {
            return this.getInterval(5, 10);
        }
        return this.getInterval(2, 6);
    }

    private long getInterval(int start, int end) {
        int s = 1000 / start;
        int e = 1000 / end;
        int interval = s - e;
        return this.mRandom.nextInt(interval) + e;
    }

    private long getDuration() {
        return this.mRandom.nextInt(2500) + 2500;
    }

    private GearId getGearId() {
        if (this.mFloatingItem == null || !(this.mFloatingItem.data instanceof PacketInfo)) {
            return GearId.Low;
        }
        PacketInfo packetInfo = (PacketInfo)this.mFloatingItem.data;
        return packetInfo.gear_id;
    }

    public void exitAnim() {
        this.mIsActive = false;
        this.mClicked = true;
        this.onStop();
    }

    private void onStop() {
        if (this.mFloatAnimator != null) {
            this.mFloatAnimator.cancel();
            if (this.iFloatingViewUICallback != null) {
                this.iFloatingViewUICallback.onViewRemoved(this);
            }
            this.mClicked = false;
        }
    }

    public void onClick(View v) {
        this.mClicked = true;
        if (this.iFloatingViewUICallback != null) {
            this.iFloatingViewUICallback.onItemClick((RedPacketFloatingView)v, this.mFloatingItem);
        }
        this.setOnClickListener(null);
    }
}

