/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.IRedPacketContainerCallback;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.BaseFloatingItem;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.IFloatingViewUICallback;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.RedPacketFloatingBannerView;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.RedPacketFloatingView;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.ihago.money.api.redpacket.PacketInfo;

public class RedPacketFlatingContiner
extends YYFrameLayout
implements IFloatingViewUICallback,
RedPacketFloatingBannerView.IFloatingBannerViewCallback {
    public static final String TAG = "RedPacketFlatingContiner";
    private IRedPacketContainerCallback mCallback;
    private PacketInfo mPacketInfo;
    private Set<RedPacketFloatingView> mViewCache = new HashSet<RedPacketFloatingView>();
    private CopyOnWriteArraySet<RedPacketFloatingView> mActiveViews = new CopyOnWriteArraySet();
    RedPacketFloatingBannerView redPacketFloatingBannerView;
    private boolean mCanFloat = true;
    private String roomId;

    public RedPacketFlatingContiner(Context context, IRedPacketContainerCallback callback2, String roomId) {
        this(context, null, callback2, roomId);
        this.initView();
    }

    public RedPacketFlatingContiner(Context context, AttributeSet attrs, IRedPacketContainerCallback callback2, String roomId) {
        super(context, attrs);
        this.initView();
        this.roomId = roomId;
        this.mCallback = callback2;
    }

    void initView() {
        if (this.redPacketFloatingBannerView == null) {
            this.redPacketFloatingBannerView = new RedPacketFloatingBannerView(this.getContext());
        }
        if (this.redPacketFloatingBannerView.getParent() != null) {
            ((ViewGroup)this.redPacketFloatingBannerView.getParent()).removeView((View)this.redPacketFloatingBannerView);
        }
        this.redPacketFloatingBannerView.setFloatingBannerViewCallback(this);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        this.addView((View)this.redPacketFloatingBannerView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void startCountDown(int rainTime) {
        this.redPacketFloatingBannerView.setCountDownNum(rainTime);
        this.redPacketFloatingBannerView.showView();
    }

    public void setPacketInfo(PacketInfo info) {
        this.mPacketInfo = info;
    }

    private void floatRedPacket(PacketInfo info) {
        if (info == null || this.mViewCache == null) {
            return;
        }
        RedPacketFloatingView view = null;
        if (this.mViewCache.isEmpty()) {
            view = new RedPacketFloatingView(this.getContext(), this);
        } else {
            Iterator<RedPacketFloatingView> iterator = this.mViewCache.iterator();
            if (iterator.hasNext()) {
                view = iterator.next();
                iterator.remove();
            }
        }
        BaseFloatingItem redPacketInfo = new BaseFloatingItem();
        redPacketInfo.imgUrl = info.pic_url;
        redPacketInfo.data = info;
        view.setRedPacketInfo(redPacketInfo);
        view.enterAnim((ViewGroup)this);
        this.mActiveViews.add(view);
        GiftHiidoReport.redPacketFloatViewShow(info.diamonds, this.roomId);
    }

    public void hideView() {
        this.mCanFloat = false;
        this.setVisibility(8);
    }

    public void onGrabFailed(RedPacketFloatingView view) {
        if (view != null) {
            float x = view.getTranslationX();
            float y = view.getTranslationY();
            this.showMiss(x, y, (int)((float)view.getWidth() * view.getScaleX()), (int)((float)view.getHeight() * view.getScaleX()));
            view.exitAnim();
        }
    }

    private void showMiss(final float x, final float y, final int width, final int height) {
        final SVGAImageView view = new SVGAImageView(this.getContext());
        SvgaLoader.load((SVGAImageView)view, (String)"red_pocket_miss.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (view.getParent() != null) {
                    MLog.error((Object)RedPacketFlatingContiner.TAG, (String)"view had parent????", (Object[])new Object[0]);
                    return;
                }
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
                RedPacketFlatingContiner.this.addView((View)view, (ViewGroup.LayoutParams)layoutParams);
                view.setTranslationX(x);
                view.setTranslationY(y);
                view.setVisibility(0);
                view.startAnimation();
            }

            public void onFailed(Exception e) {
                view.setVisibility(8);
                RedPacketFlatingContiner.this.removeView((View)view);
            }
        });
        view.setLoops(1);
        view.setCallback(new SVGACallback(){

            public void onPause() {
            }

            public void onFinished() {
                view.setVisibility(8);
                YYTaskExecutor.postIdleRunnableToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RedPacketFlatingContiner.this.removeView((View)view);
                    }
                });
            }

            public void onRepeat() {
            }

            public void onStep(int i, double v) {
            }
        });
    }

    @Override
    public void onViewRemoved(final RedPacketFloatingView view) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                RedPacketFlatingContiner.this.removeView((View)view);
            }
        });
        if (view != null && this.mViewCache != null && this.mActiveViews != null) {
            this.mActiveViews.remove((Object)view);
            this.mViewCache.add(view);
        }
    }

    @Override
    public void onViewShowing() {
        if (this.mCanFloat) {
            this.floatRedPacket(this.mPacketInfo);
        }
    }

    @Override
    public void onItemClick(RedPacketFloatingView view, BaseFloatingItem floatingItem) {
        if (this.mCallback != null) {
            this.mCallback.onItemClick(view, floatingItem);
            GiftHiidoReport.redPacketFloatViewClick(this.roomId);
        }
    }

    @Override
    public void onCountDownFinish() {
        this.mCanFloat = false;
    }

    @Override
    public void onBannerViewShow() {
        this.mCanFloat = true;
        this.floatRedPacket(this.mPacketInfo);
    }

    @Override
    public void onBannerViewHide() {
        this.hideView();
        if (this.mCallback != null) {
            this.mCallback.onFloatFinished(this.mPacketInfo);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (!FP.empty(this.mActiveViews) && visibility == 8) {
            for (RedPacketFloatingView view : this.mActiveViews) {
                view.exitAnim();
            }
        }
    }
}

