/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.presenter;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.redpacket.room.presenter.IPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.chat.PacketMsgPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.entrance.EntrancePresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.FlowPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.foreshow.ForeshowPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.grab.GrabPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.guide.NewGuidePresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.PacketResultPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.send.SendPacketPresenter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PacketPresenterManager
implements IPacketPresenter {
    private final Map<Class<? extends IPacketPresenter>, IPacketPresenter> mPresenters = new ConcurrentHashMap<Class<? extends IPacketPresenter>, IPacketPresenter>();

    public PacketPresenterManager() {
        this.initPresenter();
    }

    private synchronized void initPresenter() {
        this.mPresenters.put(EntrancePresenter.class, new EntrancePresenter());
        this.mPresenters.put(PacketMsgPresenter.class, new PacketMsgPresenter());
        this.mPresenters.put(NewGuidePresenter.class, new NewGuidePresenter());
        this.mPresenters.put(SendPacketPresenter.class, new SendPacketPresenter());
        this.mPresenters.put(ForeshowPresenter.class, new ForeshowPresenter());
        this.mPresenters.put(FlowPacketPresenter.class, new FlowPacketPresenter());
        this.mPresenters.put(PacketResultPresenter.class, new PacketResultPresenter());
        this.mPresenters.put(GrabPacketPresenter.class, new GrabPacketPresenter());
    }

    public synchronized <P extends IPacketPresenter> P getPresenter(@NonNull Class<P> cls) {
        IPacketPresenter presenter;
        if (FP.empty(this.mPresenters)) {
            this.initPresenter();
        }
        if (cls.isInstance(presenter = this.mPresenters.get(cls))) {
            return (P)presenter;
        }
        throw new IllegalStateException("you must init presenter before use " + cls);
    }

    @Override
    public void onCreate(RedPacketParam createParam) {
        for (IPacketPresenter presenter : this.mPresenters.values()) {
            presenter.onCreate(createParam);
        }
    }

    @Override
    public void onStart(ViewGroup parent) {
        for (IPacketPresenter presenter : this.mPresenters.values()) {
            presenter.onStart(parent);
        }
    }

    @Override
    public void onPause() {
        for (IPacketPresenter presenter : this.mPresenters.values()) {
            presenter.onPause();
        }
    }

    @Override
    public void onDestroy() {
        for (IPacketPresenter presenter : this.mPresenters.values()) {
            try {
                presenter.onDestroy();
            }
            catch (Exception e) {
                MLog.error((Object)"PacketPresenterManager", (Throwable)e);
            }
        }
        this.mPresenters.clear();
    }

    @Override
    public void onReceiveBro(Object notify) {
        for (IPacketPresenter presenter : this.mPresenters.values()) {
            presenter.onReceiveBro(notify);
        }
    }
}

