/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.handler;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketHandler;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.redpacket.room.bro.OnPacketBroCallback;
import com.yy.hiyo.wallet.redpacket.room.bro.PacketBroInfoWrap;
import com.yy.hiyo.wallet.redpacket.room.bro.RedPacketBro;
import com.yy.hiyo.wallet.redpacket.room.handler.IPacketHandlerCallback;
import com.yy.hiyo.wallet.redpacket.room.handler.IPacketManagerCallback;
import com.yy.hiyo.wallet.redpacket.room.handler.RedPacketHandler;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class RedPacketHandlerManager
implements OnPacketBroCallback,
IPacketHandlerCallback {
    private static final String TAG = "FTRedPacketHandlerManager";
    private final Map<String, PacketBroInfoWrap> mPendingBro = new ConcurrentHashMap<String, PacketBroInfoWrap>();
    private final Vector<IRedPacketHandler> mHandlerList = new Vector();
    private final RedPacketBro mRedPacketBro = new RedPacketBro(this);

    public IRedPacketHandler createHandler(@NonNull RedPacketParam param) {
        MLog.info((Object)TAG, (String)"createHandler param: %s", (Object[])new Object[]{param});
        String roomId = param.getRoomId();
        IRedPacketHandler handler = this.getHandler(roomId);
        if (handler != null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException("can not create duplication room " + roomId);
            }
            MLog.error((Object)TAG, (String)"can not create duplication room: %", (Object[])new Object[]{roomId});
            return handler;
        }
        handler = new RedPacketHandler(param, this);
        if (this.mPendingBro.containsKey(handler.roomId())) {
            ((RedPacketHandler)handler).onReceiveBro(this.mPendingBro.get((Object)handler.roomId()).notify);
        }
        this.mHandlerList.add(handler);
        return handler;
    }

    @Nullable
    public IRedPacketHandler getHandler(String roomId) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            return null;
        }
        for (IRedPacketHandler handler : this.mHandlerList) {
            if (!roomId.equals(handler.roomId())) continue;
            return handler;
        }
        return null;
    }

    public void finishHandler(String roomId) {
        MLog.info((Object)TAG, (String)"finishHandler roomId: %s", (Object[])new Object[]{roomId});
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            return;
        }
        IRedPacketHandler rm = null;
        for (IRedPacketHandler handler : this.mHandlerList) {
            if (!roomId.equals(handler.roomId())) continue;
            rm = handler;
            break;
        }
        if (rm != null) {
            this.mHandlerList.remove(rm);
            rm.destroy();
        }
    }

    @Override
    public void onBro(PacketBroInfoWrap wrap) {
        if (this.mHandlerList.isEmpty()) {
            this.mPendingBro.put(wrap.roomId, wrap);
        } else {
            for (IRedPacketHandler handler : this.mHandlerList) {
                if (!wrap.roomId.equals(handler.roomId()) || !(handler instanceof IPacketManagerCallback)) continue;
                ((IPacketManagerCallback)handler).onReceiveBro(wrap.notify);
            }
        }
    }

    @Override
    public void onHandlerDestroy(IRedPacketHandler handler) {
        this.mHandlerList.remove(handler);
        this.mPendingBro.remove(handler.roomId());
    }
}

