/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.redpacket.room.handler;

import android.content.Context;
import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.unifyconfig.config.ScenePerfOptSceneDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.IRedPacketHandler;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.PacketChatMsg;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketEntrance;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketEntranceReqParam;
import com.yy.hiyo.wallet.base.revenue.redpacket.room.bean.RedPacketParam;
import com.yy.hiyo.wallet.gift.handler.HandlerState;
import com.yy.hiyo.wallet.gift.statis.GiftHiidoReport;
import com.yy.hiyo.wallet.redpacket.PacketUtils;
import com.yy.hiyo.wallet.redpacket.room.handler.IPacketHandlerCallback;
import com.yy.hiyo.wallet.redpacket.room.handler.IPacketManagerCallback;
import com.yy.hiyo.wallet.redpacket.room.handler.RedPacketTest;
import com.yy.hiyo.wallet.redpacket.room.presenter.IPacketPanelListener;
import com.yy.hiyo.wallet.redpacket.room.presenter.PacketPresenterManager;
import com.yy.hiyo.wallet.redpacket.room.presenter.PacketResult;
import com.yy.hiyo.wallet.redpacket.room.presenter.chat.PacketMsgPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.entrance.EntrancePresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.FlowPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.IFlowPacketCallback;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.BaseFloatingItem;
import com.yy.hiyo.wallet.redpacket.room.presenter.flow.ui.RedPacketFloatingView;
import com.yy.hiyo.wallet.redpacket.room.presenter.foreshow.ForeshowPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.grab.GrabPacketPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.grab.GrabPacketState;
import com.yy.hiyo.wallet.redpacket.room.presenter.guide.NewGuidePresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.result.PacketResultPresenter;
import com.yy.hiyo.wallet.redpacket.room.presenter.send.SendPacketPresenter;
import net.ihago.money.api.redpacket.GrabOrigin;
import net.ihago.money.api.redpacket.PacketInfo;
import net.ihago.money.api.redpacket.RainNotify;

public class RedPacketHandler
implements IRedPacketHandler,
IPacketManagerCallback,
PacketChatMsg.OnClickListener,
IFlowPacketCallback {
    private static final String TAG = "FTRedPacketHandler";
    private HandlerState mState = HandlerState.none;
    private PacketPresenterManager mPresenterManager;
    private final RedPacketParam mPacketParam;
    private IPacketHandlerCallback mHandlerCallback;
    private RedPacketTest mRedPacketTest;
    private ForeshowPresenter.ICountdownFinishCallback mCountdownFinishCallback = new ForeshowPresenter.ICountdownFinishCallback(){

        @Override
        public void onCountdownFinish(RainNotify notify) {
            FlowPacketPresenter presenter = RedPacketHandler.this.getPresenterManager().getPresenter(FlowPacketPresenter.class);
            if (presenter != null && notify != null) {
                presenter.showRedPocketRain(notify.packet_info);
            }
        }

        @Override
        public void onOvertime(PacketInfo packetInfo) {
            RedPacketHandler.this.onFloatFinished(packetInfo, 3);
        }
    };

    public RedPacketHandler(RedPacketParam packetParam, IPacketHandlerCallback callback2) {
        this.mPacketParam = packetParam;
        this.mHandlerCallback = callback2;
        this.onCreate(this.mPacketParam);
        this.getPresenterManager().getPresenter(PacketMsgPresenter.class).setClickListener(this);
        this.getPresenterManager().getPresenter(FlowPacketPresenter.class).setCallback(this);
        this.getPresenterManager().getPresenter(ForeshowPresenter.class).setCountdownFinishCallback(this.mCountdownFinishCallback);
    }

    public String roomId() {
        return this.mPacketParam.getRoomId();
    }

    private void onCreate(RedPacketParam packetParam) {
        this.mState = HandlerState.create;
        this.getPresenterManager().onCreate(packetParam);
    }

    public void start(@NonNull ViewGroup layer) {
        this.mState = HandlerState.start;
        this.getPresenterManager().onStart(layer);
    }

    public void pause() {
        this.mState = HandlerState.pause;
        if (this.mPresenterManager != null) {
            this.mPresenterManager.onPause();
        }
    }

    public void destroy() {
        this.mState = HandlerState.finish;
        this.mHandlerCallback.onHandlerDestroy(this);
        if (this.mPresenterManager != null) {
            YYTaskExecutor.postToMainThread(() -> this.mPresenterManager.onDestroy());
        }
        if (this.mRedPacketTest != null) {
            this.mRedPacketTest.destroy();
        }
    }

    public void showRedPacket() {
        if (this.mState != HandlerState.start) {
            MLog.error((Object)TAG, (String)"showRedPacket mState: %s", (Object[])new Object[]{this.mState});
            return;
        }
        boolean show = this.getPresenterManager().getPresenter(NewGuidePresenter.class).showGuide(new IPacketPanelListener(){

            @Override
            public void onClick() {
                MLog.info((Object)RedPacketHandler.TAG, (String)"new guide onSend", (Object[])new Object[0]);
                GiftHiidoReport.packetGuideClick(RedPacketHandler.this.roomId());
                RedPacketHandler.this.showSendPacket();
            }

            @Override
            public void onClose() {
                MLog.info((Object)RedPacketHandler.TAG, (String)"new guide onClose", (Object[])new Object[0]);
            }
        });
        if (!show) {
            this.showSendPacket();
        } else {
            GiftHiidoReport.packetGuideShow(this.roomId());
        }
    }

    private void showSendPacket() {
        this.getPresenterManager().getPresenter(SendPacketPresenter.class).showSendPacket();
    }

    public void reqRedPacketEntrance(RedPacketEntranceReqParam param, @Nullable ICommonCallback<RedPacketEntrance> callback2) {
        this.getPresenterManager().getPresenter(EntrancePresenter.class).reqRedPacketEntrance(param, callback2);
    }

    @Nullable
    public RedPacketEntrance getRedPacketEntrance(RedPacketEntranceReqParam param) {
        return this.getPresenterManager().getPresenter(EntrancePresenter.class).getRedPacketEntrance(param);
    }

    private boolean checkResumeState() {
        if (this.mState != HandlerState.start) {
            MLog.error((Object)TAG, (String)"checkResumeState illegal state", (Object[])new Object[0]);
            if (RuntimeContext.sIsDebuggable) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"\u8c03\u8bd5: \u7ea2\u5305\u5b9e\u4f8b\u72b6\u6001\u4e0d\u5bf9", (int)0);
            }
            return false;
        }
        return true;
    }

    @Override
    public void onReceiveBro(Object notify) {
        this.getPresenterManager().onReceiveBro(notify);
        if (ScenePerfOptSceneDef.isScenePressure((String)"red_packet")) {
            if (this.mRedPacketTest == null) {
                this.mRedPacketTest = new RedPacketTest(this);
            }
            this.mRedPacketTest.onReceiveBro(notify);
        }
    }

    public void onClick(PacketChatMsg msg) {
        if (msg == null) {
            MLog.error((Object)TAG, (String)"public chat onClick, msg is null", (Object[])new Object[0]);
            return;
        }
        String packetId = msg.getPacketId();
        if (TextUtils.isEmpty((CharSequence)packetId)) {
            MLog.info((Object)TAG, (String)"public chat onClick packetId is empty", (Object[])new Object[0]);
            return;
        }
        final int type = msg.getType();
        MLog.info((Object)TAG, (String)"public chat onClick packetId: %s, type: %s", (Object[])new Object[]{packetId, type});
        ICommonCallback<PacketResult> callback2 = new ICommonCallback<PacketResult>(){

            public void onSuccess(PacketResult packetResult, Object ... ext) {
                RedPacketHandler.this.getPresenterManager().getPresenter(PacketResultPresenter.class).showPacketResult(packetResult);
                if (type == 3 && packetResult.isGrabPacket()) {
                    RedPacketHandler.this.getPresenterManager().getPresenter(PacketMsgPresenter.class).gotPacketMsg(packetResult.getPacketInfo());
                }
            }

            public void onFail(int errCode, String msg, Object ... ext) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_gift_service_error), (int)0);
            }
        };
        if (type == 3) {
            this.getPresenterManager().getPresenter(GrabPacketPresenter.class).grabPacket(packetId, GrabOrigin.RoomMsg, callback2);
        } else {
            this.getPresenterManager().getPresenter(GrabPacketPresenter.class).queryPacketResult(packetId, callback2);
        }
        GiftHiidoReport.redPacketPublicClick(type, this.roomId());
    }

    public boolean hadGrab(String packetId) {
        GrabPacketState state = this.getPresenterManager().getPresenter(GrabPacketPresenter.class).getGrabPacketState(packetId);
        return state.getGrabState() == GrabPacketState.GrabState.success;
    }

    @Override
    public void onItemClick(final RedPacketFloatingView view, BaseFloatingItem item) {
        if (view != null && item != null && item.getData() instanceof PacketInfo) {
            PacketInfo packetInfo = (PacketInfo)item.getData();
            this.getPresenterManager().getPresenter(GrabPacketPresenter.class).grabPacket(packetInfo.id, GrabOrigin.PacketRain, new ICommonCallback<PacketResult>(){

                public void onSuccess(PacketResult packetResult, Object ... ext) {
                    RedPacketHandler.this.getPresenterManager().getPresenter(FlowPacketPresenter.class).onGrabSuccess(packetResult);
                    RedPacketHandler.this.getPresenterManager().getPresenter(PacketResultPresenter.class).showPacketResult(packetResult);
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                    RedPacketHandler.this.getPresenterManager().getPresenter(FlowPacketPresenter.class).onGrabFailed(view, errCode, msg);
                }
            });
        }
    }

    @Override
    public void onFloatFinished(final PacketInfo packetInfo, int type) {
        if (packetInfo == null) {
            return;
        }
        if (type == 1) {
            this.getPresenterManager().getPresenter(PacketMsgPresenter.class).gotPacketMsg(packetInfo);
        } else if (type == 2) {
            this.getPresenterManager().getPresenter(PacketMsgPresenter.class).packetRainFinish(packetInfo);
        } else if (type == 3) {
            this.getPresenterManager().getPresenter(GrabPacketPresenter.class).queryPacketResult(packetInfo.id, new ICommonCallback<PacketResult>(){

                public void onSuccess(PacketResult result, Object ... ext) {
                    if (PacketUtils.hadRemainPacket(result.getPacketInfo())) {
                        RedPacketHandler.this.getPresenterManager().getPresenter(PacketMsgPresenter.class).remainPacketChatMsg(result.getPacketInfo());
                    } else {
                        GrabPacketState state = RedPacketHandler.this.getPresenterManager().getPresenter(GrabPacketPresenter.class).getGrabPacketState(packetInfo.id);
                        if (state.getGrabState() != GrabPacketState.GrabState.success) {
                            RedPacketHandler.this.getPresenterManager().getPresenter(PacketMsgPresenter.class).packetRainFinish(result.getPacketInfo());
                        }
                    }
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                }
            });
        }
    }

    private synchronized PacketPresenterManager getPresenterManager() {
        if (this.mPresenterManager == null) {
            this.mPresenterManager = new PacketPresenterManager();
        }
        return this.mPresenterManager;
    }
}

