/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.paylevel;

import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.extensions.BaseExtensionKt;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.wallet.base.IPayLevelService;
import com.yy.hiyo.wallet.base.revenue.IGetPayLevelCallback;
import com.yy.hiyo.wallet.base.revenue.IGetRechargeUrlCallback;
import com.yy.hiyo.wallet.paylevel.PayLevelDataModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.money.api.paylevel.RechargeScene;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/yy/hiyo/wallet/paylevel/PayLevelService;", "Lcom/yy/hiyo/wallet/base/IPayLevelService;", "()V", "KEY_MY_PAY_LEVEL", "", "TAG", "refreshTime", "", "getPayLevel", "", "uid", "callback", "Lcom/yy/hiyo/wallet/base/revenue/IGetPayLevelCallback;", "getPayLevelFromCache", "", "queryPayLevel", "updateRechargeUrl", "scene", "Lnet/ihago/money/api/paylevel/RechargeScene;", "wallet_billDebug"})
public final class PayLevelService
implements IPayLevelService {
    private static final String TAG = "PayLevelService";
    private static final String KEY_MY_PAY_LEVEL = "my_pay_level";
    private static long refreshTime;
    public static final PayLevelService INSTANCE;

    public void updateRechargeUrl(@NotNull RechargeScene scene) {
        Intrinsics.checkParameterIsNotNull((Object)scene, (String)"scene");
        MLog.info((Object)TAG, (String)"updateRechargeUrl", (Object[])new Object[0]);
        long currentTime = System.currentTimeMillis();
        long lastCurrentTime = SettingFlags.getLongValue((String)("key_recharge_url_res_time" + AccountUtil.getUid()), (long)0L);
        if (currentTime - lastCurrentTime < refreshTime * (long)1000) {
            MLog.info((Object)TAG, (String)"updateRechargeUrl lastCurrentTime = %s", (Object[])new Object[]{lastCurrentTime});
            return;
        }
        PayLevelDataModel.INSTANCE.getRechargeUrl(scene, new IGetRechargeUrlCallback(currentTime){
            final /* synthetic */ long $currentTime;

            public void onSuccess(boolean isWhite, @NotNull String rechargeUrl, long refreshCacheSeconds) {
                Intrinsics.checkParameterIsNotNull((Object)rechargeUrl, (String)"rechargeUrl");
                MLog.info((Object)"PayLevelService", (String)("isWhite = " + isWhite + ", rechargeUrl = " + rechargeUrl + ',' + " refreshCacheSeconds = " + refreshCacheSeconds), (Object[])new Object[0]);
                SettingFlags.setLongValue((String)("key_recharge_url_res_time" + AccountUtil.getUid()), (long)this.$currentTime);
                PayLevelService.access$setRefreshTime$p(PayLevelService.INSTANCE, refreshCacheSeconds);
                SettingFlags.setLongValue((String)("key_refresh_cache_time" + AccountUtil.getUid()), (long)refreshCacheSeconds);
                if (isWhite && !TextUtils.isEmpty((CharSequence)rechargeUrl)) {
                    SettingFlags.setStringValue((String)("key_recharge_url" + AccountUtil.getUid()), (String)rechargeUrl);
                } else {
                    SettingFlags.removeKey((String)("key_recharge_url" + AccountUtil.getUid()));
                }
            }

            public void onFail(long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                MLog.info((Object)"PayLevelService", (String)("updateRechargeUrl fail code =" + code), (Object[])new Object[0]);
            }
            {
                this.$currentTime = $captured_local_variable$0;
            }
        });
    }

    public void getPayLevel(long uid, @NotNull IGetPayLevelCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        this.queryPayLevel(uid, callback2);
        MLog.debug((Object)TAG, (String)("getPayLevel,uid:" + uid), (Object[])new Object[0]);
    }

    public int getPayLevelFromCache(long uid) {
        return AccountUtil.getUid() == uid ? SettingFlags.getIntValue((String)(KEY_MY_PAY_LEVEL + uid), (int)-1) : -1;
    }

    private final void queryPayLevel(long uid, IGetPayLevelCallback callback2) {
        PayLevelDataModel.INSTANCE.queryUserPayLevel(uid, new IGetPayLevelCallback(uid, callback2){
            final /* synthetic */ long $uid;
            final /* synthetic */ IGetPayLevelCallback $callback;

            public void onSuccess(int level) {
                MLog.info((Object)BaseExtensionKt.getTAG((Object)this), (String)("queryUserPayLevel success,level:" + level), (Object[])new Object[0]);
                if (AccountUtil.getUid() == this.$uid) {
                    SettingFlags.setIntValue((String)("my_pay_level" + this.$uid), (int)level);
                }
                this.$callback.onSuccess(level);
            }

            public void onFail(long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                MLog.info((Object)BaseExtensionKt.getTAG((Object)this), (String)("queryUserPayLevel fail, code:" + code + ", msg:" + msg), (Object[])new Object[0]);
                this.$callback.onFail(code, msg);
            }
            {
                this.$uid = $captured_local_variable$0;
                this.$callback = $captured_local_variable$1;
            }
        });
    }

    private PayLevelService() {
    }

    static {
        PayLevelService payLevelService;
        INSTANCE = payLevelService = new PayLevelService();
        refreshTime = 3600L;
        refreshTime = SettingFlags.getLongValue((String)("key_refresh_cache_time" + AccountUtil.getUid()), (long)refreshTime);
    }

    public static final /* synthetic */ long access$getRefreshTime$p(PayLevelService $this) {
        PayLevelService payLevelService = $this;
        return refreshTime;
    }

    public static final /* synthetic */ void access$setRefreshTime$p(PayLevelService $this, long l) {
        PayLevelService payLevelService = $this;
        refreshTime = l;
    }
}

