/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.request;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.wallet.base.pay.PayPlatform;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.revenue.internal.IRechargeService;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProto;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoReq;
import com.yy.hiyo.wallet.base.revenue.proto.RevenueProtoRes;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.monitor.PayHandlerMonitor;
import com.yy.hiyo.wallet.pay.proto.PayStatus;
import com.yy.hiyo.wallet.pay.proto.bean.OrderResponse;
import com.yy.hiyo.wallet.pay.proto.bean.OrderResult;
import com.yy.hiyo.wallet.pay.request.PayRequestUtils;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.util.HashMap;
import okhttp3.Call;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestOrder {
    private static final String TAG = "FTPayRequestOrder";
    private static final long REQUEST_ORDER_TIME_OUT = 10000L;
    private IPayCallback<OrderResult> mCallback;
    private PayHandlerMonitor mPayHandlerMonitor;
    private IRechargeService<OrderResult> rechargeService;
    private Runnable mTimeoutTask = new Runnable(){

        @Override
        public void run() {
            PayUtils.callbackFailed(RequestOrder.this.mCallback, 10008, "request order timeout");
        }
    };

    public RequestOrder(IRechargeService<OrderResult> rechargeService, PayPlatform platform, RechargeParam info, String seq, String gpCurCode, PayHandlerMonitor monitor, IPayCallback<OrderResult> callback2) {
        this.rechargeService = rechargeService;
        this.mCallback = callback2;
        this.mPayHandlerMonitor = monitor;
        this.requestOrder(platform, info, seq, gpCurCode, callback2);
    }

    public void cancel() {
        YYTaskExecutor.removeTask((Runnable)this.mTimeoutTask);
        this.mCallback = null;
    }

    private void requestOrder(final PayPlatform platform, final RechargeParam info, final String seq, final String gpCurCode, final IPayCallback<OrderResult> callback2) {
        MLog.info((Object)TAG, (String)"requestOrder", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)this.mTimeoutTask, (long)10000L);
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    RequestOrder.this.requestOrderAsync(platform, info, seq, gpCurCode, (IPayCallback<OrderResult>)callback2);
                }
            });
        } else {
            this.requestOrderAsync(platform, info, seq, gpCurCode, callback2);
        }
    }

    private void requestOrderAsync(PayPlatform platform, final RechargeParam info, final String seq, String gpCurCode, final IPayCallback<OrderResult> callback2) {
        RevenueProtoReq.Builder builder = RevenueProtoReq.newBuilder();
        builder.appId(1802);
        builder.version(0);
        builder.cmd(1022);
        builder.countryCode(AccountUtil.realCountry());
        JsonStringBuilder param = RevenueProto.getCommonParam();
        param.put("seq", (Object)seq);
        param.put("cmd", (Object)1022);
        param.put("usedChannel", (Object)info.getUseChannel());
        HashMap<String, Object> ext = new HashMap<String, Object>();
        int from = info.getFrom();
        ext.put("chargeEntry", from >= 1 && from <= 4 ? from : 9);
        if (info.getUserCouponId() != 0L) {
            ext.put("userCouponId", info.getUserCouponId());
        }
        if (!TextUtils.isEmpty((CharSequence)gpCurCode)) {
            ext.put("currencyCode", gpCurCode);
        }
        if (info.getExpand() != null) {
            ext.putAll(info.getExpand());
        }
        String expand = PayRequestUtils.getExpand(info.getQuantity(), info.getUnitPrice(), info.getProductId(), HiidoUtils.getHdid(), info.getSrcCurrencySymbol(), ext);
        param.put("expand", (Object)expand);
        param.put("payChannel", (Object)platform.getChannel());
        param.put("payMethod", (Object)platform.getMethod());
        param.put("amount", (Object)info.getUnitPrice());
        param.put("chargeCurrencyConfigId", (Object)info.getChargeConfigId());
        param.put("needUnicast", (Object)true);
        param.put("returnUrl", (Object)"");
        builder.jsonMsg(param.jsonObject());
        RevenueProtoReq req = builder.build();
        String url = RevenueProto.getUrl((String)"api", (int)req.getCmd());
        MLog.info((Object)TAG, (String)"requestOrderAsync url: %s", (Object[])new Object[]{url});
        RevenueProto.sendHttp((String)url, (RevenueProtoReq)req, (RevenueProto.RevenueProtoCallback)new RevenueProto.RevenueProtoCallback(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)RequestOrder.TAG, (String)"requestOrderAsync", (Throwable)e, (Object[])new Object[0]);
                if (RequestOrder.this.mPayHandlerMonitor != null) {
                    RequestOrder.this.mPayHandlerMonitor.reportRequestMetric(seq, String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
                }
                YYTaskExecutor.removeTask((Runnable)RequestOrder.this.mTimeoutTask);
                String msg = e.getMessage();
                PayUtils.callbackFailed(callback2, 41001, msg);
            }

            public void onResponse(final RevenueProtoRes response, int id2) {
                MLog.info((Object)RequestOrder.TAG, (String)"requestOrderAsync onResponse %s", (Object[])new Object[]{response});
                if (RequestOrder.this.mPayHandlerMonitor != null) {
                    RequestOrder.this.mPayHandlerMonitor.reportRequestMetric(seq, "0");
                }
                YYTaskExecutor.removeTask((Runnable)RequestOrder.this.mTimeoutTask);
                if (YYTaskExecutor.isMainThread()) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RequestOrder.this.handleOrderRes(info, response, (IPayCallback<OrderResult>)callback2);
                        }
                    });
                } else {
                    RequestOrder.this.handleOrderRes(info, response, (IPayCallback<OrderResult>)callback2);
                }
            }
        });
    }

    @WorkerThread
    private void handleOrderRes(RechargeParam info, RevenueProtoRes response, IPayCallback<OrderResult> callback2) {
        OrderResponse res = this.parseResponse(response, OrderResponse.class);
        if (res == null) {
            PayUtils.callbackFailed(callback2, 41001, "maybe parse response json error");
            return;
        }
        int code = 41000 + res.result;
        if (code == 40929) {
            PayUtils.callbackFailed(callback2, code, this.getChallengeExtension(res.expand));
            return;
        }
        if (res.result != PayStatus.OK.getCode()) {
            if (code == 40982) {
                String msg = res.message;
                if (!TextUtils.isEmpty((CharSequence)msg)) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)msg, (int)1);
                } else {
                    MLog.error((Object)TAG, (String)"message tips is empty", (Object[])new Object[0]);
                }
            }
            PayStatus status = PayStatus.valueOf(res.result);
            PayUtils.callbackFailed(callback2, code, res.message != null ? res.message : status.getMessage());
            return;
        }
        OrderResult result = new OrderResult(info, res, response.result);
        PayUtils.callbackSucceed(callback2, result);
    }

    @WorkerThread
    @Nullable
    private <T> T parseResponse(RevenueProtoRes response, Class<T> cls) {
        Object res;
        block3: {
            if (response == null || TextUtils.isEmpty((CharSequence)response.jsonMsg)) {
                return null;
            }
            res = null;
            try {
                res = JsonParser.parseJsonObject((String)response.jsonMsg, cls);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"parseResponse", (Throwable)e, (Object[])new Object[0]);
                if (!RuntimeContext.sIsDebuggable) break block3;
                throw e;
            }
        }
        return (T)res;
    }

    private String getChallengeExtension(String expand) {
        try {
            JSONObject json = JsonParser.obtainJSONObject((String)expand);
            String risk = json.getString("riskData");
            JSONObject riskJson = JsonParser.obtainJSONObject((String)risk);
            return riskJson.optString("challengeExtension");
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            return "";
        }
    }
}

