/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay.question.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.framework.R;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.pay.question.adapter.ItemClickCallBack;
import com.yy.hiyo.wallet.pay.question.adapter.QuestionAdapter;
import com.yy.hiyo.wallet.pay.question.bean.QuestionInfo;
import com.yy.hiyo.wallet.pay.stats.RechargeHiidoReport;
import java.util.List;

public class QuestionDialog
extends YYDialog {
    private Context mContext;
    private QuestionAdapter questionAdapter;
    private RecyclerView recyclerView;
    private View mView;
    private YYTextView tittleTv;

    public QuestionDialog(Context context, DialogInterface.OnCancelListener cancelListener) {
        super(context, R.style.Dialog_Fullscreen);
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        this.mContext = context;
        this.createView();
        this.setOnCancelListener(cancelListener);
    }

    public void setData(List<QuestionInfo> questionInfoList) {
        this.questionAdapter.setDate(questionInfoList);
    }

    private void createView() {
        this.mView = View.inflate((Context)this.mContext, (int)R.layout.layout_question_center_panel, null);
        this.recyclerView = (RecyclerView)this.mView.findViewById(R.id.question_list);
        this.tittleTv = (YYTextView)this.mView.findViewById(R.id.tittle);
        this.questionAdapter = new QuestionAdapter(this.mContext);
        this.setContentView(this.mView);
        Window window = this.getWindow();
        WindowManager.LayoutParams params = window.getAttributes();
        params.height = -2;
        window.setGravity(80);
        window.setAttributes(params);
        this.getWindow().setWindowAnimations(R.style.DialogAnimation);
        GridLayoutManager layoutManager = new GridLayoutManager(this.mContext, 2);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.questionAdapter);
    }

    public void setOnClickListener(ItemClickCallBack itemClickCallBack) {
        this.questionAdapter.setOnClickListener(itemClickCallBack);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        RechargeHiidoReport.quePopDismiss();
    }
}

