/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay;

import androidx.annotation.NonNull;
import com.yy.appbase.appsflyer.ThirdTrackEvent;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.thirdnotify.IThirdNotify;
import com.yy.hiyo.proto.thirdnotify.ThirdNotifyUri;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeSuccessListener;
import java.util.HashSet;
import java.util.Set;

public class RechargeSuccessBro
implements IThirdNotify<RechargeInfo> {
    private static final String TAG = "FTPayRechargeSuccessBro";
    private final Set<IRechargeSuccessListener> mPayListeners = new HashSet<IRechargeSuccessListener>();

    public RechargeSuccessBro() {
        ProtoManager.getInstance().registerThirdNotify(RechargeInfo.class, (IThirdNotify)this);
    }

    public ThirdNotifyUri.Uri uri() {
        return ThirdNotifyUri.RECHARGE_SUCCESS;
    }

    public void onNotify(@NonNull RechargeInfo notify) {
        MLog.info((Object)TAG, (String)"RechargeSuccessBro notify: %s", (Object[])new Object[]{notify});
        this.notifyRechargeSucceed(notify);
    }

    public void addPayListener(IRechargeSuccessListener listener) {
        if (listener != null) {
            this.mPayListeners.add(listener);
        }
    }

    public void removePayListener(IRechargeSuccessListener listener) {
        if (listener != null) {
            this.mPayListeners.remove(listener);
        }
    }

    private void notifyRechargeSucceed(RechargeInfo data) {
        if (data == null) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            this.notifyJsRechargeBro(data);
            this.reportEvent(data);
        });
        for (IRechargeSuccessListener item : this.mPayListeners) {
            item.onSuccess(data);
        }
    }

    private void reportEvent(RechargeInfo data) {
        ThirdTrackHelper.INSTANCE.reportPurchaseEvent(ThirdTrackEvent.PURCHASE, data.getChargeAmount(), data.getOrderId(), "USD");
    }

    private void notifyJsRechargeBro(RechargeInfo data) {
        if (data == null) {
            return;
        }
        try {
            String json = JsonParser.toJson((Object)data);
            if (ServiceManagerProxy.getServiceManager() != null) {
                ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadNotifyJs("", JsEventDefine.NOTIFY.onRechargeSuccessBro, json);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"notifyJsRechargeBro ", (Throwable)e, (Object[])new Object[0]);
        }
    }
}

