/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.pay;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.PackageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.billing.base.RechargeResult;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.wallet.accumulate.AccumulateManager;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.IPlatformPay;
import com.yy.hiyo.wallet.base.pay.PayPlatform;
import com.yy.hiyo.wallet.base.pay.bean.BalanceResponse;
import com.yy.hiyo.wallet.base.pay.bean.CharmValue;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.bean.CouponDiscountBean;
import com.yy.hiyo.wallet.base.pay.bean.OrderInfoRes;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.bean.UserRevenue;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.pay.callback.IRecentPayCallback;
import com.yy.hiyo.wallet.base.pay.callback.IRechargeCallback;
import com.yy.hiyo.wallet.base.revenue.internal.IPayHandler;
import com.yy.hiyo.wallet.base.revenue.internal.IRechargeService;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeHandler;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeSuccessListener;
import com.yy.hiyo.wallet.coupon.net.CouponRequest;
import com.yy.hiyo.wallet.pay.PayRequestManager;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.RechargeSuccessBro;
import com.yy.hiyo.wallet.pay.handler.IHandlerCallback;
import com.yy.hiyo.wallet.pay.monitor.PayMonitor;
import com.yy.hiyo.wallet.pay.platform.PlatformPayFactory;
import com.yy.hiyo.wallet.pay.platform.utils.GoogleServiceUtils;
import com.yy.hiyo.wallet.pay.request.OrderInfoRequest;
import com.yy.hiyo.wallet.pay.request.RechargeListRequest;
import com.yy.hiyo.wallet.pay.sku.SkuDetailManager;
import com.yy.hiyo.wallet.recharge.internal.RechargeService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.ihago.money.api.pay.GetCharmValueRequest;
import net.ihago.money.api.pay.GetCharmValueResponse;
import net.ihago.money.api.pay.GetUserRevenueOrigin;
import net.ihago.money.api.pay.GetUserRevenueRequest;
import net.ihago.money.api.pay.GetUserRevenueResponse;

public class PayService
implements IPayService,
INotify,
IHandlerCallback {
    private static final String TAG = "FTPayPayService";
    private final IRechargeService rechargeService;
    private PayRequestManager mPayRequest;
    private final RechargeListRequest mRechargeListRequest;
    private final List<IRechargeHandler> mHandlerList = new ArrayList<IRechargeHandler>();
    private CouponRequest mCouponRequest;
    private OrderInfoRequest mOrderInfoRequest;
    private final SkuDetailManager mSkuDetailManager;
    private final RechargeSuccessBro mRechargeSuccessBro;

    public PayService() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        this.mSkuDetailManager = new SkuDetailManager();
        this.rechargeService = RechargeService.INSTANCE.createRechargeService(this.mSkuDetailManager);
        this.mRechargeListRequest = new RechargeListRequest(this.rechargeService);
        this.mRechargeSuccessBro = new RechargeSuccessBro();
        this.mRechargeSuccessBro.addPayListener(new IRechargeSuccessListener(){

            public void onSuccess(RechargeInfo info) {
                PayService.this.rechargeService.onRechargeBroSuccess(info);
            }
        });
        if (RuntimeContext.sIsAppStartFinishAfterThreeSecond) {
            this.mRechargeListRequest.initCache();
        }
        AccumulateManager.INSTANCE.registerAccRechargeListener();
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
            PayMonitor.checkLastUnfinishRecharge();
            PackageUtils.getPackageVersion((String)"com.google.android.gms");
            PackageUtils.getPackageVersion((String)"com.android.vending");
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) {
            if (AccountUtil.getUid() > 0L) {
                this.mRechargeListRequest.initCache();
                this.checkAbnormalOrder();
                YYTaskExecutor.execute(() -> this.mSkuDetailManager.startup());
            }
        } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            if (RuntimeContext.sIsAppStartFinishAfterThreeSecond) {
                YYTaskExecutor.execute(() -> {
                    this.mRechargeListRequest.initCache();
                    this.checkAbnormalOrder();
                }, (long)1000L);
            }
        } else if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.mRechargeListRequest.clearCache();
        } else if (notification.id == NotificationDef.N_NETWORK_STATE_CHANGE && NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) && RuntimeContext.sIsAppStartFinishAfterThreeSecond) {
            this.mRechargeListRequest.netWorkChange();
        }
    }

    @NonNull
    public IRechargeHandler recharge(@NonNull PayPlatform platform, @NonNull Activity activity, @NonNull RechargeParam info, final IRechargeCallback callback2) {
        MLog.info((Object)TAG, (String)"recharge platform: %s, info: %s", (Object[])new Object[]{platform, info});
        GoogleServiceUtils.checkGoogleServicesAvailableAndUpdate(activity);
        IRechargeHandler handler = this.createRechargeHandler(platform, (Function1<IRechargeHandler, Unit>)((Function1)handler1 -> {
            this.onHandlerFinished((IPayHandler)handler1);
            return null;
        }));
        handler.rechargeWithOrder(activity, info, new IRechargeCallback(){

            public void onSucceed(@Nullable RechargeInfo data) {
                PayUtils.callbackSucceed(callback2, data);
            }

            public void onFailed(int code, String msg) {
                PayUtils.callbackFailed(callback2, code, msg);
            }

            public void onRechargeSuccess(RechargeResult result) {
                PayUtils.callbackRechargeSuccess(callback2, result);
            }

            public int rechargeSource() {
                return callback2 != null ? callback2.rechargeSource() : 0;
            }
        });
        this.mHandlerList.add(handler);
        return handler;
    }

    public void rechargeDirect(String orderId, String payload, @NonNull Activity activity, @NonNull RechargeParam info, IRechargeCallback callback2) {
        MLog.info((Object)TAG, (String)"rechargeDirect, info: %s", (Object[])new Object[]{info});
        IRechargeHandler handler = this.createRechargeHandler(PayUtils.getPayPlatform(), (Function1<IRechargeHandler, Unit>)((Function1)handler1 -> {
            this.onHandlerFinished((IPayHandler)handler1);
            return null;
        }));
        handler.rechargeDirect(orderId, payload, activity, info, callback2);
        this.mHandlerList.add(handler);
    }

    @Override
    public void onHandlerFinished(IPayHandler handler) {
        MLog.info((Object)TAG, (String)"onHandlerFinished", (Object[])new Object[0]);
        if (handler == null) {
            return;
        }
        if (this.mHandlerList.remove(handler)) {
            handler.destroy();
        }
    }

    @Nullable
    public List<ProductItemInfo> fetchRechargeList() {
        return this.mRechargeListRequest.getRechargeList();
    }

    public void fetchRechargeList(int from, String pageId, Map<String, Object> expand, final IPayCallback<List<ProductItemInfo>> callback2) {
        this.mRechargeListRequest.requestRechargeList(from, pageId, expand, new IPayCallback<List<ProductItemInfo>>(){

            public void onSucceed(@Nullable List<ProductItemInfo> data) {
                PayUtils.callbackSucceed(callback2, data);
            }

            public void onFailed(int code, String msg) {
                PayUtils.callbackFailed(callback2, code, msg);
            }
        });
    }

    public void fetchRechargeList(int from, Map<String, Object> expand, IPayCallback<List<ProductItemInfo>> callback2) {
        this.fetchRechargeList(from, "", expand, callback2);
    }

    public ProductItemInfo getRechargeItemInfo(String productId) {
        return this.mRechargeListRequest.getRechargeItemInfo(productId);
    }

    public void queryBalance(int from, IPayCallback<BalanceResponse> callback2) {
        this.getPayRequest().queryBalance(from, callback2);
    }

    public void queryUserRevenue(long uid, long seqId, GetUserRevenueOrigin origin, final IPayCallback<UserRevenue> callback2) {
        GetUserRevenueRequest request = new GetUserRevenueRequest.Builder().uid(Long.valueOf(uid)).origin(Integer.valueOf(origin != null ? origin.getValue() : GetUserRevenueOrigin.KOriginNone.getValue())).sequence(Long.valueOf(seqId)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)request, (IProtoCallback)new IProtoCallback<GetUserRevenueResponse>(){

            public void onResponse(@Nullable GetUserRevenueResponse message) {
                if (message != null) {
                    MLog.info((Object)PayService.TAG, (String)"queryUserRevenue on amount: %d, code: %d", (Object[])new Object[]{message.amount, message.code});
                }
                if (callback2 != null) {
                    UserRevenue userRevenue = new UserRevenue();
                    userRevenue.amount = message == null ? 0L : message.amount;
                    userRevenue.code = message == null ? -1 : message.code;
                    userRevenue.sequence = message == null ? 0L : message.sequence;
                    long l = userRevenue.uid = message == null ? 0L : message.uid;
                    if (userRevenue.code == 0) {
                        callback2.onSucceed((Object)userRevenue);
                    } else {
                        callback2.onFailed(userRevenue.code, "");
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)PayService.TAG, (String)"queryUserRevenue on timeout", (Object[])new Object[0]);
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFailed(-1, "retryWhenTimeout");
                        }
                    }
                };
                if (YYTaskExecutor.isMainThread()) {
                    runnable2.run();
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)runnable2);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                MLog.error((Object)PayService.TAG, (String)"queryUserRevenue on error,reason:%s, code:%d", (Object[])new Object[]{reason, code});
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFailed(code, reason);
                        }
                    }
                };
                if (YYTaskExecutor.isMainThread()) {
                    runnable2.run();
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)runnable2);
                }
                return false;
            }
        });
    }

    public void queryCharmValue(long uid, long seqId, GetUserRevenueOrigin origin, final IPayCallback<CharmValue> callback2) {
        GetCharmValueRequest request = new GetCharmValueRequest.Builder().uid(Long.valueOf(uid)).sequence(Long.valueOf(seqId)).origin(Integer.valueOf(origin != null ? origin.getValue() : GetUserRevenueOrigin.KOriginNone.getValue())).build();
        ProtoManager.getInstance().sendHttp((AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<GetCharmValueResponse>(){

            public void onResponse(@Nullable GetCharmValueResponse message) {
                super.onResponse((AndroidMessage)message);
                if (callback2 != null) {
                    if (message == null) {
                        callback2.onFailed(0, "message is null");
                    } else if (message.code == 0) {
                        CharmValue charmValue = new CharmValue();
                        charmValue.charmValue = message.charmValue;
                        callback2.onSucceed((Object)charmValue);
                    } else {
                        callback2.onFailed(message.code.intValue(), message.msg);
                    }
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback2 != null) {
                    callback2.onFailed(code, reason);
                }
            }
        });
    }

    public void checkAbnormalOrder() {
        this.rechargeService.checkHangJob();
    }

    public void addPayListener(IRechargeSuccessListener listener) {
        this.mRechargeSuccessBro.addPayListener(listener);
    }

    public void removePayListener(IRechargeSuccessListener listener) {
        this.mRechargeSuccessBro.removePayListener(listener);
    }

    public void queryCouponListAsync(boolean isUsed, IPayCallback<List<CouponBean>> callback2) {
        PayUtils.callbackSucceed(callback2, Collections.emptyList());
    }

    public void queryCouponDiscountAsync(long userCouponId, List<Integer> chargeConfigIds, IPayCallback<List<CouponDiscountBean>> callback2) {
        PayUtils.callbackSucceed(callback2, Collections.emptyList());
    }

    public void queryOrderInfo(long orderId, IPayCallback<OrderInfoRes> callback2) {
        this.getOrderInfoRequest().queryOrderInfo(orderId, callback2);
    }

    public IPlatformPay getPay(PayPlatform platform) {
        return PlatformPayFactory.getPay(platform);
    }

    public IPlatformPay getPay() {
        return this.getPay(PayUtils.getPayPlatform());
    }

    private OrderInfoRequest getOrderInfoRequest() {
        if (this.mOrderInfoRequest == null) {
            this.mOrderInfoRequest = new OrderInfoRequest();
        }
        return this.mOrderInfoRequest;
    }

    public IRechargeHandler createRechargeHandler(@NonNull PayPlatform platform, Function1<IRechargeHandler, Unit> onFinish2) {
        return this.rechargeService.newRechargeSession(platform, onFinish2);
    }

    public boolean isUseRevenueSdk() {
        return RechargeService.INSTANCE.isUseSdk();
    }

    public void retryUpdateState(String orderId) {
        MLog.info((Object)TAG, (String)"retryUpdateState orderId: %s", (Object[])new Object[]{orderId});
        this.rechargeService.retryUpdateState(orderId);
    }

    public void getRecentPay(IRecentPayCallback callback2) {
        this.rechargeService.getRecentPay(callback2);
    }

    private PayRequestManager getPayRequest() {
        if (this.mPayRequest == null) {
            this.mPayRequest = new PayRequestManager();
        }
        return this.mPayRequest;
    }

    public IRechargeService getRechargeService() {
        return this.rechargeService;
    }

    private CouponRequest getCouponRequest() {
        if (this.mCouponRequest == null) {
            this.mCouponRequest = new CouponRequest();
        }
        return this.mCouponRequest;
    }

    public static class DefaultPayCallback<T>
    implements IPayCallback<T> {
        public void onSucceed(@Nullable T data) {
            MLog.info((Object)PayService.TAG, (String)"DefaultPayCallback onSucceed data: %s", (Object[])new Object[]{data});
        }

        public void onFailed(int code, String msg) {
            MLog.error((Object)PayService.TAG, (String)"DefaultPayCallback onFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
        }
    }
}

