/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.module.recharge.page;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.common.Callback;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.ui.widget.tablayout.MsgView;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.pay.bean.BeanTabConfig;
import com.yy.hiyo.wallet.base.pay.bean.WalletTabConfig;
import com.yy.hiyo.wallet.module.recharge.IRechargeUiCallback;
import com.yy.hiyo.wallet.module.recharge.bean.RechargeTaskGuideData;
import com.yy.hiyo.wallet.module.recharge.page.BaseWalletPage;
import com.yy.hiyo.wallet.module.recharge.page.tab.RechargeNewTab;
import com.yy.hiyo.wallet.pay.stats.RechargeHiidoReport;
import com.yy.hiyo.wallet.recharge.page.IRechargeView;
import com.yy.hiyo.wallet.recharge.page.WalletPagerAdapter;
import com.yy.hiyo.wallet.recharge.page.tab.BeansWebViewTab;
import com.yy.hiyo.wallet.recharge.page.tab.ITabView;
import com.yy.hiyo.wallet.recharge.page.tab.TabPageInfo;
import com.yy.hiyo.wallet.recharge.page.tab.ThirdWebPageTab;
import java.util.ArrayList;
import java.util.List;
import net.ihago.money.api.noblerebate.GetGuideInfoRsp;
import org.jetbrains.annotations.Nullable;

public class WalletPage
extends BaseWalletPage {
    private static final String TAG = "WalletPage";
    private YYViewPager mViewPager;
    private WalletPagerAdapter mPagerAdapter;
    private IRechargeView mRechargeTab;
    private BeansWebViewTab mBeansTab;
    private int mCurPosition = 0;
    private int mBeanIndex = -1;
    private int mDefaultSelectTab = -1;
    private String rechargeUrl;
    private String mPageId = "";
    private BeanTabConfig mBeanTabConfig = null;
    private WalletTabConfig mWalletTabConfig = null;
    private final List<TabPageInfo> mPageTabs = new ArrayList<TabPageInfo>(3);

    public WalletPage(Context context, IRechargeUiCallback callBacks, WalletTabConfig walletTabConfig, int selectTab, String rechargeUrl) {
        super(context, callBacks);
        this.mPageId = callBacks.getPageId();
        this.mWalletTabConfig = walletTabConfig;
        this.rechargeUrl = rechargeUrl;
        this.mDefaultSelectTab = selectTab;
        this.createView();
    }

    private void createView() {
        this.createViewPage();
        this.addToRootView((View)this.mViewPager);
        this.mPagerAdapter = new WalletPagerAdapter();
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                int oldPosition = WalletPage.this.mCurPosition;
                WalletPage.this.mCurPosition = position;
                if (WalletPage.this.mBeansTab != null && WalletPage.this.mPageTabs.size() > WalletPage.this.mCurPosition && ((TabPageInfo)((WalletPage)WalletPage.this).mPageTabs.get((int)((WalletPage)WalletPage.this).mCurPosition)).page == WalletPage.this.mBeansTab && WalletPage.this.getMRechargeCallBacks() != null && WalletPage.this.mBeanTabConfig != null && ((WalletPage)WalletPage.this).mBeanTabConfig.showBeanTab) {
                    BeanTabConfig beanTabConfig = new BeanTabConfig(true, false);
                    WalletPage.this.getMRechargeCallBacks().updateBeanTabConfig(beanTabConfig);
                    WalletPage.this.getMTabStrip().hideMsg(WalletPage.this.mCurPosition);
                    MLog.info((Object)WalletPage.TAG, (String)"dismiss bean read point", (Object[])new Object[0]);
                }
                if (WalletPage.this.mCurPosition == WalletPage.this.mBeanIndex && WalletPage.this.mBeansTab != null) {
                    WalletPage.this.mBeansTab.onSelect();
                    RechargeHiidoReport.beanTab();
                }
                if (WalletPage.this.mCurPosition == 0 && WalletPage.this.getRechargeView() != null) {
                    WalletPage.this.getRechargeView().onSelect();
                }
                WalletPage.this.pageSelectChanged(oldPosition, position);
            }
        });
        this.mBeansTab = new BeansWebViewTab(this.getContext(), UriProvider.getBeansUrl());
        this.showBeanItemView(this.getMRechargeCallBacks().getBeanTabConfig());
        this.initPresenter();
    }

    @Override
    @javax.annotation.Nullable
    public View getTopBar() {
        return this.getHeaderContainer();
    }

    private void createViewPage() {
        this.mViewPager = new YYViewPager(this.getContext());
        this.mViewPager.setClipChildren(false);
        this.mViewPager.setOverScrollMode(2);
    }

    @Override
    @Nullable
    protected IRechargeView getRechargeView() {
        if (this.mRechargeTab != null) {
            return this.mRechargeTab;
        }
        if (this.isWebRechargePage()) {
            ThirdWebPageTab rechargeTab = new ThirdWebPageTab(this.getContext(), this.rechargeUrl);
            rechargeTab.setPageId(this.mPageId);
            this.mRechargeTab = rechargeTab;
        } else {
            this.mRechargeTab = new RechargeNewTab(this.getContext(), this.getMRechargeCallBacks(), 4);
        }
        return this.mRechargeTab;
    }

    private boolean isWebRechargePage() {
        return !TextUtils.isEmpty((CharSequence)this.rechargeUrl);
    }

    private void initPresenter() {
        if (this.isWebRechargePage()) {
            if (this.getRechargeView() != null && this.mDefaultSelectTab <= 0) {
                this.getRechargeView().onSelect();
            }
            return;
        }
        this.fetchWalletActivity((Callback<ActivityAction>)((Callback)this::updateActivityAction));
    }

    private void showRechargeTab() {
        this.mPageTabs.add(new TabPageInfo(ResourceUtils.getString((int)R.string.title_wallet_diamond), this.getRechargePage()));
    }

    public void showBeanItemView(BeanTabConfig config) {
        if (this.mBeanTabConfig != null && config != null && this.mBeanTabConfig.showBeanTab == config.showBeanTab && this.mBeanTabConfig.showBeanTabReadPoint == config.showBeanTabReadPoint) {
            MLog.info((Object)TAG, (String)"config equals, do not need to update,config:%s", (Object[])new Object[]{this.mBeanTabConfig});
            return;
        }
        this.mBeanTabConfig = config;
        boolean visible = false;
        this.mPageTabs.clear();
        this.showRechargeTab();
        int index = 1;
        if (config != null && config.showBeanTab) {
            this.mBeanIndex = index++;
            this.mPageTabs.add(new TabPageInfo(ResourceUtils.getString((int)R.string.title_wallet_bean), (View)this.mBeansTab));
        }
        if (FP.size(this.mPageTabs) > 1) {
            visible = true;
        }
        this.getMTabStrip().setVisibility(visible ? 0 : 4);
        this.getMTitleTv().setVisibility(visible ? 8 : 0);
        this.updateTabUI(visible);
    }

    private View getRechargePage() {
        return this.getRechargeView().getPage();
    }

    private void updateTabUI(boolean visible) {
        this.mPagerAdapter.setData(this.mPageTabs);
        this.mViewPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.getMTabStrip().setViewPager((ViewPager)this.mViewPager);
        if (visible) {
            if (this.mBeanTabConfig != null && this.mBeanTabConfig.showBeanTab) {
                if (this.mBeanTabConfig.showBeanTabReadPoint) {
                    MsgView dot = this.getMTabStrip().getMsgView(this.mBeanIndex);
                    int radio = ResolutionUtils.dip2Px((float)6.0f);
                    dot.setWidth(radio);
                    dot.setHeight(radio);
                    this.getMTabStrip().showDot(this.mBeanIndex);
                } else {
                    this.getMTabStrip().hideMsg(this.mBeanIndex);
                }
            }
            if (this.mDefaultSelectTab >= 0 && this.mDefaultSelectTab < this.mPageTabs.size()) {
                this.getMTabStrip().setCurrentTab(this.mDefaultSelectTab);
            }
        }
        this.pageSelectChanged(-1, this.getMTabStrip().getCurrentTab());
    }

    @Override
    public boolean goBack(int type) {
        if (this.mCurPosition == this.mBeanIndex) {
            if (this.mBeansTab != null && this.mBeansTab.canGoBack()) {
                this.mBeansTab.goBack(type);
                return true;
            }
        } else if (this.mCurPosition == 0 && this.getRechargeView() != null && this.getRechargeView().canGoBack()) {
            this.getRechargeView().goBack(type);
            return true;
        }
        return false;
    }

    private void pageSelectChanged(int oldPosition, int position) {
        View oldTab = this.mPagerAdapter.getTabView(oldPosition);
        View currentTab = this.mPagerAdapter.getTabView(position);
        if (oldTab instanceof ITabView) {
            ((ITabView)oldTab).onSelectChanged(false, oldPosition);
        }
        if (currentTab instanceof ITabView) {
            ((ITabView)currentTab).onSelectChanged(true, position);
        }
    }

    @Override
    public void setBroadcast(GetGuideInfoRsp rsp) {
        if (this.getRechargeView() != null) {
            this.getRechargeView().setBroadcast(rsp);
        }
    }

    @Override
    public void setRechargeGuide(RechargeTaskGuideData data) {
        if (this.getRechargeView() != null) {
            this.getRechargeView().setRechargeGuide(data);
        }
    }

    @Override
    public void onDestroy() {
        if (this.mBeansTab != null) {
            this.mBeansTab.destroy();
        }
        if (this.mRechargeTab != null) {
            this.mRechargeTab.onDestroy();
        }
    }
}

