/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.module.recharge.page;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.wallet.base.pay.bean.BalanceInfo;
import com.yy.hiyo.wallet.base.pay.bean.BeanTabConfig;
import com.yy.hiyo.wallet.base.pay.bean.PeriodBalanceInfo;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.base.pay.bean.WalletTabConfig;
import com.yy.hiyo.wallet.module.recharge.IRechargeUiCallback;
import com.yy.hiyo.wallet.module.recharge.bean.RechargeTaskGuideData;
import com.yy.hiyo.wallet.module.recharge.page.NativeWalletPage;
import com.yy.hiyo.wallet.module.recharge.page.WalletPage;
import com.yy.hiyo.wallet.recharge.page.IRechargeView;
import java.util.List;
import net.ihago.money.api.noblerebate.GetGuideInfoRsp;

public class RechargeWindow
extends DefaultWindow {
    private final IRechargeView mWalletPage;

    public RechargeWindow(Context context, IRechargeUiCallback callBacks, WalletTabConfig walletTabConfig, int tab, String rechargeUrl, boolean isOnlyNative) {
        super(context, (UICallBacks)callBacks, "recharge");
        this.setWindowType(113);
        this.mWalletPage = isOnlyNative ? new NativeWalletPage(context, callBacks) : new WalletPage(context, callBacks, walletTabConfig, tab, rechargeUrl);
        this.getBaseLayer().addView(this.mWalletPage.getPage());
    }

    public void updateBalance(List<BalanceInfo> datas) {
        if (this.mWalletPage != null) {
            this.mWalletPage.updateBalance(datas);
        }
    }

    public void updateList(List<ProductItemInfo> list) {
        if (this.mWalletPage != null) {
            this.mWalletPage.updateList(list);
        }
    }

    public void loadFailed() {
        if (this.mWalletPage != null) {
            this.mWalletPage.loadFailed();
        }
    }

    public void onShown() {
        super.onShown();
        this.setSoftInputMode(18);
        if (this.mWalletPage != null) {
            this.mWalletPage.onShown();
        }
    }

    public void onDetached() {
        super.onDetached();
        if (this.mWalletPage != null) {
            this.mWalletPage.onDestroy();
        }
    }

    public void updateBeanTagConfig(BeanTabConfig beanTabConfig) {
        if (this.mWalletPage instanceof WalletPage) {
            ((WalletPage)this.mWalletPage).showBeanItemView(beanTabConfig);
        }
    }

    public boolean goBack(int type) {
        if (this.mWalletPage != null) {
            return this.mWalletPage.goBack(type);
        }
        return false;
    }

    public void setProductId(String productId) {
        if (productId != null) {
            this.mWalletPage.setProductId(productId);
        }
    }

    public void setCouponLayoutStatus(String couponName, boolean visibility) {
        if (this.mWalletPage != null) {
            this.mWalletPage.setCouponLayoutStatus(couponName, visibility);
        }
    }

    public List<ProductItemInfo> getProductData() {
        if (this.mWalletPage != null) {
            return this.mWalletPage.getProductData();
        }
        return null;
    }

    public void updataRechargeList() {
        if (this.mWalletPage != null) {
            this.mWalletPage.updateRechargeList();
        }
    }

    public void updatePeriodBalance(List<PeriodBalanceInfo> accountPeriodList) {
        if (this.mWalletPage != null) {
            this.mWalletPage.updatePeriodBalance(accountPeriodList);
        }
    }

    public void setBroadcast(GetGuideInfoRsp rsp) {
        if (this.mWalletPage != null) {
            this.mWalletPage.setBroadcast(rsp);
        }
    }

    public boolean isTranslucentBar() {
        return true;
    }

    public boolean isDarkMode() {
        return true;
    }

    @Nullable
    public View getNeedOffsetView() {
        return this.mWalletPage.getTopBar();
    }

    public void setRechargeGuide(RechargeTaskGuideData data) {
        if (this.mWalletPage != null) {
            this.mWalletPage.setRechargeGuide(data);
        }
    }
}

