/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.module.recharge.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.lifecycle.Observer;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.widget.tablayout.OnTabSelectListener;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.RechargeTipsConfig;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.pay.bean.BalanceInfo;
import com.yy.hiyo.wallet.base.pay.bean.BeanTabConfig;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.module.recharge.dialog.ActivityWebViewTab;
import com.yy.hiyo.wallet.module.recharge.dialog.IRechargeDialogCallback;
import com.yy.hiyo.wallet.module.recharge.dialog.RechargeDialogPresenter;
import com.yy.hiyo.wallet.module.recharge.dialog.RechargeDialogTab;
import com.yy.hiyo.wallet.module.recharge.page.RechargeScaleAnimHelper;
import com.yy.hiyo.wallet.recharge.ThirdWebViewTab;
import com.yy.hiyo.wallet.recharge.page.WalletPagerAdapter;
import com.yy.hiyo.wallet.recharge.page.tab.TabPageInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;

public class RechargeDialog
implements BaseDialog {
    private static final String TAG = "RechargeDialog";
    private static final int WEB_TAB_INDEX = 0;
    private IRechargeDialogCallback mRechargeDialogCallback;
    private RechargeDialogTab mRechargeTab;
    private SlidingTabLayout mTabStrip;
    private YYViewPager mViewPager;
    private WalletPagerAdapter mPagerAdapter;
    private int mCurPosition;
    private Context mContext;
    private BeanTabConfig mBeanTabConfig = null;
    private ActivityWebViewTab mWebViewTab;
    private final List<TabPageInfo> mPageTabs = new ArrayList<TabPageInfo>(2);
    private RechargeDialogPresenter mPresenter;
    private Observer<ActivityAction> mWebTabObserver;
    private boolean hasActivity;
    private boolean isSelectActivity = false;
    private View container;
    private YYTextView mTvMoneyTips;
    private String rechargeUrl;
    private ThirdWebViewTab mWebRechargeTab;
    private String mPageId = "";

    public RechargeDialog(Context context, IRechargeDialogCallback listener, String rechargeUrl, String pageId) {
        this.mContext = context;
        this.rechargeUrl = rechargeUrl;
        this.mPageId = pageId;
        this.mRechargeDialogCallback = listener;
    }

    public void init(Dialog dialog2) {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(ResolutionUtils.getScreenWidth((Context)this.mContext), ResolutionUtils.getScreenHeight((Context)this.mContext));
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View viewDialog = inflater.inflate(R.layout.layout_recharge_dialog, null);
        Window window = dialog2.getWindow();
        if (window != null) {
            window.clearFlags(131072);
            window.setSoftInputMode(4);
        }
        dialog2.setContentView(viewDialog, layoutParams);
        dialog2.setOnDismissListener(dialog1 -> {
            if (this.mRechargeDialogCallback != null) {
                this.mRechargeDialogCallback.onDismiss(this);
            }
            this.onDismiss();
        });
        this.container = dialog2.findViewById(R.id.recharge_dialog_container);
        if (Build.VERSION.SDK_INT >= 21) {
            this.container.setClipToOutline(true);
        }
        this.mTabStrip = (SlidingTabLayout)dialog2.findViewById(R.id.wallet_tab);
        this.mViewPager = (YYViewPager)dialog2.findViewById(R.id.wallet_pager);
        this.mTvMoneyTips = (YYTextView)dialog2.findViewById(R.id.tvTips);
        dialog2.findViewById(R.id.close_icon).setOnClickListener(v -> dialog2.dismiss());
        dialog2.setCancelable(true);
        dialog2.setCanceledOnTouchOutside(false);
        this.mPagerAdapter = new WalletPagerAdapter();
        this.mViewPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mTabStrip.setViewPager((ViewPager)this.mViewPager);
        if (ScreenUtils.getScreenOrientation() == 2) {
            int screenWidth = ResolutionUtils.getScreenWidth((Context)dialog2.getContext());
            int height = DpToPxDef.RESOLUTION_330_DP;
            if (screenWidth <= DpToPxDef.RESOLUTION_330_DP) {
                height = screenWidth - DpToPxDef.RESOLUTION_10_DP;
            }
            this.container.getLayoutParams().height = height;
            this.container.getLayoutParams().width = DpToPxDef.RESOLUTION_330_DP;
        }
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                RechargeDialog.this.mCurPosition = position;
            }
        });
        this.mTabStrip.setOnTabSelectListener(new OnTabSelectListener(){

            public void onTabSelect(int position) {
                MLog.debug((Object)RechargeDialog.TAG, (String)"onTabSelect position %s", (Object[])new Object[]{position});
                if (position == 1) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60129186").put("function_id", "room_charge_popup_integral_tab_click").put("red_dot_status", RechargeDialog.this.mTabStrip.isRedDotShow(position) ? "1" : "0"));
                }
            }

            public void onTabReselect(int position) {
            }
        });
        if (!this.isWebRechargePage()) {
            this.mRechargeTab = new RechargeDialogTab(this.mContext, this.mRechargeDialogCallback);
        }
        this.showBeanItemView();
        this.setMoneyTips();
    }

    private void setMoneyTips() {
        this.mTvMoneyTips.setVisibility(this.configSwitch() != false ? 0 : 8);
    }

    private Boolean configSwitch() {
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.RECHARGE_TIPS_SWITCH);
        if (config instanceof RechargeTipsConfig) {
            return ((RechargeTipsConfig)config).isContain(AccountUtil.realCountry());
        }
        return false;
    }

    private boolean isWebRechargePage() {
        return !TextUtils.isEmpty((CharSequence)this.rechargeUrl);
    }

    private void observeWebTabData() {
        if (this.mWebTabObserver == null) {
            this.mWebTabObserver = action -> {
                if (this.mWebViewTab == null && this.hasActivity) {
                    this.showBeanItemView();
                }
                if (action != null && this.mWebViewTab != null) {
                    this.mWebViewTab.setData(action.title, action.linkUrl);
                }
            };
            this.mPresenter.getActivityData().observeForever(this.mWebTabObserver);
        }
    }

    public int getId() {
        return DialogId.rechargeDialog;
    }

    public void updateBalance(List<BalanceInfo> data) {
        if (this.mRechargeTab == null || this.isWebRechargePage()) {
            return;
        }
        this.mRechargeTab.updateBalance(data);
    }

    public void updateList(List<ProductItemInfo> data) {
        if (this.mRechargeTab == null || this.isWebRechargePage()) {
            return;
        }
        this.mRechargeTab.updateList(data);
    }

    public void loadFailed() {
        if (this.mRechargeTab == null || this.isWebRechargePage()) {
            return;
        }
        this.mRechargeTab.loadFailed();
    }

    private View getRechargePage() {
        if (this.isWebRechargePage()) {
            this.mWebRechargeTab = new ThirdWebViewTab(this.mContext);
            this.mWebRechargeTab.setData("", this.rechargeUrl);
            this.mWebRechargeTab.setPageId(this.mPageId);
            return this.mWebRechargeTab;
        }
        return this.mRechargeTab;
    }

    public void showBeanItemView() {
        MLog.info((Object)TAG, (String)"showBeanItemView hasActivity %b, isSelectActivity %b", (Object[])new Object[]{this.hasActivity, this.isSelectActivity});
        this.mPageTabs.clear();
        this.mPageTabs.add(new TabPageInfo(ResourceUtils.getString((int)R.string.short_title_buy_diamond), this.getRechargePage()));
        if (this.hasActivity) {
            ActivityAction data;
            if (this.mPresenter != null && this.mPresenter.getActivityData() != null && (data = (ActivityAction)this.mPresenter.getActivityData().getValue()) != null) {
                this.mWebViewTab = new ActivityWebViewTab(this.mContext);
                this.mPageTabs.add(new TabPageInfo(data.title, (View)this.mWebViewTab));
            }
            this.observeWebTabData();
        }
        this.mPagerAdapter.setData(this.mPageTabs);
        if (this.mPageTabs.size() == 1) {
            this.mTabStrip.setIndicatorHeight(0.0f);
            this.mTabStrip.setTextSelectColor(-16777216);
            this.mTabStrip.setTextSize((float)ResolutionUtils.spToPx((float)20.0f));
        }
        this.mTabStrip.notifyDataSetChanged();
        if (this.hasActivity && this.isSelectActivity && this.mPageTabs.size() > 1) {
            this.mViewPager.setCurrentItem(1);
        } else {
            this.mViewPager.setCurrentItem(0);
        }
    }

    public void setHasActivity(boolean hasActivity, boolean isSelectActivity) {
        this.hasActivity = hasActivity;
        this.isSelectActivity = isSelectActivity;
    }

    public void setPresenter(RechargeDialogPresenter presenter) {
        this.mPresenter = presenter;
    }

    private void onDismiss() {
        if (this.mPresenter != null && this.mWebTabObserver != null) {
            this.mPresenter.getActivityData().removeObserver(this.mWebTabObserver);
        }
        RechargeScaleAnimHelper.INSTANCE.endAnim();
        if (this.mWebViewTab != null) {
            this.mWebViewTab.destroy();
        }
        if (this.mWebRechargeTab != null) {
            this.mWebRechargeTab.destroy();
        }
    }

    public void setProductId(String productId) {
        if (this.mRechargeTab != null && !this.isWebRechargePage()) {
            this.mRechargeTab.setProductId(productId);
        }
    }

    public void setCouponLayoutStatus(String couponName, boolean visibility) {
        if (this.mRechargeTab != null && !this.isWebRechargePage()) {
            this.mRechargeTab.setCouponLayoutStatus(couponName, visibility);
        }
    }

    public List<ProductItemInfo> getProductData() {
        if (this.mRechargeTab != null && !this.isWebRechargePage()) {
            return this.mRechargeTab.getProductData();
        }
        return null;
    }

    public void updataRechargeList() {
        if (this.mRechargeTab != null && !this.isWebRechargePage()) {
            this.mRechargeTab.updataRechargeList();
        }
    }

    public void updateRedPoint(boolean redDot) {
        if (this.mPageTabs.size() <= 1) {
            return;
        }
        if (redDot) {
            this.mTabStrip.showRedDot(1);
        } else {
            this.mTabStrip.hideRedDot(1);
        }
    }
}

