/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.module.recharge;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.billing.base.RechargeResult;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.home.base.IDrawerItemDataService;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.pay.bean.BalanceResponse;
import com.yy.hiyo.wallet.base.pay.bean.BeanTabConfig;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.bean.NoCouponBean;
import com.yy.hiyo.wallet.base.pay.bean.ProductItemInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.bean.UserRevenue;
import com.yy.hiyo.wallet.base.pay.bean.WalletTabConfig;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.base.pay.callback.IRecentPayCallback;
import com.yy.hiyo.wallet.base.pay.callback.IRechargeCallback;
import com.yy.hiyo.wallet.base.pay.callback.SimpleRechargeCallback;
import com.yy.hiyo.wallet.module.recharge.BaseRechargeController;
import com.yy.hiyo.wallet.module.recharge.IRechargeUiCallback;
import com.yy.hiyo.wallet.module.recharge.WalletNobleRebateModel;
import com.yy.hiyo.wallet.module.recharge.bean.RechargeTaskGuideData;
import com.yy.hiyo.wallet.module.recharge.page.RechargeWindow;
import com.yy.hiyo.wallet.module.recharge.preconnection.PayServicePreConnection;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.hiyo.wallet.pay.RevenueSdkReport;
import com.yy.hiyo.wallet.pay.stats.RechargeHiidoReport;
import com.yy.webservice.WebEnvSettings;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.ihago.money.api.appconfigcenter.ActivityBannerInfo;
import net.ihago.money.api.appconfigcenter.ELinkOpenType;
import net.ihago.money.api.noblerebate.GetGuideInfoRsp;
import net.ihago.money.api.pay.GetUserRevenueOrigin;

public class RechargeController
extends BaseRechargeController
implements IRechargeUiCallback,
INotify {
    private static final String TAG = "FTPayRechargeController";
    private RechargeWindow mWindow;
    private boolean hadCacheUrl = false;
    private String rechargeUrl;
    private WalletNobleRebateModel mNobleRebateModel;
    long mStartShowDialog = System.currentTimeMillis();
    boolean isStartInvokeGooglePay = false;
    Runnable queryHistoryRunnable = new Runnable(){

        @Override
        public void run() {
            RechargeController.this.queryRechargeHistory();
        }
    };

    public RechargeController(Environment env) {
        super(env);
        this.registerMessage(AppbaseMsgDef.UPDATE_BALANCE);
        this.registerMessage(AppbaseMsgDef.UPDATE_COUPON_DISCOUNT);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.SHOW_WINDOW_RECHARGE) {
            this.sendMessage(BaseMsgDef.MSG_ENTER_RECHARGE);
            Bundle bundle = msg.getData();
            this.handleBundle(bundle);
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            String webRechargeUrl = null;
            if (this.isOnlyNative) {
                this.mWindow = new RechargeWindow(this.mContext, this, null, 0, "", true);
            } else {
                int tab = -1;
                if (bundle != null) {
                    tab = bundle.getInt("tab", -1);
                }
                WalletTabConfig walletTabConfig = null;
                if (msg.obj instanceof WalletTabConfig) {
                    walletTabConfig = (WalletTabConfig)msg.obj;
                }
                webRechargeUrl = this.getWeRechargeUrl();
                this.mWindow = new RechargeWindow(this.mContext, this, walletTabConfig, tab, webRechargeUrl, false);
                this.requestBeanSum();
            }
            if (TextUtils.isEmpty((CharSequence)webRechargeUrl)) {
                this.requestWalletBroadcast();
                this.requestRechargeGuide();
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            this.requestRechargeList();
            this.requestBalance(false);
            this.checkAbnormal();
            YYTaskExecutor.postToMainThread(() -> PayServicePreConnection.preConnectionPayService((Activity)this.getEnvironment().getActivity()), (long)800L);
        } else if (msg.what == AppbaseMsgDef.CLOSE_WINDOW_RECHARGE) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            }
        } else if (msg.what == AppbaseMsgDef.UPDATE_BALANCE) {
            this.requestBalance(false);
        } else if (msg.what == AppbaseMsgDef.UPDATE_COUPON_DISCOUNT) {
            CouponBean bean;
            if (msg.obj instanceof NoCouponBean) {
                if (this.mWindow != null && this.mCurrCouponBean != null) {
                    this.mCurrCouponBean = null;
                    this.mWindow.setCouponLayoutStatus(ResourceUtils.getString((int)R.string.short_tips_coupoin), true);
                    if (this.mWindow.getProductData() != null) {
                        for (ProductItemInfo productDatum : this.mWindow.getProductData()) {
                            productDatum.couponDiscountBean = null;
                            productDatum.couponBean = null;
                        }
                        this.updataRechargeListForCoupon();
                    }
                }
            } else if (msg.obj instanceof CouponBean && !(bean = (CouponBean)msg.obj).equals(this.mCurrCouponBean) && this.mWindow != null) {
                this.mCurrCouponBean = bean;
                this.mWindow.setCouponLayoutStatus(bean.couponName + "", true);
                this.requestCouponDiscount(this.mWindow.getProductData());
            }
        }
    }

    public void requestRechargeGuide() {
        if (this.mNobleRebateModel == null) {
            this.mNobleRebateModel = new WalletNobleRebateModel();
        }
        this.mNobleRebateModel.getTaskGuideInfo((DataCallback<RechargeTaskGuideData>)((DataCallback)data -> {
            if (this.mWindow == null) {
                return;
            }
            this.mWindow.setRechargeGuide((RechargeTaskGuideData)data);
        }));
    }

    @Override
    public void requestWalletBroadcast() {
        if (this.mNobleRebateModel == null) {
            this.mNobleRebateModel = new WalletNobleRebateModel();
        }
        this.mNobleRebateModel.getGuideInfo((DataCallback<GetGuideInfoRsp>)((DataCallback)data -> {
            if (this.mWindow == null) {
                return;
            }
            this.mWindow.setBroadcast((GetGuideInfoRsp)data);
        }));
    }

    @Override
    public String getPageId() {
        return this.mPageId;
    }

    private String getWeRechargeUrl() {
        MLog.info((Object)TAG, (String)("isOnlyNative = " + this.isOnlyNative), (Object[])new Object[0]);
        if (this.isOnlyNative) {
            return "";
        }
        String replaceUrl = this.getActivityBannerRechargeUrl();
        MLog.info((Object)TAG, (String)"getWeRechargeUrl ActivityBannerRechargeUrl replaceUrl %s", (Object[])new Object[]{replaceUrl});
        if (!FP.empty((CharSequence)replaceUrl)) {
            return this.appendSource(replaceUrl);
        }
        if (this.hadCacheUrl) {
            MLog.info((Object)TAG, (String)("hadCacheUrl  rechargeUrl = " + this.rechargeUrl), (Object[])new Object[0]);
            return this.rechargeUrl;
        }
        this.hadCacheUrl = true;
        this.rechargeUrl = SettingFlags.getStringValue((String)("key_recharge_url" + AccountUtil.getUid()), (String)"");
        MLog.info((Object)TAG, (String)("rechargeUrl = " + this.rechargeUrl), (Object[])new Object[0]);
        if (!TextUtils.isEmpty((CharSequence)this.rechargeUrl)) {
            this.rechargeUrl = this.appendSource(this.rechargeUrl);
        }
        return this.rechargeUrl;
    }

    @Nullable
    private String getActivityBannerRechargeUrl() {
        ActivityBannerInfo info;
        IDrawerItemDataService service = (IDrawerItemDataService)this.getServiceManager().getService(IDrawerItemDataService.class);
        ActivityBannerInfo activityBannerInfo = info = service.getMineWalletData().getData() != null ? service.getMineWalletData().getData().info : null;
        if (info == null) {
            return "";
        }
        String openType = (String)info.act_extra_infos.get("link_open_type");
        MLog.info((Object)TAG, (String)"setWalletBannerInfo openType %s", (Object[])new Object[]{openType});
        if (StringUtils.equal((String)openType, (String)("" + ELinkOpenType.ELinkOpenTypeReplaceRechargeURL.getValue()))) {
            return info.link_url;
        }
        return "";
    }

    private String appendSource(String url) {
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("source", "1");
        param.put("from", "" + this.fromType);
        param.put("pid", this.mPageId);
        param.put("packagename", AppKeysDef.getAppPackageName());
        if (!StringUtils.isEmpty((String)this.mActId)) {
            param.put("actId", this.mActId);
        }
        return URLUtils.addParams((String)url, param);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (NotificationDef.N_FOREGROUND_CHANGE == notification.id && this.isStartInvokeGooglePay) {
            this.isStartInvokeGooglePay = false;
            long useTime = System.currentTimeMillis() - this.mStartShowDialog;
            MLog.info((Object)TAG, (String)("Google Pay Dialog time = " + useTime), (Object[])new Object[0]);
            RechargeHiidoReport.invokeGooglePayDialogShow(this.mGid, this.fromType, useTime);
        }
    }

    @Override
    public void onBack() {
        this.handleBackClick(1);
    }

    protected boolean onWindowBackKeyEvent() {
        this.handleBackClick(2);
        return true;
    }

    private void handleBackClick(int type) {
        boolean handle = false;
        if (this.mWindow != null) {
            handle = this.mWindow.goBack(type);
        }
        if (!handle) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            } else {
                this.mWindowMgr.popWindow(true);
            }
        }
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        RechargeHiidoReport.pageShow(this.mGid, this.fromType, 0, StringUtils.isEmpty((String)this.getWeRechargeUrl()));
        RevenueSdkReport.INSTANCE.onPageShow(this.fromType, this.mPageId, !StringUtils.isEmpty((String)this.getWeRechargeUrl()));
        YYTaskExecutor.postToMainThread((Runnable)this.queryHistoryRunnable, (long)2000L);
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            RechargeHiidoReport.pageClose(this.mGid, this.fromType);
            this.mWindow = null;
        }
        this.onDestroy();
        this.removeQueryRunnable();
        this.fromType = 0;
        this.mGid = "";
        this.mRoomId = "";
        this.hadCacheUrl = false;
        this.rechargeUrl = "";
        this.mCurrCouponBean = null;
    }

    @Override
    protected void onRechargeSuccess(RechargeInfo info) {
        super.onRechargeSuccess(info);
        this.requestBalance(this.mRechargeSuccessOrderId != null && info != null && this.mRechargeSuccessOrderId.equals(info.getOrderId()));
        this.requestRechargeList();
    }

    @Override
    protected void updataRechargeListForCoupon() {
        if (this.mWindow != null && TextUtils.isEmpty((CharSequence)this.getWeRechargeUrl())) {
            this.mWindow.updataRechargeList();
        }
    }

    @Override
    protected void onRequestCouponDiscountFailed() {
        this.requestRechargeList();
    }

    private void requestBalance(final boolean hideLoading) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) || !TextUtils.isEmpty((CharSequence)this.getWeRechargeUrl())) {
            return;
        }
        ((IPayService)this.getServiceManager().getService(IPayService.class)).queryBalance(this.fromType, (IPayCallback)new IPayCallback<BalanceResponse>(){

            public void onSucceed(@Nullable BalanceResponse response) {
                if (response != null) {
                    if (RechargeController.this.mWindow != null) {
                        RechargeController.this.mWindow.updateBalance(response.accountList);
                    }
                    if (!FP.empty((Collection)response.accountPeriodList) && RechargeController.this.mWindow != null) {
                        RechargeController.this.mWindow.updatePeriodBalance(response.accountPeriodList);
                    }
                }
                if (hideLoading) {
                    RechargeController.this.endBalanceTimeoutTask();
                    RechargeController.this.hideLoading();
                }
            }

            public void onFailed(int code, String msg) {
                MLog.info((Object)RechargeController.TAG, (String)"request balance fail", (Object[])new Object[0]);
                if (hideLoading) {
                    RechargeController.this.endBalanceTimeoutTask();
                    RechargeController.this.hideLoading();
                }
            }
        });
    }

    private void queryRechargeHistory() {
        if (!TextUtils.isEmpty((CharSequence)this.getWeRechargeUrl())) {
            return;
        }
        ((IPayService)ServiceManagerProxy.getService(IPayService.class)).getRecentPay(new IRecentPayCallback(){

            public void onFinished(@Nullable String productId) {
                if (RechargeController.this.mWindow != null) {
                    if (!StringUtils.isEmpty((String)productId)) {
                        RechargeController.this.mWindow.setProductId(productId);
                    } else {
                        RechargeController.this.mWindow.setProductId("default");
                    }
                }
            }
        });
    }

    private void requestRechargeList() {
        if (!TextUtils.isEmpty((CharSequence)this.getWeRechargeUrl())) {
            return;
        }
        final long startTime = System.currentTimeMillis();
        List list = ((IPayService)this.getServiceManager().getService(IPayService.class)).fetchRechargeList();
        if (!FP.empty((Collection)list) && this.mWindow != null) {
            for (ProductItemInfo productItemInfo : list) {
                productItemInfo.couponDiscountBean = null;
                productItemInfo.couponBean = null;
            }
            this.mWindow.updateList(this.sortRechargeList(list));
            RechargeHiidoReport.rechargeListDataReady(this.mGid, this.fromType, System.currentTimeMillis() - startTime, true, true);
            RevenueSdkReport.INSTANCE.onProductShow(this.mPageId, StringUtils.isEmpty((String)this.getWeRechargeUrl()), startTime);
            this.requestCouponList(false, 0);
        }
        ((IPayService)this.getServiceManager().getService(IPayService.class)).fetchRechargeList(this.fromType, this.mPageId, null, (IPayCallback)new IPayCallback<List<ProductItemInfo>>(){

            public void onSucceed(@Nullable List<ProductItemInfo> data) {
                MLog.info((Object)RechargeController.TAG, (String)"requestRechargeList size: %d", (Object[])new Object[]{FP.size(data)});
                if (!FP.empty(data)) {
                    if (RechargeController.this.mWindow != null) {
                        RechargeController.this.mWindow.updateList(RechargeController.this.sortRechargeList(data));
                        RechargeHiidoReport.rechargeListDataReady(RechargeController.this.mGid, RechargeController.this.fromType, System.currentTimeMillis() - startTime, false, true);
                        RevenueSdkReport.INSTANCE.onProductShow(RechargeController.this.mPageId, StringUtils.isEmpty((String)RechargeController.this.getWeRechargeUrl()), startTime);
                        RechargeController.this.requestCouponList(false, 0);
                    }
                } else {
                    if (RechargeController.this.mWindow != null) {
                        RechargeController.this.mWindow.loadFailed();
                    }
                    ToastUtils.showToast((Context)RechargeController.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_refresh_again), (int)0);
                    RechargeHiidoReport.rechargeListDataReady(RechargeController.this.mGid, RechargeController.this.fromType, System.currentTimeMillis() - startTime, false, false);
                }
            }

            public void onFailed(int code, String msg) {
                MLog.info((Object)RechargeController.TAG, (String)"request recharge list fail, code: %s, msg: %s", (Object[])new Object[]{code, msg});
                if (RechargeController.this.mWindow != null) {
                    RechargeController.this.mWindow.loadFailed();
                }
                ToastUtils.showToast((Context)RechargeController.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_refresh_again), (int)0);
                RechargeHiidoReport.rechargeListDataReady(RechargeController.this.mGid, RechargeController.this.fromType, System.currentTimeMillis() - startTime, false, false);
            }
        });
    }

    private void requestCouponList(final boolean isUsed, final int tryCount) {
        if (!TextUtils.isEmpty((CharSequence)this.getWeRechargeUrl())) {
            return;
        }
        ((IPayService)this.getServiceManager().getService(IPayService.class)).queryCouponListAsync(isUsed, (IPayCallback)new IPayCallback<List<CouponBean>>(){

            public void onSucceed(@Nullable List<CouponBean> data) {
                if (FP.empty(data) && !isUsed) {
                    RechargeController.this.requestCouponList(true, 0);
                }
                if (RechargeController.this.mWindow != null) {
                    String couponName = ResourceUtils.getString((int)R.string.title_coupon);
                    if (!FP.empty(data) && !isUsed) {
                        RechargeController.this.mCurrCouponBean = null;
                        couponName = data.get((int)0).couponName;
                        RechargeController.this.mCurrCouponBean = data.get(0);
                        RechargeController.this.requestCouponDiscount(RechargeController.this.mWindow.getProductData());
                    }
                    RechargeController.this.mWindow.setCouponLayoutStatus(couponName, !FP.empty(data));
                }
            }

            public void onFailed(int code, String msg) {
                if (tryCount < 3) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RechargeController.this.requestCouponList(true, tryCount + 1);
                        }
                    }, (long)(1000 * tryCount));
                }
            }
        });
    }

    @Override
    public void onRechargeRecordClick() {
        if (RepeatClickUtils.canRepeatClick((String)"onRechargeRecordClick", (long)1000L)) {
            RechargeHiidoReport.billClick(this.mGid, this.fromType);
            this.loadRechargeRecord();
        }
    }

    @Override
    public void onRefresh() {
        this.requestRechargeList();
        this.requestBalance(false);
    }

    @Override
    public void onItemClick(final ProductItemInfo productItemInfo, int position) {
        if (productItemInfo == null) {
            MLog.error((Object)TAG, (String)"onItemClick item info is null", (Object[])new Object[0]);
            return;
        }
        if (productItemInfo.couponBean != null && !productItemInfo.couponBean.isCouponVaild(this.mContext, true)) {
            this.requestRechargeList();
            return;
        }
        if (this.checkItemClick()) {
            RechargeHiidoReport.rechargeClick(this.mGid, this.fromType, this.mRoomId, productItemInfo, 0);
            RevenueSdkReport.INSTANCE.clickProduct(this.mPageId, productItemInfo.productId, position, StringUtils.isEmpty((String)this.getWeRechargeUrl()));
            this.showLoading();
            this.mStartShowDialog = System.currentTimeMillis();
            this.isStartInvokeGooglePay = true;
            this.mRechargeHandler = ((IPayService)this.getServiceManager().getService(IPayService.class)).recharge(PayUtils.getPayPlatform(), (Activity)this.getActivity(), this.getRechargeParam(productItemInfo), (IRechargeCallback)new SimpleRechargeCallback(){

                public void onSucceed(@Nullable RechargeInfo data) {
                    RechargeController.this.isStartInvokeGooglePay = false;
                    MLog.info((Object)RechargeController.TAG, (String)"recharge onSucceed data:  %s", (Object[])new Object[]{data});
                    RechargeController.this.handleOnSucceed(productItemInfo, data, 0);
                    RechargeController.this.startBalanceTimeoutTask();
                    RechargeController.this.onFinish();
                }

                public void onRechargeSuccess(RechargeResult result) {
                    super.onRechargeSuccess(result);
                    RechargeController.this.isStartInvokeGooglePay = false;
                    if (result != null) {
                        RechargeController.this.mRechargeSuccessOrderId = PayUtils.getOrderFromPayload(result.payload);
                    }
                    RechargeController.this.hideLoading();
                }

                public int rechargeSource() {
                    return StringUtils.isEmpty((String)RechargeController.this.getWeRechargeUrl()) ? 1 : 2;
                }

                public void onFailed(int code, String msg) {
                    super.onFailed(code, msg);
                    RechargeController.this.isStartInvokeGooglePay = false;
                    MLog.error((Object)RechargeController.TAG, (String)"recharge onFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
                    RechargeController.this.handleOnFailed(productItemInfo, code, msg, 0);
                    RechargeController.this.onFinish();
                    RechargeController.this.requestRechargeList();
                }
            });
        }
        this.removeQueryRunnable();
    }

    private void removeQueryRunnable() {
        YYTaskExecutor.removeTask((Runnable)this.queryHistoryRunnable);
    }

    @Override
    public void onItemBindView(ProductItemInfo productItemInfo) {
        RechargeHiidoReport.goodsShow(this.mGid, this.fromType, productItemInfo);
    }

    @Override
    public void onRechargeHelpClick() {
        if (RepeatClickUtils.canRepeatClick((String)"getRechargeHelpUrl", (long)1000L)) {
            RechargeHiidoReport.problemClick(this.mGid, this.fromType);
            WebEnvSettings wes = new WebEnvSettings();
            wes.url = UriProvider.getHelpCenterUrl();
            wes.disablePullRefresh = true;
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(wes);
        }
        this.removeQueryRunnable();
    }

    @Override
    public void onCouponClick() {
        this.sendMessage(AppbaseMsgDef.SHOW_WINDOW_COUPON_LIST, 1, 1, this.mCurrCouponBean == null ? 0L : this.mCurrCouponBean.id);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028699").put("function_id", "coupon_enter_click"));
    }

    @Override
    public void onTermsOfServiceClick() {
        if (RepeatClickUtils.canRepeatClick((String)"onTermsOfServiceClick", (long)1000L)) {
            RechargeHiidoReport.privacyClick(this.mGid, this.fromType);
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl("https://www.ihago.net/a/license/nt-user-policy-android.html", "");
        }
        this.removeQueryRunnable();
    }

    @Override
    public void onPrivacyPolicyClick() {
        if (RepeatClickUtils.canRepeatClick((String)"onPrivacyClick", (long)1000L)) {
            RechargeHiidoReport.privacyClick(this.mGid, this.fromType);
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl("https://www.ihago.net/a/license/nt-register-policy-android.html", "");
        }
        this.removeQueryRunnable();
    }

    @Override
    public void onNetErrorShow() {
        RechargeHiidoReport.goodsListNetError(this.mGid, this.fromType);
    }

    @Override
    public void onEmptyShow() {
        RechargeHiidoReport.goodsListEmpty(this.mGid, this.fromType);
    }

    @Override
    public BeanTabConfig getBeanTabConfig() {
        String data = SettingFlags.getStringValue((String)this.getBeanSaveKey(), (String)"");
        boolean showBeanTab = false;
        boolean showReadPoint = false;
        if (StringUtils.isEmpty((String)data)) {
            return new BeanTabConfig(showBeanTab, showReadPoint);
        }
        String[] configs = data.split(",");
        if (configs != null && configs.length == 2) {
            String beanSizeStr = configs[0];
            showBeanTab = StringUtils.safeParseLong((String)beanSizeStr) != 0L;
            String showRead = configs[1];
            showReadPoint = StringUtils.safeParseInt((String)showRead) == 1;
        }
        return new BeanTabConfig(showBeanTab, showReadPoint);
    }

    @Override
    public void updateBeanTabConfig(BeanTabConfig config) {
        if (config != null) {
            this.updateBeanTabConfig(config.showBeanTab, config.showBeanTabReadPoint);
        }
    }

    @Override
    public void onWebRulePageShow() {
        WebEnvSettings wes = new WebEnvSettings();
        wes.url = UriProvider.getDiamondRuleUrl();
        ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(wes);
    }

    @Override
    protected int getLoginDialogType() {
        return 4;
    }

    @Override
    protected int getLoginDialogFrom() {
        return 7;
    }

    private void loadRechargeRecord() {
        WebEnvSettings wes = new WebEnvSettings();
        wes.url = UriProvider.getRechargeRecordUrl();
        wes.disablePullRefresh = true;
        ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(wes);
    }

    private void requestBeanSum() {
        BeanTabConfig config = this.getBeanTabConfig();
        if (config == null || !config.showBeanTab) {
            ((IPayService)this.getServiceManager().getService(IPayService.class)).queryUserRevenue(AccountUtil.getUid(), 0L, GetUserRevenueOrigin.KOriginWallet, (IPayCallback)new IPayCallback<UserRevenue>(){

                public void onSucceed(@Nullable UserRevenue data) {
                    MLog.info((Object)RechargeController.TAG, (String)"queryUserRevenue on success:%s", (Object[])new Object[]{data});
                    if (data != null && data.isSuccess()) {
                        BeanTabConfig beanTabConfig = RechargeController.this.updateBeanTabConfig(data.amount > 0L, true);
                        if (RechargeController.this.mWindow != null) {
                            RechargeController.this.mWindow.updateBeanTagConfig(beanTabConfig);
                        }
                    }
                }

                public void onFailed(int code, String msg) {
                    MLog.error((Object)RechargeController.TAG, (String)"queryUserRevenue onFailed,code:%d,msg:%s", (Object[])new Object[]{code, msg});
                }
            });
        }
        MLog.info((Object)TAG, (String)"do not need to request bean size", (Object[])new Object[0]);
    }

    private BeanTabConfig updateBeanTabConfig(boolean showBeanTab, boolean showReadPoint) {
        String config = (showBeanTab ? "1" : "0") + "," + (showReadPoint ? "1" : "0");
        SettingFlags.setStringValue((String)this.getBeanSaveKey(), (String)config);
        return new BeanTabConfig(showBeanTab, showReadPoint);
    }

    private String getBeanSaveKey() {
        return AccountUtil.getUid() + "key_user_show_wallet_bean_tab";
    }
}

