/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.js;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.pay.bean.RechargeInfo;
import com.yy.hiyo.wallet.base.pay.bean.RechargeParam;
import com.yy.hiyo.wallet.base.pay.callback.IRechargeCallback;
import com.yy.hiyo.wallet.base.pay.callback.SimpleRechargeCallback;
import com.yy.hiyo.wallet.base.revenue.pay.IRechargeHandler;
import com.yy.hiyo.wallet.pay.PayUtils;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class RechargeJsEvent
implements JsEvent {
    private static final String TAG = "RechargeJsEvent";
    private DialogLinkManager mDialogLinkManager;
    private IRechargeHandler mRechargeHandler;
    private WebBusinessHandlerCallback mHandlerCallback = new WebBusinessHandlerCallback(){

        public void onWebViewDestroy() {
            super.onWebViewDestroy();
            if (RechargeJsEvent.this.mRechargeHandler != null) {
                RechargeJsEvent.this.mRechargeHandler.cancelRecharge();
                RechargeJsEvent.this.mRechargeHandler = null;
            }
            RechargeJsEvent.this.hideLoading();
        }
    };

    @NonNull
    public JsMethod method() {
        return JsEventDefine.REVENUE.recharge;
    }

    public void jsCall(final @NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback2 != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is empty");
                callback2.callJs((IJsParam)err);
            }
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
            if (callback2 != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"network unavailable");
                callback2.callJs((IJsParam)err);
            }
            return;
        }
        webHandler.addWebViewListener(this.mHandlerCallback);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                RechargeJsEvent.this.rechargeAsync(webHandler, param, callback2);
            }
        });
    }

    private void rechargeAsync(@NonNull IWebBusinessHandler webHandler, String json, final @Nullable IJsEventCallback callback2) {
        RechargeParam param = null;
        try {
            param = (RechargeParam)JsonParser.parseJsonObject((String)json, RechargeParam.class);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)json, (Throwable)e, (Object[])new Object[0]);
        }
        if (param == null || TextUtils.isEmpty((CharSequence)param.getProductId())) {
            MLog.error((Object)TAG, (String)"rechargeAsync json: %s", (Object[])new Object[]{json});
            if (callback2 != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                callback2.callJs((IJsParam)err);
            }
            return;
        }
        String expand = param.getH5Expand();
        if (!TextUtils.isEmpty((CharSequence)expand)) {
            try {
                JSONObject obj = JsonParser.obtainJSONObject((String)expand);
                Iterator it = obj.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    param.addExpand(key, obj.opt(key));
                }
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (String)"rechargeAsync expand json: %s", (Object[])new Object[]{expand});
            }
        }
        param.setFrom(100);
        param.setNeedRechargeSuccessBro(true);
        Context context = webHandler.getContext();
        if (!(context instanceof Activity)) {
            if (callback2 != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"error with null activity");
                callback2.callJs((IJsParam)err);
            }
            if (SystemUtils.isShowEnvSetting()) {
                throw new IllegalArgumentException("activity is null " + context);
            }
            return;
        }
        final Activity activity = (Activity)webHandler.getContext();
        final RechargeParam finalParam = param;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                RechargeJsEvent.this.recharge(finalParam, activity, callback2);
            }
        });
    }

    private void recharge(RechargeParam param, Activity activity, final @Nullable IJsEventCallback callback2) {
        this.showLoading(activity);
        MLog.info((Object)TAG, (String)"recharge msg intercept: %b", (Object[])new Object[]{param.msgIntercept()});
        IPayService payService = (IPayService)ServiceManagerProxy.getServiceManager().getService(IPayService.class);
        this.mRechargeHandler = payService.recharge(PayUtils.getPayPlatform(), activity, param, (IRechargeCallback)new SimpleRechargeCallback(){

            public int rechargeSource() {
                return 3;
            }

            public void onSucceed(@Nullable RechargeInfo data) {
                MLog.info((Object)RechargeJsEvent.TAG, (String)"rechargeAsync onSucceed data: %s", (Object[])new Object[]{data});
                RechargeJsEvent.this.hideLoading();
                if (callback2 == null) {
                    return;
                }
                if (data == null) {
                    BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"recharge success but data is null");
                    callback2.callJs((IJsParam)err);
                    return;
                }
                BaseJsParam.DataBuilder dataBuilder = BaseJsParam.builder().put("currencyType", (Object)data.getCurrencyType()).put("unitPrice", (Object)data.getAmount()).put("currencyAmount", (Object)data.getCurrencyAmount()).put("bonusCurrencyAmount", (Object)data.getBonusCurrencyAmount()).put("orderId", (Object)data.getOrderId());
                BaseJsParam jsParam = BaseJsParam.codeParam((int)1, (String)dataBuilder.jsonData());
                callback2.callJs((IJsParam)jsParam);
            }

            public void onFailed(int code, String msg) {
                BaseJsParam err;
                super.onFailed(code, msg);
                MLog.error((Object)RechargeJsEvent.TAG, (String)"rechargeAsync onFailed code: %d, msg: %s", (Object[])new Object[]{code, msg});
                RechargeJsEvent.this.hideLoading();
                if (callback2 == null) {
                    return;
                }
                if (code == 20001 || code == 20101 || code == 10006) {
                    err = BaseJsParam.errorParam((int)2, (String)("cancel by user. code: " + code + "; errorMsg: " + msg));
                } else if (code == 40982) {
                    int originalCode = -18;
                    err = BaseJsParam.errorParam((int)originalCode, (String)msg);
                } else {
                    err = BaseJsParam.errorParam((int)0, (String)("code: " + code + "; errorMsg: " + msg));
                }
                callback2.callJs((IJsParam)err);
            }
        });
    }

    private void hideLoading() {
        if (this.mDialogLinkManager != null) {
            this.mDialogLinkManager.dismissDialog();
            this.mDialogLinkManager = null;
        }
    }

    private void showLoading(Activity activity) {
        this.mDialogLinkManager = new DialogLinkManager((Context)activity);
        ProgressDialog dialog2 = new ProgressDialog();
        dialog2.setCheckDeadLoop(false);
        this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
    }
}

