/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gold.goldpresent;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.GameGoldChangeBean;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.gold.IGameGoldBehavior;
import com.yy.hiyo.wallet.gold.goldpresent.GoldPresentDialog;
import com.yy.hiyo.wallet.gold.goldpresent.GoldPresentationModel;
import com.yy.hiyo.wallet.gold.goldpresent.GoldPresentationMvp;
import com.yy.hiyo.wallet.gold.statis.GoldPresentHiidoReport;
import java.util.Random;

public class GoldPresentationPresenter
implements GoldPresentationMvp.IPresenter {
    private static final String TAG = "GameGoldPresentationPresenter";
    private GoldPresentDialog mGoldPresentDialog;
    private GoldPresentationModel mGoldPresentationModel;
    private Random mRandom;
    private IGameGoldBehavior mBehavior;

    public GoldPresentationPresenter(IGameGoldBehavior behavior) {
        this.mBehavior = behavior;
    }

    @Override
    public void clickGet(int type, long id2) {
        if (this.mGoldPresentationModel == null) {
            this.mGoldPresentationModel = new GoldPresentationModel();
        }
        if (type == 2) {
            String gid = this.mBehavior.getGameId();
            if (!FP.empty((CharSequence)gid)) {
                this.mGoldPresentationModel.getJoinCoin(new GoldPresentationModel.IGetJoinCoinCallback(){

                    @Override
                    public void onSuccess(long currentGameCoin, long addCoin, long id2) {
                        GoldPresentationPresenter.this.handleGoldChange(currentGameCoin);
                    }

                    @Override
                    public void onFail() {
                        GoldPresentationPresenter.this.mGoldPresentDialog.dismiss();
                    }
                }, id2, gid);
            }
            GoldPresentHiidoReport.joinCoinDialogGetClick(this.mGoldPresentDialog.getCoinChangeCount(), this.mBehavior.getRoomId());
        } else if (type == 1) {
            this.mGoldPresentationModel.getGiveCoin(new GoldPresentationModel.IGetGiveCoinCallback(){

                @Override
                public void onSuccess(long currentGameCoin, long addCoin) {
                    GoldPresentationPresenter.this.handleGoldChange(currentGameCoin);
                }

                @Override
                public void onFail() {
                    GoldPresentationPresenter.this.mGoldPresentDialog.dismiss();
                }
            }, id2);
            GoldPresentHiidoReport.giveCoinDialogGetClick(this.mGoldPresentDialog.getCoinChangeCount(), this.mBehavior.getRoomId());
        }
    }

    public void showDialog(long addCoin, int type, long id2) {
        if (this.mGoldPresentDialog == null) {
            this.mGoldPresentDialog = new GoldPresentDialog(this.mBehavior.getContext(), type, this);
        }
        this.mGoldPresentDialog.setGoldCount(addCoin);
        this.mGoldPresentDialog.setType(type);
        this.mGoldPresentDialog.setId(id2);
        this.mGoldPresentDialog.setCanceledOnTouchOutside(false);
        this.mGoldPresentDialog.show();
        if (type == 2) {
            GoldPresentHiidoReport.joinCoinDialogExposure(addCoin, this.mBehavior.getRoomId());
        } else if (type == 1) {
            GoldPresentHiidoReport.giveCoinDialogExposure(addCoin, this.mBehavior.getRoomId());
        }
    }

    private void handleGoldChange(long totalCoin) {
        long addCoin = this.mGoldPresentDialog.getCoinChangeCount();
        if (addCoin <= 0L) {
            this.mGoldPresentDialog.dismiss();
            return;
        }
        this.notifyGameGoldChange(addCoin, totalCoin);
        if (this.mGoldPresentDialog.isShowing()) {
            final CocoViewBean cocoViewBean = this.mBehavior.getGameViewLocation();
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GoldPresentationPresenter.this.startAnimation(cocoViewBean);
                    GoldPresentationPresenter.this.mGoldPresentDialog.dismiss();
                }
            });
        }
    }

    private void notifyGameGoldChange(long coinChangeCount, long coinTotalCount) {
        GameGoldChangeBean bean = new GameGoldChangeBean();
        bean.setCoinChange(coinChangeCount);
        bean.setCoinCount(coinTotalCount);
        this.mBehavior.notifyGoldChange(bean);
    }

    public void queryJoinCoin() {
        if (this.mGoldPresentationModel == null) {
            this.mGoldPresentationModel = new GoldPresentationModel();
        }
        if (this.mRandom == null) {
            this.mRandom = new Random();
        }
        int delay = this.mRandom.nextInt(10);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String gid = GoldPresentationPresenter.this.mBehavior.getGameId();
                if (!FP.empty((CharSequence)gid)) {
                    GoldPresentationPresenter.this.mGoldPresentationModel.getJoinCoin(new GoldPresentationModel.IGetJoinCoinCallback(){

                        @Override
                        public void onSuccess(long currentGameCoin, long addCoin, long id2) {
                            if (id2 != 0L && addCoin > 0L && GoldPresentationPresenter.this.mBehavior.needShowGoldDialog()) {
                                GoldPresentationPresenter.this.showDialog(addCoin, 2, id2);
                            }
                        }

                        @Override
                        public void onFail() {
                            FeatureLog.i((String)GoldPresentationPresenter.TAG, (String)"queryJoinCoin failed", (Object[])new Object[0]);
                        }
                    }, 0L, gid);
                }
            }
        }, (long)(delay * 1000));
    }

    public void startAnimation(CocoViewBean viewBean) {
        if (viewBean == null) {
            return;
        }
        YYImageView coin = new YYImageView(this.mBehavior.getContext());
        coin.setImageResource(R.drawable.ico_gold_box);
        this.mBehavior.getGameViewLayer().addView((View)coin);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)coin.getLayoutParams();
        params.height = 100;
        params.width = 100;
        coin.setLayoutParams((ViewGroup.LayoutParams)params);
        int[] parentLoc = new int[2];
        this.mBehavior.getGameViewLayer().getLocationOnScreen(parentLoc);
        int[] startLoc = this.mGoldPresentDialog.getCoinBoxPosOnScreen();
        int[] endLoc = viewBean.getLocation();
        float startX = startLoc[0] - parentLoc[0] + 50;
        float startY = startLoc[1] - parentLoc[1] + 50;
        float toX = endLoc[0] - parentLoc[0] + 20;
        float toY = endLoc[1] - parentLoc[1];
        Path path = new Path();
        path.moveTo(startX, startY);
        path.quadTo((startX + toX) / 2.0f, startY, toX, toY);
        final PathMeasure pathMeasure = new PathMeasure(path, false);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, pathMeasure.getLength()});
        valueAnimator.setDuration(500L);
        valueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        final float[] currentPosition = new float[2];
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((ImageView)coin){
            final /* synthetic */ ImageView val$coin;
            {
                this.val$coin = imageView;
            }

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                pathMeasure.getPosTan(value, currentPosition, null);
                this.val$coin.setTranslationX(currentPosition[0]);
                this.val$coin.setTranslationY(currentPosition[1]);
            }
        });
        valueAnimator.start();
        valueAnimator.addListener(new Animator.AnimatorListener((ImageView)coin){
            final /* synthetic */ ImageView val$coin;
            {
                this.val$coin = imageView;
            }

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (this.val$coin.getParent() != null) {
                    ((ViewGroup)this.val$coin.getParent()).removeView((View)this.val$coin);
                } else {
                    this.val$coin.setVisibility(8);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public void hideDialog() {
        if (this.mGoldPresentDialog != null && this.mGoldPresentDialog.isShowing()) {
            this.mGoldPresentDialog.dismiss();
        }
    }

    public void destroy() {
        this.hideDialog();
    }
}

