/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gold.goldpresent;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.base.memoryrecycle.views.YYButton;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.gold.goldpresent.GoldPresentationMvp;
import com.yy.hiyo.wallet.gold.goldpresent.GoldPresentationPresenter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class GoldPresentDialog
extends YYDialog
implements GoldPresentationMvp.IView {
    private Context mContext;
    private YYTextView tvTitle;
    private YYTextView tvDescription;
    private YYTextView tvGoldCount;
    private YYImageView ivClose;
    private YYImageView ivCoin;
    private long goldCount;
    public static final int TYPE_GIVE_COIN = 1;
    public static final int TYPE_JOIN_COIN = 2;
    private int presentType;
    private GoldPresentationPresenter mPresenter;
    private long id = 0L;
    private ConstraintLayout rootView;

    public GoldPresentDialog(@NonNull Context context, int type, GoldPresentationMvp.IPresenter presenter) {
        super(context, R.style.normal_yydialog);
        this.mContext = context;
        this.presentType = type;
        this.setPresenter(presenter);
        this.init();
    }

    private void init() {
        this.createView();
        this.initPresentMode();
    }

    private void initPresentMode() {
        if (this.presentType == 1) {
            this.tvTitle.setText(R.string.title_give_coin_dialog);
            this.tvDescription.setText(R.string.summary_give_coin_dialog);
        } else {
            this.tvTitle.setText(R.string.title_join_coin_dialog);
            this.tvDescription.setText(R.string.summary_join_coin_dialog);
        }
    }

    private void createView() {
        this.rootView = (ConstraintLayout)View.inflate((Context)this.mContext, (int)R.layout.dialog_gold_presentation_channel, null);
        ViewGroup.LayoutParams contentLp = new ViewGroup.LayoutParams(-2, -2);
        this.setContentView((View)this.rootView, contentLp);
        this.tvTitle = (YYTextView)this.rootView.findViewById(R.id.tv_title);
        this.tvDescription = (YYTextView)this.rootView.findViewById(R.id.tv_description);
        this.tvGoldCount = (YYTextView)this.rootView.findViewById(R.id.tv_gold_count);
        this.ivClose = (YYImageView)this.rootView.findViewById(R.id.iv_close);
        this.ivCoin = (YYImageView)this.rootView.findViewById(R.id.iv_star_box);
        YYButton btnGet = (YYButton)this.rootView.findViewById(R.id.btn_get);
        btnGet.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                GoldPresentDialog.this.mPresenter.clickGet(GoldPresentDialog.this.presentType, GoldPresentDialog.this.id);
            }
        });
        this.ivClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GoldPresentDialog.this.mPresenter.clickGet(GoldPresentDialog.this.presentType, GoldPresentDialog.this.id);
            }
        });
    }

    @Override
    public void setGoldCount(long count) {
        this.goldCount = count;
        this.tvGoldCount.setText((CharSequence)("+" + count));
    }

    public int[] getCoinBoxPosOnScreen() {
        int[] pos = new int[2];
        this.ivCoin.getLocationOnScreen(pos);
        return pos;
    }

    @Override
    public void setType(int type) {
        this.presentType = type;
        this.initPresentMode();
    }

    public void setPresenter(GoldPresentationMvp.IPresenter presenter) {
        if (presenter instanceof GoldPresentationPresenter) {
            this.mPresenter = (GoldPresentationPresenter)presenter;
        }
    }

    public long getCoinChangeCount() {
        return this.goldCount;
    }

    public void setId(long id2) {
        this.id = id2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PresentType {
    }
}

