/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.sendgiftguide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.appbase.abtest.localab.LocalPercent;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.roomfloat.FloatMsgInfo;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.span.VerticalImageSpan;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.giftbox.GiftFloatMsgInfo;
import com.yy.hiyo.wallet.base.revenue.gift.GiftType;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftGuideInfo;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftBehavior;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftHandlerParam;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import com.yy.hiyo.wallet.gift.data.result.GiftOperationNotifyResult;
import com.yy.hiyo.wallet.gift.data.result.SendGiftRes;
import com.yy.hiyo.wallet.gift.handler.IGiftHandlerCallback;
import com.yy.hiyo.wallet.gift.model.GiftOperationModel;
import com.yy.hiyo.wallet.gift.ui.pannel.IGiftPanelHandlerCallback;
import com.yy.hiyo.wallet.gift.ui.sendgiftguide.SendGiftGuideContract;
import com.yy.hiyo.wallet.gift.ui.sendgiftguide.SendGiftGuideOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SendGiftGuidePresenter
implements SendGiftGuideContract.Presenter,
SendGiftGuideOperator {
    public static final String ICON_REPLACE = "\u3010\u793c\u7269icon\u3011";
    public static final String NICK_REPLACE = "\u3010\u7528\u6237\u6635\u79f0\u3011";
    public static final long RETURN_INTERVAL = 604800000L;
    private Context mContext;
    private IGiftBehavior mBehavior;
    private GiftComparator mGiftComparator;
    private GiftHandlerParam mParam;
    private GiftBroadcastInfo mGiftBroadcastInfo;
    private GiftOperationModel mModel;
    private IGiftPanelHandlerCallback mPanelCallback;
    private IGiftHandlerCallback mHandlerCallback;
    private volatile boolean mCanShowUnfreeReturn;
    private volatile SendGiftGuideInfo mUnfreeReturnGuideInfo;
    private int[] mPsContents = new int[]{R.string.tips_return_public_screen_a, R.string.tips_return_public_screen_b, R.string.tips_return_public_screen_c, R.string.tips_return_public_screen_d, R.string.tips_return_public_screen_e, R.string.tips_return_public_screen_f, R.string.tips_return_public_screen_g};
    private boolean mSentReturn;
    private String mCurToken;

    public SendGiftGuidePresenter(@NonNull ViewGroup layer, @NonNull IGiftHandlerCallback handlerCallback, @NonNull GiftHandlerParam param, @NonNull IGiftPanelHandlerCallback panelCallback) {
        this.mParam = param;
        this.mPanelCallback = panelCallback;
        this.mHandlerCallback = handlerCallback;
        this.mContext = layer.getContext();
        this.mBehavior = param.getBehavior();
        this.mModel = new GiftOperationModel();
        this.mGiftComparator = new GiftComparator();
    }

    public void start() {
    }

    @Override
    public void destroy() {
        FeatureLog.i((String)"FTSendGiftGuide", (String)"destroy", (Object[])new Object[0]);
    }

    @Override
    public void setSendGiftGuideInfo(@NonNull GiftOperationNotifyResult result) {
        SendGiftGuideInfo info = result.getSendGiftGuideInfo();
        FeatureLog.i((String)"FTSendGiftGuide", (String)"setSendGiftGuideInfo : %s", (Object[])new Object[]{info});
        if (info != null && info.getIgnorePlatform() != SendGiftGuideInfo.IgnorePlatform.ANDROID) {
            if (info.getReceiveUid() == 0L) {
                FeatureLog.i((String)"FTSendGiftGuide", (String)"setSendGiftGuideInfo, the target user of send gift return", (Object[])new Object[0]);
                this.mCanShowUnfreeReturn = true;
                this.mUnfreeReturnGuideInfo = info;
            } else {
                FeatureLog.i((String)"FTSendGiftGuide", (String)"setSendGiftGuideInfo, send gift guide", (Object[])new Object[0]);
                if (StringUtils.equal((String)this.mCurToken, (String)info.getToken())) {
                    FeatureLog.i((String)"FTSendGiftGuide", (String)"setSendGiftGuideInfo, scancel send gift return", (Object[])new Object[0]);
                    this.mCanShowUnfreeReturn = false;
                }
                this.handleGuideInfo(info);
            }
            this.mCurToken = info.getToken();
        }
    }

    @Override
    public void sendGift(UserInfoKS receiver, final GiftItemInfo giftItemInfo, int count) {
        final GiftUserInfo giftUserInfo = new GiftUserInfo();
        giftUserInfo.setUserInfo(receiver);
        if (receiver.uid == this.mParam.getAnchorUid()) {
            giftUserInfo.setUserType(1);
        }
        this.mPanelCallback.sendGift(new ArrayList<GiftUserInfo>(Collections.singleton(giftUserInfo)), 8, giftItemInfo, 1, new IGiftCallback<SendGiftRes>(){

            public void onSucceed(SendGiftRes result) {
                if (!SendGiftGuidePresenter.this.mSentReturn) {
                    SendGiftGuidePresenter.this.sendGiftReturn(giftUserInfo, giftItemInfo);
                }
            }

            public void onFailed(int code, String msg) {
            }
        });
    }

    @Override
    public void onReceivedGift(GiftBroadcastInfo info) {
        if (this.mCanShowUnfreeReturn && this.mGiftBroadcastInfo == null && info != null && info.getRecvUid() == AccountUtil.getUid() && info.getUid() != AccountUtil.getUid()) {
            this.mGiftBroadcastInfo = info;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SendGiftGuidePresenter.this.mCanShowUnfreeReturn && SendGiftGuidePresenter.this.mUnfreeReturnGuideInfo != null) {
                        SendGiftGuidePresenter.this.handleGuideInfo(SendGiftGuidePresenter.this.mUnfreeReturnGuideInfo);
                    }
                }
            }, (long)3000L);
        }
    }

    @Override
    public void onSendGift(GiftUserInfo receiver, GiftItemInfo giftInfo) {
        long lastTime = this.mModel.getLastSendGiftTime();
        if (lastTime == -1L) {
            this.sendGiftReturn(receiver, giftInfo);
        } else if (System.currentTimeMillis() - lastTime > 604800000L) {
            this.sendGiftReturn(receiver, giftInfo);
        } else {
            this.mSentReturn = false;
        }
        this.mModel.addSendGiftTime();
    }

    private void sendGiftReturn(final GiftUserInfo receiver, final GiftItemInfo giftInfo) {
        final UserInfoKS myInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
        if (receiver == null || receiver.getUserInfo() == null || giftInfo == null || myInfo == null || myInfo.uid == receiver.uid()) {
            return;
        }
        this.mSentReturn = true;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int iconIndex;
                int index = LocalPercent.random((int)SendGiftGuidePresenter.this.mPsContents.length);
                MyClickableSpan clickSelf = new MyClickableSpan(myInfo.uid);
                MyClickableSpan clickOther = new MyClickableSpan(receiver.uid());
                String content = ResourceUtils.getString((int)SendGiftGuidePresenter.this.mPsContents[index]);
                int nickIndex = content.indexOf(SendGiftGuidePresenter.NICK_REPLACE);
                if (nickIndex != -1) {
                    content = content.replace(SendGiftGuidePresenter.NICK_REPLACE, myInfo.nick);
                }
                final SpannableString spannableString = new SpannableString((CharSequence)content);
                if (nickIndex != -1) {
                    int selfNickIndex = content.indexOf(myInfo.nick);
                    int selfNickLength = myInfo.nick.length();
                    spannableString.setSpan((Object)clickSelf, selfNickIndex, selfNickIndex + selfNickLength, 33);
                }
                if ((iconIndex = content.indexOf(SendGiftGuidePresenter.ICON_REPLACE)) != -1) {
                    final int iconLength = SendGiftGuidePresenter.ICON_REPLACE.length();
                    ImageLoader.loadBitmap((Context)SendGiftGuidePresenter.this.mContext, (String)(giftInfo.getStaticIcon() + YYImageUtils.getThumbnailPostfix((int)75)), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                        public void onLoadFailed(Exception e) {
                            boolean i = false;
                        }

                        public void onResourceReady(Bitmap bitmap) {
                            if (bitmap != null) {
                                BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                                drawable2.setBounds(0, 0, ResolutionUtils.dip2Px((float)25.0f), ResolutionUtils.dip2Px((float)25.0f));
                                VerticalImageSpan imageSpan = new VerticalImageSpan((Drawable)drawable2, 2, 0.0f);
                                spannableString.setSpan((Object)imageSpan, iconIndex, iconIndex + iconLength, 1);
                                SendGiftGuidePresenter.this.mBehavior.appendCustomPublicScreen(receiver.getUserInfo(), (CharSequence)spannableString);
                            }
                        }
                    });
                } else {
                    SendGiftGuidePresenter.this.mBehavior.appendCustomPublicScreen(receiver.getUserInfo(), (CharSequence)spannableString);
                }
            }
        }, (long)5000L);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SendGiftGuidePresenter.this.mBehavior.showFaceEmojiSvga(receiver.uid(), "feiwen");
            }
        }, (long)3000L);
    }

    @Override
    public String getRoomId() {
        return this.mParam.getRoomId();
    }

    private void handleGuideInfo(SendGiftGuideInfo info) {
        if (info == null) {
            return;
        }
        UserInfoKS userInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(info.getReceiveUid(), null);
        GiftItemInfo giftItemInfo = null;
        int type = 0;
        if (info.getReceiveUid() == 0L) {
            FeatureLog.i((String)"FTSendGiftGuide", (String)"handleGuideInfo, guide type : RETURN", (Object[])new Object[0]);
            giftItemInfo = this.getGiftInfo(GiftType.UNFREE);
            type = 2;
            if (this.mGiftBroadcastInfo != null) {
                userInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(this.mGiftBroadcastInfo.getUid(), null);
            }
            this.mGiftBroadcastInfo = null;
        } else if (info.getGiftType() == GiftType.FREE) {
            FeatureLog.i((String)"FTSendGiftGuide", (String)"handleGuideInfo, guide type : FREE", (Object[])new Object[0]);
            giftItemInfo = this.getGiftInfo(GiftType.FREE);
            type = 0;
        } else if (info.getGiftType() == GiftType.UNFREE) {
            FeatureLog.i((String)"FTSendGiftGuide", (String)"handleGuideInfo, guide type : UNFREE", (Object[])new Object[0]);
            giftItemInfo = this.getGiftInfo(GiftType.UNFREE);
            type = 1;
        }
        this.showFloatView(info, userInfo, type, giftItemInfo);
    }

    private void showFloatView(SendGiftGuideInfo info, UserInfoKS userInfo, int type, GiftItemInfo giftItemInfo) {
        if (giftItemInfo == null || userInfo == null || type == 1 && !this.mBehavior.isUserOnMicSeat(null, userInfo.uid)) {
            return;
        }
        GiftUserInfo giftUserInfo = new GiftUserInfo();
        giftUserInfo.setUserInfo(userInfo);
        if (userInfo.uid == this.mParam.getAnchorUid()) {
            giftUserInfo.setUserType(1);
        }
        this.mModel.reportSendGiftGuideShow(info, null);
        String content = "";
        String senderName = ShortNameUtils.getShortNameWithoutColon((String)giftItemInfo.getName(), (int)7);
        String receiverName = ShortNameUtils.getShortNameWithoutColon((String)userInfo.nick, (int)7);
        if (type == 0) {
            content = String.format(ResourceUtils.getString((int)R.string.tips_send_gift_guide_host), senderName);
        } else if (type == 1) {
            if (info.getRecvType() == SendGiftGuideInfo.RecvUserType.ATTENTION) {
                content = String.format(ResourceUtils.getString((int)R.string.tips_send_gift_guide_attention), receiverName, senderName);
            } else if (info.getRecvType() == SendGiftGuideInfo.RecvUserType.FRIEND) {
                content = String.format(ResourceUtils.getString((int)R.string.tips_send_gift_guide_friend), senderName, receiverName);
            }
        } else if (type == 2) {
            content = String.format(ResourceUtils.getString((int)R.string.tips_send_gift_guide_return), receiverName, senderName);
        }
        GiftFloatMsgInfo giftFloatMsgInfo = new GiftFloatMsgInfo(Integer.valueOf(0), content, "", "", giftItemInfo.getStaticIcon(), "", "");
        giftFloatMsgInfo.setCount(Integer.valueOf(1));
        giftFloatMsgInfo.setGiftItemInfo(giftItemInfo);
        giftFloatMsgInfo.setReceiver(Collections.singletonList(giftUserInfo));
        if (this.mParam != null) {
            this.mParam.getBehavior().addGiftFloatView((FloatMsgInfo)giftFloatMsgInfo);
        }
    }

    private GiftItemInfo getGiftInfo(int giftType) {
        GiftItemInfo giftItemInfo;
        block6: {
            block7: {
                giftItemInfo = null;
                if (giftType != GiftType.FREE) break block7;
                List<GiftItemInfo> packageList = this.mHandlerCallback.getAllPackage(AccountUtil.getUid());
                if (FP.empty(packageList)) break block6;
                for (GiftItemInfo itemInfo : packageList) {
                    if (itemInfo == null || itemInfo.getType() != 10 || itemInfo.getCount() <= 0) continue;
                    giftItemInfo = itemInfo;
                    break block6;
                }
                break block6;
            }
            if (giftType == GiftType.UNFREE) {
                ArrayList<GiftItemInfo> giftItemList;
                List<GiftItemInfo> list = this.mHandlerCallback.getAllPackage(AccountUtil.getUid());
                if (!FP.empty(list)) {
                    ArrayList<GiftItemInfo> packageList = new ArrayList<GiftItemInfo>(list);
                    Collections.sort(packageList, this.mGiftComparator);
                    for (GiftItemInfo itemInfo : packageList) {
                        if (itemInfo == null || itemInfo.getType() == 10 || itemInfo.getCount() <= 0 || GiftUtils.giftPrice((GiftItemInfo)itemInfo) > 50L) continue;
                        giftItemInfo = itemInfo;
                        break;
                    }
                }
                if (giftItemInfo == null && !FP.empty(giftItemList = new ArrayList<GiftItemInfo>(this.mHandlerCallback.getAllGift(this.mParam.getChannelId())))) {
                    Collections.sort(giftItemList, this.mGiftComparator);
                    for (GiftItemInfo itemInfo : giftItemList) {
                        if (itemInfo == null || itemInfo.getType() == 10) continue;
                        giftItemInfo = itemInfo;
                        break;
                    }
                }
            }
        }
        return giftItemInfo;
    }

    private final class MyClickableSpan
    extends ClickableSpan {
        private long uid;

        MyClickableSpan(long uid) {
            this.uid = uid;
        }

        public void onClick(@NonNull View widget) {
            SendGiftGuidePresenter.this.mBehavior.openUserCard(this.uid);
        }

        public void updateDrawState(@NonNull TextPaint ds) {
            ds.setColor(-1);
            ds.setUnderlineText(false);
        }
    }

    public static final class GiftComparator
    implements Comparator<GiftItemInfo> {
        @Override
        public int compare(GiftItemInfo o1, GiftItemInfo o2) {
            if (o1 != null && o2 != null) {
                long price2;
                long price1 = GiftUtils.giftPrice((GiftItemInfo)o1);
                if (price1 < (price2 = GiftUtils.giftPrice((GiftItemInfo)o2))) {
                    return -1;
                }
                if (price1 == price2) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }
    }

    static interface Type {
        public static final int FREE = 0;
        public static final int UNFREE = 1;
        public static final int RETURN = 2;
    }
}

