/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.publicscreen;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.degrade.DiscardResult;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.ISceneOptLimiterCallback;
import com.yy.appbase.degrade.SimpleSceneOptLimiterCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.IGiftHandler;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroadcastInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftComboInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftExpand;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftPublicScreenParam;
import com.yy.hiyo.wallet.gift.effect.IEffectPresenter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GiftPublicScreenPresenter
implements IEffectPresenter {
    private static final String TAG = "GiftPublicScreenPresenter";
    private IGiftHandler mGiftHandler;
    private ISceneOptLimiter<GiftBroResult> mSceneOptLimiter;
    private ISceneOptLimiterCallback<GiftBroResult> mSceneOptLimiterCallback = new SimpleSceneOptLimiterCallback<GiftBroResult>(){

        @NotNull
        public DiscardResult onDiscard(GiftBroResult item, float discardRatio, int discardMinRemain, int maxRemain) {
            return DiscardResult.NONE;
        }

        @Nullable
        public List<GiftBroResult> needDiscardWhenOnDiscard(@NotNull List<? extends GiftBroResult> items, float discardRatio, int discardMinRemain, int maxRemain) {
            return GiftUtils.discardStrategy(items, (float)discardRatio, (int)discardMinRemain, (int)maxRemain);
        }

        public boolean isDisCardOldDataFrequency() {
            return false;
        }

        public boolean needSkip(GiftBroResult item) {
            return item.isMySendOrReceive();
        }

        public void onAppendItem(GiftBroResult item) {
            GiftPublicScreenPresenter.this.appGiftPublicScreen(item);
        }
    };

    @NotNull
    private ISceneOptLimiter<GiftBroResult> getLimiter() {
        if (this.mSceneOptLimiter != null) {
            return this.mSceneOptLimiter;
        }
        this.mSceneOptLimiter = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).createLimiter("gift_public_screen", this.mSceneOptLimiterCallback);
        return this.mSceneOptLimiter;
    }

    public GiftPublicScreenPresenter(IGiftHandler handler) {
        this.mGiftHandler = handler;
    }

    @Override
    public void destroy() {
        this.getLimiter().destroy();
        this.mGiftHandler = null;
    }

    @Override
    public void addGiftEffect(@NonNull GiftBroResult result) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"addGiftEffect result: %s", (Object[])new Object[]{result});
        }
        if (this.mGiftHandler != null && !result.isFinish()) {
            this.getLimiter().addItem((Object)result, 0);
        }
    }

    private void appGiftPublicScreen(final @NonNull GiftBroResult result) {
        int addPublicDelay = 0;
        if (result.getExpand() != null && result.getExpand().boxPropId > 0) {
            addPublicDelay = 3000;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GiftPublicScreenPresenter.this.mGiftHandler != null) {
                    GiftPublicScreenPresenter.this.mGiftHandler.getGiftHandlerParam();
                    GiftPublicScreenPresenter.this.mGiftHandler.getGiftHandlerParam().getBehavior().appendPublicScreen(GiftPublicScreenPresenter.this.mGiftHandler, GiftPublicScreenPresenter.this.getParam(result));
                }
            }
        }, (long)addPublicDelay);
    }

    private GiftPublicScreenParam getParam(GiftBroResult info) {
        String giftUrl;
        GiftBroadcastInfo bro = info.getGiftBroInfo();
        SendGiftExpand expand = info.getExpand();
        GiftComboInfo combo = info.getGiftComboInfo();
        GiftItemInfo giftInfo = info.getGiftInfo();
        String giftLevelUrl = "";
        String string2 = giftUrl = giftInfo == null ? "" : giftInfo.getStaticIcon();
        if (info.getExpand() != null && !TextUtils.isEmpty((CharSequence)(giftLevelUrl = info.getGiftInfo().getGradeIcon(String.valueOf(info.getExpand().giftLevel))))) {
            giftUrl = giftLevelUrl;
        }
        boolean comboFinish = combo != null && combo.getIsFinishCombo();
        int comboCount = combo != null ? combo.getComboHits() : 0;
        String recvNick = bro.getRecvNickname();
        long recvUid = bro.getRecvUid();
        long giftPrice = GiftUtils.giftPrice((GiftItemInfo)giftInfo);
        if (bro.getRevUserInfos() != null && bro.getRevUserInfos().size() > 1) {
            recvNick = ResourceUtils.getString((int)R.string.tips_recv_all);
            recvUid = -1L;
        }
        GiftPublicScreenParam param = GiftPublicScreenParam.newBuilder().senderUid(bro.getUid()).sendNick(bro.getUserNickname()).sendHeadIcon(expand == null ? "" : expand.senderHeaderUrl).boxPropId(expand == null ? 0 : expand.boxPropId).receiverUid(recvUid).receiverNick(recvNick).count(bro.getPropsCount()).giftId(bro.getPropsId()).giftPrice(giftPrice).comboCount(comboCount).isComboFinish(comboFinish).giftIcon(giftUrl).giftSlogan(expand == null ? "" : expand.giftSlogan).type(giftInfo == null ? -1 : giftInfo.getType()).charmValue(giftInfo == null ? 0 : giftInfo.getCharmValue()).giftName(giftInfo != null ? giftInfo.getName() : "").build();
        return param;
    }
}

