/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.gift.ui.pannel.GiftPanelContract;
import com.yy.hiyo.wallet.gift.ui.pannel.adapter.GiftAmountAdapter;
import com.yy.hiyo.wallet.gift.ui.pannel.ui.GiftPanel;

public class GiftAmountView
extends YYLinearLayout
implements GiftAmountAdapter.OnAmountClickListener {
    private Context mContext;
    private RecyclerView amountList;
    private GiftAmountAdapter mGiftAmountAdapter;
    private GiftPanelContract.View mUICallback;
    private GiftPanel giftPanel;

    public GiftAmountView(Context context, GiftPanel giftPanel, GiftPanelContract.View mUICallback) {
        super(context);
        this.mContext = context;
        this.mUICallback = mUICallback;
        this.giftPanel = giftPanel;
        this.createView();
    }

    private void createView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_gift_amount, (ViewGroup)this);
        this.amountList = (RecyclerView)this.findViewById(R.id.rv_gift_amount_list);
        LinearLayoutManager amountLayoutManager = new LinearLayoutManager(this.mContext, 1, true);
        this.mGiftAmountAdapter = new GiftAmountAdapter();
        this.mGiftAmountAdapter.setOnClickListener(this);
        this.amountList.setLayoutManager((RecyclerView.LayoutManager)amountLayoutManager);
        this.amountList.setAdapter((RecyclerView.Adapter)this.mGiftAmountAdapter);
    }

    @Override
    public void onClickAmount(GiftItemInfo.Number number) {
        if (this.mUICallback != null) {
            this.mUICallback.updateGiftAmount(String.valueOf(number == null ? 0 : number.getNumber()));
            if (this.mGiftAmountAdapter != null) {
                this.mGiftAmountAdapter.setSelectedItem(String.valueOf(number == null ? 0 : number.getNumber()));
                this.mGiftAmountAdapter.notifyDataSetChanged();
            }
        }
    }

    public void setDate(GiftItemInfo giftInfo) {
        if (this.mGiftAmountAdapter != null && giftInfo != null) {
            this.mGiftAmountAdapter.setData(giftInfo.getNumberLists());
        }
    }

    public void setSelectedItem(String amount) {
        if (this.mGiftAmountAdapter != null) {
            this.mGiftAmountAdapter.setSelectedItem(amount);
            this.mGiftAmountAdapter.notifyDataSetChanged();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.giftPanel != null && this.giftPanel.isGiftAmountShow()) {
            this.post(() -> this.giftPanel.dismissAmountList());
        }
        return true;
    }
}

