/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.pannel.bean;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.utils.LanguageUtils;

public class ItemSpaceDecoration
extends RecyclerView.ItemDecoration {
    private int mSpace;
    private int mColumCount;

    public ItemSpaceDecoration(int space, int columCount) {
        this.mSpace = space;
        this.mColumCount = columCount;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int pos = parent.getChildLayoutPosition(view);
        if (this.isFirstRow(pos)) {
            outRect.bottom = this.mSpace;
        }
        if (LanguageUtils.isLtr()) {
            outRect.left = this.mSpace;
            if ((pos + 1) % this.mColumCount == 0) {
                outRect.right = this.mSpace;
            }
        } else {
            outRect.right = this.mSpace;
            if ((pos + 1) % this.mColumCount == 0) {
                outRect.left = this.mSpace;
            }
        }
    }

    private boolean isFirstRow(int pos) {
        return pos < this.mColumCount;
    }
}

