/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.luckygift;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import biz.ESexType;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.wallet.DR;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.gift.LuckyGiftyNotifyType;
import com.yy.hiyo.wallet.gift.data.bean.LuckyGiftBroadcastInfo;
import com.yy.hiyo.wallet.gift.data.bean.LuckyGiftUnicastInfo;
import com.yy.hiyo.wallet.gift.ui.luckygift.LuckyGiftContract;
import java.util.List;

public class LuckyGiftView
extends YYConstraintLayout
implements LuckyGiftContract.View {
    private ViewGroup mLayer;
    private YYTextView mPoolWinContent;
    private YYTextView mTvBroadcastContent;
    private CircleImageView mCivAvatar;
    private ConstraintLayout mClWinPoolContainer;
    private ConstraintLayout mClBroadcastContainer;
    private LuckyGiftContract.Presenter mPresenter;
    private boolean mIsPrizePoolWinIn;
    private boolean mIsPrizePoolWinOut;
    private boolean mIsPrizePoolWinShowing;
    private boolean mIsWinBroadcastShowing;
    private AnimatorSet mPrizePoolWinAnimIn;
    private AnimatorSet mPrizePoolWinAnimOut;
    private ObjectAnimator mBroadcastAnimIn;
    private ObjectAnimator mBroadcastAnimOut;
    private static final int ANIMATION_DURATION = 300;
    private static final int SHOW_DURATION = 3000;

    private LuckyGiftView(Context context) {
        this(context, null);
    }

    private LuckyGiftView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private LuckyGiftView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public LuckyGiftView(ViewGroup layer) {
        this(layer.getContext());
        this.mLayer = layer;
        this.createView();
    }

    private void createView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_lucky_gift, (ViewGroup)this);
        this.mCivAvatar = (CircleImageView)this.findViewById(R.id.civ_avatar);
        this.mClWinPoolContainer = (ConstraintLayout)this.findViewById(R.id.cl_pool_win_container);
        this.mClBroadcastContainer = (ConstraintLayout)this.findViewById(R.id.cl_broadcast_container);
        this.mPoolWinContent = (YYTextView)this.findViewById(R.id.tv_win_pool);
        this.mTvBroadcastContent = (YYTextView)this.findViewById(R.id.tv_broadcast);
        if (Build.VERSION.SDK_INT >= 17) {
            if (LanguageUtils.isLtr()) {
                this.mTvBroadcastContent.setTextDirection(3);
            } else {
                this.mTvBroadcastContent.setTextDirection(4);
            }
        }
        if (this.mLayer != null) {
            if (this.getParent() != null) {
                ((ViewGroup)this.getParent()).removeView((View)this);
            }
            this.mLayer.addView((View)this);
        }
        this.initAnim();
    }

    private void initAnim() {
        this.mPrizePoolWinAnimIn = new AnimatorSet();
        this.mPrizePoolWinAnimOut = new AnimatorSet();
        ObjectAnimator scaleXIn = ObjectAnimator.ofFloat((Object)this.mClWinPoolContainer, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator scaleYIn = ObjectAnimator.ofFloat((Object)this.mClWinPoolContainer, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
        this.mPrizePoolWinAnimIn.play((Animator)scaleXIn).with((Animator)scaleYIn);
        ObjectAnimator scaleXOut = ObjectAnimator.ofFloat((Object)this.mClWinPoolContainer, (String)"scaleX", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator scaleYOut = ObjectAnimator.ofFloat((Object)this.mClWinPoolContainer, (String)"scaleY", (float[])new float[]{1.0f, 0.0f});
        this.mPrizePoolWinAnimOut.play((Animator)scaleXOut).with((Animator)scaleYOut);
        this.mPrizePoolWinAnimIn.setDuration(300L);
        this.mPrizePoolWinAnimOut.setDuration(300L);
        this.mBroadcastAnimIn = ObjectAnimator.ofFloat((Object)this.mClBroadcastContainer, (String)"translationX", (float[])new float[]{ScreenUtils.getInstance().getWidthPixels(), 0.0f});
        this.mBroadcastAnimOut = ObjectAnimator.ofFloat((Object)this.mClBroadcastContainer, (String)"translationX", (float[])new float[]{0.0f, ScreenUtils.getInstance().getWidthPixels()});
        this.mBroadcastAnimIn.setDuration(300L);
        this.mBroadcastAnimOut.setDuration(300L);
    }

    @Override
    public void showCurUserWin(LuckyGiftUnicastInfo info) {
        if (info != null && info.getUid() == AccountUtil.getUid()) {
            if (info.getType() == LuckyGiftyNotifyType.PERIOD) {
                UserInfoKS userInfo = ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).getUserInfo(info.getUid());
                GiftItemInfo giftItemInfo = this.mPresenter.getGiftInfo(info.getPropId());
                if (userInfo != null && giftItemInfo != null) {
                    String content = LanguageUtils.isLtr() ? String.format(ResourceUtils.getString((int)R.string.tips_lucky_gift_pool_win), giftItemInfo.getName(), info.getDiamonds()) : String.format(ResourceUtils.getString((int)R.string.tips_lucky_gift_pool_win), info.getDiamonds(), giftItemInfo.getName());
                    this.mPoolWinContent.setText((CharSequence)content);
                    ImageLoader.loadImage((ImageView)this.mCivAvatar, (String)userInfo.avatar, (int)(userInfo.sex == ESexType.ESTFemale.getValue() ? R.drawable.icon_avatar_default_female : R.drawable.icon_avatar_default_male));
                    this.startPrizePoolAnimIn();
                    this.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            LuckyGiftView.this.hidePrizePool();
                        }
                    });
                }
                if (userInfo == null) {
                    FeatureLog.i((String)"FTLuckyGift", (String)"showCurUserWin (PERIOD), userInfo = null", (Object[])new Object[0]);
                }
                if (giftItemInfo == null) {
                    FeatureLog.i((String)"FTLuckyGift", (String)"showCurUserWin (PERIOD), giftItemInfo = null", (Object[])new Object[0]);
                }
            } else if (info.getType() == LuckyGiftyNotifyType.INSTANT) {
                GiftItemInfo giftItemInfo = this.mPresenter.getGiftInfo(info.getPropId());
                if (giftItemInfo != null) {
                    String content = String.format(ResourceUtils.getString((int)R.string.tips_new_lucky_gift_toast), giftItemInfo.getName(), info.getDiamonds());
                    ToastUtils.showToast((Context)this.getContext(), (String)content, (int)0);
                }
                if (giftItemInfo == null) {
                    FeatureLog.i((String)"FTLuckyGift", (String)"showCurUserWin (INSTANT), giftItemInfo = null", (Object[])new Object[0]);
                }
            }
        }
    }

    @Override
    public void showWinBroadcast(final LuckyGiftBroadcastInfo info) {
        if (info != null) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(info.getWinner(), new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    GiftItemInfo giftItemInfo = LuckyGiftView.this.mPresenter.getGiftInfo(info.getPropId());
                    if (giftItemInfo != null && !FP.empty(userInfoKSList)) {
                        UserInfoKS userInfo = userInfoKSList.get(0);
                        if (userInfo != null) {
                            String content = String.format(ResourceUtils.getString((int)R.string.tips_lucky_gift_win_broadcast), ShortNameUtils.getShortNameWithoutColon((String)userInfo.nick, (int)7), StringUtils.getFormatedNumber((long)info.getDiamonds(), (int)1), giftItemInfo.getName());
                            LuckyGiftView.this.mTvBroadcastContent.setText((CharSequence)content);
                            LuckyGiftView.this.startBroadcastAnimIn();
                        } else {
                            FeatureLog.i((String)"FTLuckyGift", (String)"showWinBroadcast, userInfo = null", (Object[])new Object[0]);
                        }
                    }
                    if (giftItemInfo == null) {
                        FeatureLog.i((String)"FTLuckyGift", (String)"showWinBroadcast, giftItemInfo = null", (Object[])new Object[0]);
                    }
                    if (FP.empty(userInfoKSList)) {
                        FeatureLog.i((String)"FTLuckyGift", (String)"showWinBroadcast, get user info list is empty", (Object[])new Object[0]);
                    }
                }

                public void onFail(int id2, String msg, String response) {
                    FeatureLog.i((String)"FTLuckyGift", (String)"showWinBroadcast, get user info error : %s", (Object[])new Object[]{response});
                }

                public int id() {
                    return 0;
                }
            });
        }
    }

    private void startBroadcastAnimIn() {
        FeatureLog.i((String)"FTLuckyGift", (String)"startBroadcastAnimIn", (Object[])new Object[0]);
        this.mClBroadcastContainer.setVisibility(0);
        RecycleImageView imageView = (RecycleImageView)this.findViewById(R.id.iv_bg_win);
        DyResLoader.INSTANCE.loadImage(imageView, DR.bg_lucky_gift_win);
        this.mBroadcastAnimIn.start();
        this.onBroadcastAnimInStart();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LuckyGiftView.this.onBroadcastAnimInEnd();
            }
        }, (long)300L);
    }

    private void onBroadcastAnimInStart() {
        this.mIsWinBroadcastShowing = true;
        FeatureLog.i((String)"FTLuckyGift", (String)"onBroadcastAnimInStart", (Object[])new Object[0]);
    }

    private void onBroadcastAnimInEnd() {
        FeatureLog.i((String)"FTLuckyGift", (String)"onBroadcastAnimInEnd", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LuckyGiftView.this.mBroadcastAnimOut.start();
                FeatureLog.i((String)"FTLuckyGift", (String)"BroadcastAnimOut start", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LuckyGiftView.this.onBroadcastAnimOutEnd();
                    }
                }, (long)300L);
            }
        }, (long)3000L);
    }

    private void onBroadcastAnimOutEnd() {
        this.mIsWinBroadcastShowing = false;
        this.mClBroadcastContainer.setVisibility(8);
        YYImageView imageView = (YYImageView)this.findViewById(R.id.iv_bg_win);
        imageView.setImageDrawable(null);
        this.mPresenter.onWinBroadcastHide();
        FeatureLog.i((String)"FTLuckyGift", (String)"onBroadcastAnimOutEnd", (Object[])new Object[0]);
    }

    private void startPrizePoolAnimIn() {
        this.mClWinPoolContainer.setVisibility(0);
        this.setBackgroundColor(0x4C000000);
        this.mPrizePoolWinAnimIn.start();
        this.onPrizePoolAnimInStart();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LuckyGiftView.this.onPrizePoolAnimInEnd();
            }
        }, (long)300L);
        FeatureLog.i((String)"FTLuckyGift", (String)"startPrizePoolAnimIn", (Object[])new Object[0]);
    }

    private void onPrizePoolAnimInStart() {
        this.mIsPrizePoolWinIn = true;
        this.mIsPrizePoolWinShowing = true;
        FeatureLog.i((String)"FTLuckyGift", (String)"onPrizePoolAnimInStart", (Object[])new Object[0]);
    }

    private void onPrizePoolAnimInEnd() {
        this.mIsPrizePoolWinIn = false;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LuckyGiftView.this.hidePrizePool();
            }
        }, (long)3000L);
        FeatureLog.i((String)"FTLuckyGift", (String)"onPrizePoolAnimInEnd", (Object[])new Object[0]);
    }

    private void onPrizePoolAnimOutStart() {
        this.mIsPrizePoolWinOut = true;
        FeatureLog.i((String)"FTLuckyGift", (String)"onPrizePoolAnimOutStart", (Object[])new Object[0]);
    }

    private void hidePrizePool() {
        FeatureLog.i((String)"FTLuckyGift", (String)"hidePrizePool, mIsPrizePoolWinShowing = %s, mIsPrizePoolWinIn = %s, mIsPrizePoolWinOut = %s", (Object[])new Object[]{this.mIsPrizePoolWinShowing, this.mIsPrizePoolWinIn, this.mIsPrizePoolWinOut});
        if (this.mIsPrizePoolWinShowing && !this.mIsPrizePoolWinIn && !this.mIsPrizePoolWinOut) {
            this.mPrizePoolWinAnimOut.start();
            this.onPrizePoolAnimOutStart();
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LuckyGiftView.this.onPrizePoolAnimOutEnd();
                }
            }, (long)300L);
        }
    }

    private void onPrizePoolAnimOutEnd() {
        this.setBackgroundColor(0);
        this.mIsPrizePoolWinOut = false;
        this.mIsPrizePoolWinShowing = false;
        this.setClickable(false);
        this.mClWinPoolContainer.setVisibility(8);
        this.mPresenter.onPrizePoolWinHide();
        FeatureLog.i((String)"FTLuckyGift", (String)"onPrizePoolAnimOutStart", (Object[])new Object[0]);
    }

    @Override
    public void clearView() {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
    }

    @Override
    public boolean isWinBroadcastShowing() {
        return this.mIsWinBroadcastShowing;
    }

    @Override
    public boolean isPrizePoolWinShowing() {
        return this.mIsPrizePoolWinShowing;
    }

    public void setPresenter(LuckyGiftContract.Presenter presenter) {
        this.mPresenter = presenter;
    }
}

