/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.ui.freegift;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.ISceneOptLimiterCallback;
import com.yy.appbase.degrade.SimpleSceneOptLimiterCallback;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.reddot.IRedDot;
import com.yy.appbase.reddot.RedDot;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.unifyconfig.config.ScenePerfOptSceneDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.revenue.gift.IGiftHandler;
import com.yy.hiyo.wallet.base.revenue.gift.bean.ActivityPropertyInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.event.IGiftCallback;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftHandlerParam;
import com.yy.hiyo.wallet.gift.data.result.GiftOperationNotifyResult;
import com.yy.hiyo.wallet.gift.handler.IGiftHandlerCallback;
import com.yy.hiyo.wallet.gift.model.GiftOperationModel;
import com.yy.hiyo.wallet.gift.ui.freegift.FloatGiftTest;
import com.yy.hiyo.wallet.gift.ui.freegift.FloatingGroupPresenter;
import com.yy.hiyo.wallet.gift.ui.freegift.FloatingPropertyContract;
import com.yy.hiyo.wallet.gift.ui.freegift.FloatingPropertyOperator;
import com.yy.hiyo.wallet.gift.ui.freegift.FloatingView;
import com.yy.hiyo.wallet.gift.ui.freegift.IFloatingGroupPresenter;
import com.yy.webservice.WebEnvSettings;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.ihago.active.api.activity.ActItemGetRes;
import net.ihago.active.api.activity.ECode;
import net.ihago.active.api.activity.FreeGiftGetLimitRes;
import net.ihago.active.api.activity.FreeGiftGetRes;
import net.ihago.active.api.activity.PropOneLimit;
import net.ihago.money.api.pay.FreeGiftConversionNotify;

public class FloatingPropertyPresenter
implements FloatingPropertyContract.Presenter,
FloatingPropertyOperator {
    public static final String TAG = "FreeGiftPresenter";
    private Context mContext;
    private ViewGroup mLayer;
    private GiftOperationModel mModel;
    private Set<FloatingPropertyContract.View> mViewCache;
    private GiftHandlerParam mParam;
    private IGiftHandlerCallback mHandlerCallback;
    private Map<String, PropOneLimit> mLimitMap;
    private IRedDot mDot;
    private Random mRandom;
    private IGiftHandler mGiftHandler;
    private IFloatingGroupPresenter mFloatingGroupPresenter;
    private boolean canAnimate = true;
    private ISceneOptLimiter<GiftItemInfo> mSceneOptLimiter = null;
    private FloatGiftTest mFloatGiftTest;

    private ISceneOptLimiter<GiftItemInfo> getSceneOptLimiter() {
        if (this.mSceneOptLimiter == null) {
            this.mSceneOptLimiter = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).createLimiter("float_property", (ISceneOptLimiterCallback)new SimpleSceneOptLimiterCallback<GiftItemInfo>(){

                public void onAppendItem(GiftItemInfo item) {
                    FloatingPropertyPresenter.this.doFloatGift(item);
                }

                public void onStopAnimate() {
                    FloatingPropertyPresenter.this.canAnimate = false;
                }

                public void onRecoverAnimate() {
                    FloatingPropertyPresenter.this.canAnimate = true;
                }
            });
        }
        return this.mSceneOptLimiter;
    }

    public FloatingPropertyPresenter(ViewGroup giftLayer, GiftHandlerParam param, IGiftHandlerCallback handlerCallback, IGiftHandler giftHandler) {
        this.mContext = giftLayer.getContext();
        this.mModel = new GiftOperationModel();
        this.mViewCache = new HashSet<FloatingPropertyContract.View>();
        this.mLimitMap = new HashMap<String, PropOneLimit>();
        this.mParam = param;
        this.mHandlerCallback = handlerCallback;
        this.mDot = new RedDot();
        this.mRandom = new Random();
        this.mGiftHandler = giftHandler;
        this.mFloatingGroupPresenter = new FloatingGroupPresenter(this, this.mParam);
    }

    @Override
    public void onStart(ViewGroup giftLayer) {
        this.mFloatingGroupPresenter.onStart(giftLayer);
        this.mLayer = giftLayer;
        this.mViewCache = new HashSet<FloatingPropertyContract.View>();
        this.start();
    }

    @Override
    public void onPause() {
        this.mFloatingGroupPresenter.onPause();
        this.mViewCache = null;
        this.mLayer = null;
    }

    @Override
    public void onDestroy() {
        this.getSceneOptLimiter().destroy();
        if (this.mFloatingGroupPresenter != null) {
            this.mFloatingGroupPresenter.onDestroy();
        }
        this.mViewCache = null;
        this.mLimitMap = null;
        this.mFloatingGroupPresenter = null;
        if (this.mFloatGiftTest != null) {
            this.mFloatGiftTest.destroy();
        }
    }

    @Override
    public PropOneLimit getGiftLimit(int giftId) {
        if (this.mLimitMap != null) {
            return this.mLimitMap.get(String.valueOf(giftId));
        }
        return null;
    }

    public void start() {
        this.mModel.requestFreeGiftLimit(this.mParam.getRoomId(), new SimpleProtoCallback<FreeGiftGetLimitRes>(){

            public void onResponse(@Nullable FreeGiftGetLimitRes message) {
                int count;
                if (message != null && (count = message.props.size()) > 0) {
                    for (PropOneLimit limit : message.props) {
                        String id2 = String.valueOf(limit.prop_id);
                        if (FloatingPropertyPresenter.this.mLimitMap == null) continue;
                        FloatingPropertyPresenter.this.mLimitMap.put(id2, limit);
                    }
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
            }
        });
        if (ScenePerfOptSceneDef.isScenePressure((String)"float_property") && this.mFloatGiftTest == null) {
            this.mFloatGiftTest = new FloatGiftTest(this.getSceneOptLimiter(), this.mParam.getRoomId(), this.mParam.getAnchorUid());
            this.mFloatGiftTest.start();
        }
    }

    @Override
    public void onItemClick(FloatingPropertyContract.View view, FloatingView.FloatingItem floatingItem) {
        if (floatingItem == null || view == null || floatingItem.getInfo() == null) {
            return;
        }
        if (floatingItem.getType() == 1) {
            final GiftItemInfo giftInfo = (GiftItemInfo)floatingItem.getInfo();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("room_id", this.mParam.getRoomId()).put("function_id", "free_gift_click").put("gift_uid", String.valueOf(giftInfo.getPropsId())).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
            this.mModel.requestCollectFreeGift(String.valueOf(giftInfo.getPropsId()), new SimpleProtoCallback<FreeGiftGetRes>(){

                public void onResponse(@Nullable FreeGiftGetRes message) {
                    int result = 2;
                    if (message != null) {
                        GiftItemInfo gift = FloatingPropertyPresenter.this.mHandlerCallback.findGiftById(message.prop_id.intValue(), FloatingPropertyPresenter.this.mParam.getChannelId());
                        if (message.err.__isDefaultInstance()) {
                            MLog.info((Object)FloatingPropertyPresenter.TAG, (String)"collect one gift : %s", (Object[])new Object[]{message});
                            FloatingPropertyPresenter.this.checkDailyCountLimit(FP.orInt((Long)message.prop_id), FP.orInt((Long)message.add_count));
                            FloatingPropertyPresenter.this.checkTotalCountLimit(FP.orInt((Long)message.prop_id), FP.orInt((Long)message.add_count));
                            FloatingPropertyPresenter.this.mModel.addCollectCountDaily(message.prop_id.intValue(), FP.orInt((Long)message.add_count));
                            FloatingPropertyPresenter.this.mModel.addGiftTotalCount(message.prop_id.intValue(), FP.orInt((Long)message.add_count));
                            result = 1;
                        } else if (gift != null) {
                            PropOneLimit limit;
                            if (message.err.code == (long)ECode.EPropNotFound.getValue()) {
                                ToastUtils.showToast((Context)FloatingPropertyPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_enough_gift), (int)0);
                            } else if (message.err.code == (long)ECode.EExceededLimit.getValue()) {
                                PropOneLimit limit2;
                                if (FloatingPropertyPresenter.this.mLimitMap != null && (limit2 = (PropOneLimit)FloatingPropertyPresenter.this.mLimitMap.get(String.valueOf(message.prop_id))) != null) {
                                    String tips = String.format(ResourceUtils.getString((int)R.string.tips_reach_gift_daily_count_limit), limit2.sameday_cnt_limit, gift.getName());
                                    ToastUtils.showToast((Context)FloatingPropertyPresenter.this.mContext, (String)tips, (int)0);
                                }
                            } else if (message.err.code == (long)ECode.EExceededPackLimit.getValue() && FloatingPropertyPresenter.this.mLimitMap != null && (limit = (PropOneLimit)FloatingPropertyPresenter.this.mLimitMap.get(String.valueOf(message.prop_id))) != null) {
                                String tips = String.format(ResourceUtils.getString((int)R.string.tips_reach_gift_total_count_limit), gift.getName(), limit.max_cnt_limit);
                                ToastUtils.showToast((Context)FloatingPropertyPresenter.this.mContext, (String)tips, (int)0);
                            }
                        }
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("room_id", FloatingPropertyPresenter.this.mParam.getRoomId()).put("function_id", "free_gift_result").put("result_type", String.valueOf(result)).put("gift_uid", String.valueOf(giftInfo.getPropsId())).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
                }

                public void onError(String reason, int code) {
                    super.onError(reason, code);
                    if (!NetworkUtils.isNetworkAvailable((Context)FloatingPropertyPresenter.this.mContext)) {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                    }
                }
            });
        } else if (floatingItem.getType() == 2) {
            final ActivityPropertyInfo info = (ActivityPropertyInfo)floatingItem.getInfo();
            if (info.isDisableAck()) {
                this.handleUrl(info);
                this.mFloatingGroupPresenter.onAcquireSuccess(info);
                if (info.getDisplayCnt() > 0) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("room_id", this.mParam.getRoomId()).put("function_id", "act_gift_click").put("result_type", "1").put("active_id", String.valueOf(info.getItemId())).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
                } else {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("room_id", this.mParam.getRoomId()).put("function_id", "free_gift_result").put("result_type", "1").put("gift_uid", String.valueOf(info.getItemId())).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
                }
                return;
            }
            this.mModel.requestCollectActivityProperty(info, new SimpleProtoCallback<ActItemGetRes>(){

                public void onResponse(@Nullable ActItemGetRes message) {
                    super.onResponse((AndroidMessage)message);
                    int result = 2;
                    if (message != null) {
                        if (message.err.__isDefaultInstance()) {
                            FloatingPropertyPresenter.this.handleUrl(info);
                            result = 1;
                            FloatingPropertyPresenter.this.mFloatingGroupPresenter.onAcquireSuccess(info);
                        } else {
                            if (info.getDisplayCnt() > 0) {
                                FloatingPropertyPresenter.this.mFloatingGroupPresenter.onAcquireError();
                            }
                            if (message.err.code == (long)ECode.EItemNotFound.getValue() || message.err.code == (long)ECode.EItemExceededLimit.getValue()) {
                                ToastUtils.showToast((Context)FloatingPropertyPresenter.this.mContext, (String)ResourceUtils.getString((int)R.string.tips_enough_gift), (int)0);
                            }
                        }
                    }
                    if (info.getDisplayCnt() > 0) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("room_id", FloatingPropertyPresenter.this.mParam.getRoomId()).put("function_id", "act_gift_click").put("result_type", "1").put("active_id", String.valueOf(info.getItemId())).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
                    } else {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("room_id", FloatingPropertyPresenter.this.mParam.getRoomId()).put("function_id", "free_gift_result").put("result_type", String.valueOf(result)).put("gift_uid", String.valueOf(info.getItemId())).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
                    }
                }

                public void onError(String reason, int code) {
                    super.onError(reason, code);
                    if (!NetworkUtils.isNetworkAvailable((Context)FloatingPropertyPresenter.this.mContext)) {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                    }
                }
            });
        }
    }

    private void handleUrl(ActivityPropertyInfo info) {
        if (info != null) {
            WebEnvSettings settings = new WebEnvSettings();
            String url = info.getPopUrl();
            if (!TextUtils.isEmpty((CharSequence)url)) {
                Uri uri = Uri.parse((String)info.getPopUrl());
                String roomId = this.mParam == null ? "" : this.mParam.getRoomId();
                url = uri.getQueryParameterNames().size() > 0 ? url + "&" + UriProvider.appendCommonWebUrlParams() + "&roomId=" + roomId : url + "?" + UriProvider.appendCommonWebUrlParams() + "&roomId=" + roomId;
            }
            settings.url = url;
            settings.isShowBackBtn = true;
            settings.isFullScreen = true;
            settings.disablePullRefresh = true;
            settings.usePageTitle = false;
            settings.webViewBackgroundColor = 0x4C000000;
            settings.webWindowAnimator = false;
            settings.hideLastWindow = false;
            ((IWebService)ServiceManagerProxy.getServiceManager().getService(IWebService.class)).loadUrl(settings);
        }
    }

    @Override
    public void notifyFloatGift(GiftOperationNotifyResult result) {
        if (result == null || FP.empty(result.getFloatGiftList())) {
            return;
        }
        MLog.info((Object)TAG, (String)"float gift size: %s", (Object[])new Object[]{result.getFloatGiftList().size()});
        for (final GiftItemInfo giftInfo : result.getFloatGiftList()) {
            if (!this.canFloatGift(String.valueOf(giftInfo.getPropsId()))) continue;
            final PropOneLimit limit = this.mLimitMap.get(String.valueOf(giftInfo.getPropsId()));
            if (limit != null && limit.check_current.booleanValue()) {
                this.mGiftHandler.loadPackageList((IGiftCallback)new IGiftCallback<List<GiftItemInfo>>(){

                    public void onSucceed(List<GiftItemInfo> result) {
                        if (!FP.empty(result)) {
                            boolean hasPack = false;
                            for (GiftItemInfo giftItemInfo : result) {
                                if (giftItemInfo.getPropsId() != giftInfo.getPropsId()) continue;
                                hasPack = true;
                                if (giftItemInfo.getCount() > limit.current_limit) break;
                                FloatingPropertyPresenter.this.floatGift(giftInfo);
                                break;
                            }
                            if (!hasPack) {
                                FloatingPropertyPresenter.this.floatGift(giftInfo);
                            }
                        } else {
                            FloatingPropertyPresenter.this.floatGift(giftInfo);
                        }
                    }

                    public void onFailed(int code, String msg) {
                        FloatingPropertyPresenter.this.floatGift(giftInfo);
                    }
                });
                continue;
            }
            this.floatGift(giftInfo);
        }
    }

    private void floatGift(GiftItemInfo giftInfo) {
        if (giftInfo == null || this.mViewCache == null || this.mLayer == null) {
            return;
        }
        this.getSceneOptLimiter().addItem((Object)giftInfo);
    }

    private void doFloatGift(GiftItemInfo giftInfo) {
        if (giftInfo == null || this.mViewCache == null || this.mLayer == null) {
            return;
        }
        if (!this.canAnimate) {
            return;
        }
        FloatingPropertyContract.View view = null;
        if (this.mViewCache.isEmpty()) {
            view = new FloatingView(this.mLayer.getContext(), this, this.mParam.getBehavior().getGiftButtonParam());
        } else {
            Iterator<FloatingPropertyContract.View> iterator = this.mViewCache.iterator();
            if (iterator.hasNext()) {
                view = iterator.next();
                iterator.remove();
            }
        }
        view.setGiftInfo(giftInfo);
        view.enterAnim(this.mLayer);
        this.mModel.addGiftFloatTime(giftInfo.getPropsId());
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("room_id", this.mParam.getRoomId()).put("function_id", "free_gift_show").put("gift_uid", String.valueOf(giftInfo.getPropsId())).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
    }

    @Override
    public void notifyFloatActivityProperty(GiftOperationNotifyResult result) {
        if (result == null && FP.empty(result.getActivityPropertyList())) {
            return;
        }
        if (this.mViewCache != null && this.mLayer != null) {
            for (ActivityPropertyInfo info : result.getActivityPropertyList()) {
                if (!this.canFloatActivityProperty(info)) continue;
                if (info.getDisplayCnt() > 0) {
                    this.mFloatingGroupPresenter.notifyFloatActivityProperty(info);
                    continue;
                }
                FloatingPropertyContract.View view = null;
                if (this.mViewCache.isEmpty()) {
                    view = new FloatingView(this.mLayer.getContext(), this, this.mParam.getBehavior().getGiftButtonParam());
                } else {
                    Iterator<FloatingPropertyContract.View> iterator = this.mViewCache.iterator();
                    if (iterator.hasNext()) {
                        view = iterator.next();
                        iterator.remove();
                    }
                }
                view.setGiftInfo(info);
                view.enterAnim(this.mLayer);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("room_id", this.mParam.getRoomId()).put("function_id", "free_gift_show").put("gift_uid", String.valueOf(info.getItemId())).put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
            }
        }
    }

    @Override
    public void onSendGift(GiftItemInfo giftInfo, int number) {
        if (giftInfo != null) {
            this.mModel.reduceTotalCount(giftInfo.getPropsId(), number);
        }
    }

    @Override
    public void notifyReceivedGift(GiftOperationNotifyResult result) {
        PropOneLimit limit;
        FreeGiftConversionNotify notify = result.getReceivedNotify();
        MLog.info((Object)TAG, (String)"notifyReceivedGift, if reach limit : %s, receive count : %s, convert count : %s", (Object[])new Object[]{notify.reach_limit, notify.recv_count, notify.conversion_count});
        if (notify == null) {
            return;
        }
        int receive = notify.recv_count;
        int convertion = notify.conversion_count;
        if (convertion >= 1) {
            this.checkDailyCountLimit(notify.prop_id.intValue(), convertion);
            this.onReceiveFreeGift(notify.prop_id.intValue(), receive, convertion);
            this.mModel.addCollectCountDaily(notify.prop_id.intValue(), convertion);
            this.mModel.addGiftTotalCount(notify.prop_id.intValue(), convertion);
        } else if (notify.reach_limit.booleanValue() && (limit = this.mLimitMap.get(String.valueOf(notify.prop_id))) != null) {
            this.onReachTotalCountLimit(notify.prop_id.intValue(), limit.max_cnt_limit.intValue());
        }
    }

    private void checkDailyCountLimit(int giftId, int addCount) {
        PropOneLimit limit;
        int lastCountDaily = this.mModel.getCollectCountPerDay(giftId);
        int currentDailyCount = lastCountDaily + addCount;
        this.checkShowRedDot(giftId, addCount);
        if (this.mLimitMap != null && (limit = this.mLimitMap.get(String.valueOf(giftId))) != null && (long)lastCountDaily < limit.sameday_cnt_limit && (long)currentDailyCount >= limit.sameday_cnt_limit) {
            this.onReachLimitPerDay(giftId, limit.sameday_cnt_limit.intValue());
        }
    }

    private void checkTotalCountLimit(int giftId, int addCount) {
        PropOneLimit limit;
        int lastTotalCount = this.mModel.getTotalCount(giftId);
        int currentTotalCount = lastTotalCount + addCount;
        this.checkShowRedDot(giftId, addCount);
        if (this.mLimitMap != null && (limit = this.mLimitMap.get(String.valueOf(giftId))) != null && (long)lastTotalCount < limit.max_cnt_limit && (long)currentTotalCount >= limit.max_cnt_limit) {
            this.onReachTotalCountLimit(giftId, limit.max_cnt_limit.intValue());
        }
    }

    private void onReachLimitPerDay(int id2, int limit) {
        GiftItemInfo giftInfo = this.mHandlerCallback.findGiftById(id2, this.mParam.getChannelId());
        if (giftInfo != null) {
            String tips = String.format(ResourceUtils.getString((int)R.string.tips_reach_gift_daily_count_limit), limit, giftInfo.getName());
            this.mParam.getBehavior().appendSysPublicScreen((CharSequence)tips);
        }
    }

    private void onReachTotalCountLimit(int id2, int limit) {
        GiftItemInfo giftInfo = this.mHandlerCallback.findGiftById(id2, this.mParam.getChannelId());
        if (giftInfo != null) {
            String tips = String.format(ResourceUtils.getString((int)R.string.tips_reach_gift_total_count_limit), giftInfo.getName(), limit);
            this.mParam.getBehavior().appendSysPublicScreen((CharSequence)tips);
        }
    }

    private void onReceiveFreeGift(int id2, int receive, int convertion) {
        GiftItemInfo giftInfo = this.mHandlerCallback.findGiftById(id2, this.mParam.getChannelId());
        if (giftInfo != null) {
            String msg = String.format(ResourceUtils.getString((int)R.string.tips_after_receive), receive, giftInfo.getName(), giftInfo.getName(), convertion);
            this.mParam.getBehavior().appendSysPublicScreen((CharSequence)msg);
        }
    }

    private void checkShowRedDot(int giftId, int addCount) {
        int totalCount = this.mModel.getTotalCount(giftId);
        boolean canShow = SettingFlags.getBoolean((String)("key_show_free_gift_guide" + AccountUtil.getUid()), (boolean)true);
        if (totalCount <= 0 && addCount > 0 && canShow) {
            this.mDot.setVisible(true);
            this.mParam.getBehavior().addGiftRedDot(this.mDot);
        }
    }

    @Override
    public void hideRedDot() {
        this.mDot.setVisible(false);
    }

    private boolean canFloatGift(String propsId) {
        if (!TextUtils.isEmpty((CharSequence)propsId)) {
            int floatTimes = this.mModel.getFloatTimes(StringUtils.parseInt((String)propsId));
            int countPerDay = this.mModel.getCollectCountPerDay(StringUtils.parseInt((String)propsId));
            int totalCount = this.mModel.getTotalCount(StringUtils.parseInt((String)propsId));
            if (this.mLimitMap == null) {
                return true;
            }
            PropOneLimit limit = this.mLimitMap.get(propsId);
            if (limit != null) {
                return (long)floatTimes < limit.sameroom_cnt_limit && (long)countPerDay < limit.sameday_cnt_limit && (long)totalCount < limit.max_cnt_limit;
            }
            return true;
        }
        return false;
    }

    private boolean canFloatActivityProperty(ActivityPropertyInfo info) {
        if (info != null) {
            int rand = info.getRand();
            MLog.info((Object)TAG, (String)"canFloatActivityProperty, rand = %s", (Object[])new Object[]{rand});
            if (rand <= 0) {
                return true;
            }
            int result = this.mRandom.nextInt(rand);
            MLog.info((Object)TAG, (String)"canFloatActivityProperty, result = %s", (Object[])new Object[]{result});
            return result == 0;
        }
        return false;
    }

    @Override
    public void onViewRemoved(FloatingPropertyContract.View view) {
        if (view != null && this.mViewCache != null) {
            this.mViewCache.add(view);
        }
    }
}

