/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.sdk.cache;

import androidx.annotation.Nullable;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftInfo;

public class GiftDiskCache {
    private static final String GIFT_DISK_CACHE_PREFIX = "gift_disk_cache_";

    @Nullable
    public static GiftInfo getDiskGiftCache(String channelId, int liveCategoryId) {
        String key = GiftDiskCache.makeSafeKey(channelId, liveCategoryId);
        boolean isExistGiftDiskCache = SettingFlags.getBoolean((String)key, (boolean)false);
        if (isExistGiftDiskCache) {
            String giftInfoJson = FileStorageUtils.getInstance().getStrFromFile(true, key);
            GiftInfo giftInfo = (GiftInfo)JsonParser.parseJsonObject((String)giftInfoJson, GiftInfo.class);
            if (giftInfo != null) {
                giftInfo.parse();
            }
            return giftInfo;
        }
        return null;
    }

    public static void updateGiftInfoJsonToDiskCache(String channelId, int liveCategoryId, String resultJson) {
        if (StringUtils.isEmpty((String)resultJson)) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            String key = GiftDiskCache.makeSafeKey(channelId, liveCategoryId);
            FileStorageUtils.getInstance().removeFile(true, key);
            boolean isSuccess = FileStorageUtils.getInstance().saveToFile(true, resultJson, key);
            SettingFlags.setBoolean((String)key, (boolean)isSuccess);
        });
    }

    private static String makeSafeKey(String channelId, int liveCategoryId) {
        return GIFT_DISK_CACHE_PREFIX + channelId + "_" + liveCategoryId;
    }
}

