/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.model;

import androidx.annotation.NonNull;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.wallet.base.revenue.gift.bean.ActivityPropertyInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.SendGiftGuideInfo;
import com.yy.hiyo.wallet.gift.data.bean.ConsumeGuideNotifyInfo;
import com.yy.hiyo.wallet.gift.data.bean.GiftPanelIconInfo;
import com.yy.hiyo.wallet.gift.data.bean.GiftPanelIconMsgInfo;
import com.yy.hiyo.wallet.gift.data.bean.GiftPanelShowNotifyInfo;
import com.yy.hiyo.wallet.gift.data.bean.LuckyGiftBroadcastInfo;
import com.yy.hiyo.wallet.gift.data.bean.LuckyGiftUnicastInfo;
import com.yy.hiyo.wallet.gift.data.bean.PropLevelGiftInfo;
import com.yy.hiyo.wallet.gift.data.result.GiftOperationNotifyResult;
import com.yy.hiyo.wallet.gift.model.IGiftOperation;
import com.yy.hiyo.wallet.gift.model.IGiftOperationNotifyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.ihago.act.api.luckygift.LuckyNotify;
import net.ihago.act.api.luckygift.PropLevelNotify;
import net.ihago.act.api.luckygift.RoomNotify;
import net.ihago.act.api.luckygift.Uri;
import net.ihago.act.api.luckygift.WinToastNotify;
import net.ihago.active.api.activity.ActItem;
import net.ihago.active.api.activity.ActiveNotify;
import net.ihago.active.api.activity.PropOne;
import net.ihago.active.api.activity.SendGiftNotify;
import net.ihago.money.api.newcomerguide.GiftPanelBubbleMsg;
import net.ihago.money.api.newcomerguide.GiftPanelIcon;
import net.ihago.money.api.newcomerguide.GiftPanelIconMsg;
import net.ihago.money.api.newcomerguide.GiftPanelPopUpMsg;
import net.ihago.money.api.newcomerguide.NewbieGuideMsg;
import net.ihago.money.api.newcomerguide.NewbieGuideUri;
import net.ihago.money.api.pay.FreeGiftConversionNotify;
import net.ihago.money.api.pay.MoneyPayPush;

public class GiftOperationNotify
implements IGiftOperation {
    private static final String TAG = "GiftOperationNotify";
    private List<IGiftOperationNotifyListener<GiftOperationNotifyResult>> mGiftOperationNotifyListeners = new CopyOnWriteArrayList<IGiftOperationNotifyListener<GiftOperationNotifyResult>>();

    public GiftOperationNotify() {
        ProtoManager.getInstance().registerNotify((IProtoNotify)new IProtoNotify<ActiveNotify>(){

            public String serviceName() {
                return "net.ihago.active.api.activity";
            }

            public void onNotify(@NonNull ActiveNotify notify) {
                GiftOperationNotify.this.handleActivityNotify(notify);
            }
        });
        ProtoManager.getInstance().registerNotify((IProtoNotify)new IProtoNotify<MoneyPayPush>(){

            public String serviceName() {
                return "net.ihago.money.api.pay";
            }

            public void onNotify(@NonNull MoneyPayPush notify) {
                GiftOperationNotify.this.handleFreeGiftNotify(notify);
            }
        });
        ProtoManager.getInstance().registerNotify((IProtoNotify)new IProtoNotify<LuckyNotify>(){

            public String serviceName() {
                return "net.ihago.act.api.luckygift";
            }

            public void onNotify(@NonNull LuckyNotify notify) {
                GiftOperationNotify.this.handleLuckyGiftyNotify(notify);
            }
        });
        ProtoManager.getInstance().registerNotify((IProtoNotify)new IProtoNotify<NewbieGuideMsg>(){

            public String serviceName() {
                return "net.ihago.money.api.newcomerguide";
            }

            public void onNotify(@NonNull NewbieGuideMsg notify) {
                GiftOperationNotify.this.handleNewComerGuideNotify(notify);
            }
        });
    }

    private void handleActivityNotify(@NonNull ActiveNotify notify) {
        block8: {
            SendGiftNotify sendGiftNotify;
            block9: {
                block7: {
                    if (notify.uri != net.ihago.active.api.activity.Uri.UriFreeGiftNotify) break block7;
                    int count = notify.free_gift_notify.props.size();
                    if (count < 1) break block8;
                    ArrayList<GiftItemInfo> giftList = new ArrayList<GiftItemInfo>();
                    List list = notify.free_gift_notify.props;
                    for (PropOne propOne : list) {
                        int size = this.getRandomNumber(propOne.min_cnt.intValue(), propOne.max_cnt.intValue());
                        for (int i = 0; i < size; ++i) {
                            GiftItemInfo giftInfo = new GiftItemInfo();
                            giftInfo.setPropsId(propOne.prop_id.intValue());
                            giftInfo.setStaticIcon(propOne.prop_url);
                            giftList.add(giftInfo);
                        }
                    }
                    for (IGiftOperationNotifyListener<GiftOperationNotifyResult> iGiftOperationNotifyListener : this.mGiftOperationNotifyListeners) {
                        GiftOperationNotifyResult result = GiftOperationNotifyResult.newBuilder().floatGiftList(giftList).uri(2).roomId(notify.header.roomid).build();
                        iGiftOperationNotifyListener.onNotify(result);
                    }
                    break block8;
                }
                if (notify.uri != net.ihago.active.api.activity.Uri.UriActItemNotify) break block9;
                int count = notify.act_item_notify.items.size();
                if (count <= 0) break block8;
                ArrayList<ActivityPropertyInfo> itemList = new ArrayList<ActivityPropertyInfo>();
                for (ActItem actItem : notify.act_item_notify.items) {
                    ActivityPropertyInfo activityPropertyInfo = ActivityPropertyInfo.newBuilder().itemId(actItem.item_id.longValue()).picUrl(actItem.pic_url).popUrl(actItem.pop_url).type(actItem.type.intValue()).rand(actItem.rand.intValue()).token(actItem.token).canAcquireCnt(actItem.can_acquire_cnt.intValue()).disableAck(actItem.disable_ack.booleanValue()).displaySec(actItem.display_sec.intValue()).displayCnt(actItem.display_cnt.intValue()).build();
                    itemList.add(activityPropertyInfo);
                }
                for (IGiftOperationNotifyListener iGiftOperationNotifyListener : this.mGiftOperationNotifyListeners) {
                    GiftOperationNotifyResult giftOperationNotifyResult = GiftOperationNotifyResult.newBuilder().activtyPropertyList(itemList).uri(3).roomId(notify.header.roomid).build();
                    iGiftOperationNotifyListener.onNotify(giftOperationNotifyResult);
                }
                break block8;
            }
            if (notify.uri == net.ihago.active.api.activity.Uri.UriSendGiftNotify && (sendGiftNotify = notify.send_gift_notify) != null) {
                SendGiftGuideInfo info = SendGiftGuideInfo.newBuilder().giftType(sendGiftNotify.getTypeValue()).receiveUid(sendGiftNotify.recv_uid.longValue()).token(sendGiftNotify.token).ignorePlatform(sendGiftNotify.getIgnore_platformValue()).recvType(sendGiftNotify.getRecv_typeValue()).build();
                for (IGiftOperationNotifyListener<GiftOperationNotifyResult> iGiftOperationNotifyListener : this.mGiftOperationNotifyListeners) {
                    GiftOperationNotifyResult giftOperationNotifyResult = GiftOperationNotifyResult.newBuilder().sendGiftGuideInfo(info).uri(4).roomId(notify.header.roomid).build();
                    iGiftOperationNotifyListener.onNotify(giftOperationNotifyResult);
                }
            }
        }
    }

    private void handleFreeGiftNotify(@NonNull MoneyPayPush notify) {
        if (notify.uri == net.ihago.money.api.pay.Uri.kUriFreeGiftConversionNotify) {
            FreeGiftConversionNotify conversionNotify = notify.free_gift_notify;
            for (IGiftOperationNotifyListener<GiftOperationNotifyResult> listener : this.mGiftOperationNotifyListeners) {
                GiftOperationNotifyResult result = GiftOperationNotifyResult.newBuilder().receivedNotify(conversionNotify).uri(1).build();
                listener.onNotify(result);
            }
        }
    }

    private void handleLuckyGiftyNotify(@NonNull LuckyNotify notify) {
        block4: {
            block5: {
                block3: {
                    if (notify.uri != Uri.UriWinToastNotify) break block3;
                    WinToastNotify winToastNotify = notify.win_notify;
                    LuckyGiftUnicastInfo info = LuckyGiftUnicastInfo.newBuilder().uid(winToastNotify.uid).diamonds(winToastNotify.diamonds).propId(winToastNotify.prop_id).type(winToastNotify.getTypeValue()).ratio(winToastNotify.ratio).build();
                    FeatureLog.i((String)"FTLuckyGift", (String)"handleLuckyGiftyNotify, uri : %s, %s", (Object[])new Object[]{Uri.UriWinToastNotify.getValue(), info});
                    for (IGiftOperationNotifyListener<GiftOperationNotifyResult> listener : this.mGiftOperationNotifyListeners) {
                        GiftOperationNotifyResult result = GiftOperationNotifyResult.newBuilder().roomId(notify.header.roomid).luckyGiftUnicastInfo(info).uri(5).build();
                        listener.onNotify(result);
                    }
                    break block4;
                }
                if (notify.uri != Uri.UriRoomNotify) break block5;
                RoomNotify roomNotify = notify.room_notify;
                LuckyGiftBroadcastInfo info = LuckyGiftBroadcastInfo.newBuilder().winner(roomNotify.winner).diamonds(roomNotify.diamonds).propId(roomNotify.prop_id).type(roomNotify.getTypeValue()).nick(roomNotify.nick).ratio(roomNotify.ratio).build();
                FeatureLog.i((String)"FTLuckyGift", (String)"handleLuckyGiftyNotify, uri : %s, %s", (Object[])new Object[]{Uri.UriRoomNotify.getValue(), info});
                for (IGiftOperationNotifyListener<GiftOperationNotifyResult> listener : this.mGiftOperationNotifyListeners) {
                    GiftOperationNotifyResult result = GiftOperationNotifyResult.newBuilder().roomId(notify.header.roomid).luckyGiftBroadcastInfo(info).uri(6).build();
                    listener.onNotify(result);
                }
                break block4;
            }
            if (notify.uri != Uri.UriPropLevelNotify) break block4;
            PropLevelNotify giftInfo = notify.prop_level_notify;
            PropLevelGiftInfo propLevelGiftInfo = new PropLevelGiftInfo(giftInfo.uid, giftInfo.prop_id, giftInfo.prop_level);
            FeatureLog.i((String)"FTLuckyGift", (String)"UriPropLevelNotify", (Object[])new Object[0]);
            for (IGiftOperationNotifyListener<GiftOperationNotifyResult> listener : this.mGiftOperationNotifyListeners) {
                GiftOperationNotifyResult result = GiftOperationNotifyResult.newBuilder().roomId(notify.header.roomid).propLevelGiftInfo(propLevelGiftInfo).uri(7).build();
                listener.onNotify(result);
            }
        }
    }

    private void handleNewComerGuideNotify(@NonNull NewbieGuideMsg msg) {
        block4: {
            block5: {
                block3: {
                    MLog.info((Object)TAG, (String)"handleNewComerGuideNotify, uri=%s", (Object[])new Object[]{msg.uri});
                    if (msg.uri.intValue() != NewbieGuideUri.kUriGiftPanelIcon.getValue() && msg.uri.intValue() != NewbieGuideUri.kUriSendProp.getValue()) break block3;
                    GiftPanelIconMsg panelIconMsg = msg.gift_panel_icon;
                    GiftPanelIcon icon = panelIconMsg.icon;
                    GiftPanelIconMsgInfo msgInfo = new GiftPanelIconMsgInfo(panelIconMsg.room_id, panelIconMsg.all_room, this.getIconInfo(icon), panelIconMsg.gift_id);
                    int uri = msg.uri.intValue() == NewbieGuideUri.kUriGiftPanelIcon.getValue() ? 8 : 9;
                    for (IGiftOperationNotifyListener<GiftOperationNotifyResult> listener : this.mGiftOperationNotifyListeners) {
                        GiftOperationNotifyResult result = GiftOperationNotifyResult.newBuilder().roomId(msg.header.roomid).notifyInfo(msgInfo).uri(uri).build();
                        listener.onNotify(result);
                    }
                    break block4;
                }
                if (msg.uri.intValue() != NewbieGuideUri.kUriGiftPanelBubble.getValue()) break block5;
                GiftPanelBubbleMsg consumeMsg = msg.gift_panel_bubble;
                GiftPanelIcon icon = consumeMsg.icon;
                ConsumeGuideNotifyInfo notifyInfo = new ConsumeGuideNotifyInfo(this.getIconInfo(icon), consumeMsg.bubble_icon, consumeMsg.bubble_content);
                for (IGiftOperationNotifyListener<GiftOperationNotifyResult> listener : this.mGiftOperationNotifyListeners) {
                    GiftOperationNotifyResult result = GiftOperationNotifyResult.newBuilder().roomId(msg.header.roomid).notifyInfo(notifyInfo).uri(10).build();
                    listener.onNotify(result);
                }
                break block4;
            }
            if (msg.uri.intValue() != NewbieGuideUri.kUriGiftPanelPopUp.getValue()) break block4;
            GiftPanelPopUpMsg popUpMsg = msg.gift_panel_pop_up;
            GiftPanelShowNotifyInfo notifyInfo = new GiftPanelShowNotifyInfo(popUpMsg.gift_id);
            for (IGiftOperationNotifyListener<GiftOperationNotifyResult> listener : this.mGiftOperationNotifyListeners) {
                GiftOperationNotifyResult result = GiftOperationNotifyResult.newBuilder().roomId(msg.header.roomid).notifyInfo(notifyInfo).uri(11).build();
                listener.onNotify(result);
            }
        }
    }

    private GiftPanelIconInfo getIconInfo(GiftPanelIcon icon) {
        GiftPanelIconInfo iconInfo = null;
        if (icon != null) {
            iconInfo = new GiftPanelIconInfo(icon.icon, icon.keep_time, icon.interval);
        }
        return iconInfo;
    }

    private int getRandomNumber(int min, int max) {
        Random random = new Random();
        return random.nextInt(max - min) + min;
    }

    @Override
    public void registerGiftOperationListener(IGiftOperationNotifyListener<GiftOperationNotifyResult> listener) {
        if (!this.mGiftOperationNotifyListeners.contains(listener)) {
            this.mGiftOperationNotifyListeners.add(listener);
        }
    }

    @Override
    public void unregisterGiftOperationListener(IGiftOperationNotifyListener<GiftOperationNotifyResult> listener) {
        this.mGiftOperationNotifyListeners.remove(listener);
    }
}

