/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.gift.handler;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.hiyo.wallet.gift.handler.IGiftHandlerInner;
import java.util.Vector;

class GiftHandlerStack
extends Vector<IGiftHandlerInner> {
    private static final String TAG = "FTGiftHandlerStack";

    GiftHandlerStack() {
    }

    public IGiftHandlerInner push(IGiftHandlerInner item) {
        if (item == null) {
            return null;
        }
        IGiftHandlerInner top = this.peek();
        this.addElement(item);
        MLog.info((Object)TAG, (String)"push old top: %s, new top: %s", (Object[])new Object[]{top == null ? "" : top.roomId(), item.roomId()});
        return item;
    }

    @Nullable
    public synchronized IGiftHandlerInner pop() {
        if (this.isEmpty()) {
            return null;
        }
        int len = this.size();
        IGiftHandlerInner obj = this.peek();
        this.removeElementAt(len - 1);
        IGiftHandlerInner next = this.peek();
        MLog.info((Object)TAG, (String)"pop old top: %s, new top: %s", (Object[])new Object[]{obj == null ? "" : obj.roomId(), next == null ? "" : next.roomId()});
        return obj;
    }

    @Nullable
    public synchronized IGiftHandlerInner peek() {
        if (this.isEmpty()) {
            return null;
        }
        int len = this.size();
        return (IGiftHandlerInner)this.elementAt(len - 1);
    }

    @Nullable
    public IGiftHandlerInner remove(String roomId) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            return null;
        }
        if (this.isEmpty()) {
            return null;
        }
        int len = this.size();
        int index = -1;
        IGiftHandlerInner remove = null;
        for (int i = 0; i < len; ++i) {
            IGiftHandlerInner param = (IGiftHandlerInner)this.elementAt(i);
            if (!roomId.equals(param.roomId())) continue;
            remove = param;
            index = i;
            break;
        }
        if (index != -1) {
            this.removeElementAt(index);
        }
        MLog.info((Object)TAG, (String)"remove: %s, index: %d", (Object[])new Object[]{roomId, index});
        return remove;
    }

    public synchronized int search(IGiftHandlerInner o) {
        if (o == null) {
            return -1;
        }
        int i = this.lastIndexOf(o);
        if (i >= 0) {
            return this.size() - i;
        }
        return -1;
    }

    @Nullable
    public synchronized IGiftHandlerInner search(String roomId) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            return null;
        }
        if (this.isEmpty()) {
            return null;
        }
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            IGiftHandlerInner param = (IGiftHandlerInner)this.elementAt(i);
            if (!roomId.equals(param.roomId())) continue;
            return param;
        }
        return null;
    }
}

