/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.floatplay.handler;

import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.squareup.wire.AndroidMessage;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.hiyo.wallet.base.WalletBaseMsgDef;
import com.yy.hiyo.wallet.base.floatplay.CreatePlayHandlerParam;
import com.yy.hiyo.wallet.base.floatplay.FloatPlayType;
import com.yy.hiyo.wallet.base.floatplay.FromSource;
import com.yy.hiyo.wallet.base.floatplay.PlayState;
import com.yy.hiyo.wallet.floatplay.handler.IPlayHandler;
import com.yy.hiyo.wallet.floatplay.handler.IPlayHandlerCallback;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.money.api.floatingwindow.EOriginType;
import net.ihago.money.api.floatingwindow.GetConfigReq;
import net.ihago.money.api.floatingwindow.GetConfigRes;
import net.ihago.money.api.floatingwindow.ReportUserMinimizeReq;
import net.ihago.money.api.floatingwindow.ReportUserMinimizeRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020\u0016H\u0016J\b\u0010!\u001a\u00020\u0016H\u0002J\b\u0010\"\u001a\u00020\u0016H\u0016J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0004J\b\u0010&\u001a\u00020\u0016H\u0016J\b\u0010'\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/yy/hiyo/wallet/floatplay/handler/BasePlayHandler;", "Lcom/yy/hiyo/wallet/floatplay/handler/IPlayHandler;", "container", "Landroid/view/ViewGroup;", "startParam", "Lcom/yy/hiyo/wallet/base/floatplay/CreatePlayHandlerParam;", "handlerCallback", "Lcom/yy/hiyo/wallet/floatplay/handler/IPlayHandlerCallback;", "(Landroid/view/ViewGroup;Lcom/yy/hiyo/wallet/base/floatplay/CreatePlayHandlerParam;Lcom/yy/hiyo/wallet/floatplay/handler/IPlayHandlerCallback;)V", "getContainer", "()Landroid/view/ViewGroup;", "hadGetReportConfig", "", "getHandlerCallback", "()Lcom/yy/hiyo/wallet/floatplay/handler/IPlayHandlerCallback;", "isDestroy", "needReportServer", "playState", "Lcom/yy/hiyo/wallet/base/floatplay/PlayState;", "getStartParam", "()Lcom/yy/hiyo/wallet/base/floatplay/CreatePlayHandlerParam;", "checkReportMiniServer", "", "destroy", "getFromSource", "Lcom/yy/hiyo/wallet/base/floatplay/FromSource;", "getPlayId", "", "getPlayState", "getType", "Lcom/yy/hiyo/wallet/base/floatplay/FloatPlayType;", "interceptBack", "pausePlay", "reportMiniServer", "resumePlay", "setViewSize", "rootView", "Landroid/view/View;", "stopPlay", "toString", "Companion", "wallet_billDebug"})
public abstract class BasePlayHandler
implements IPlayHandler {
    private PlayState playState;
    private boolean isDestroy;
    private boolean hadGetReportConfig;
    private boolean needReportServer;
    @NotNull
    private final ViewGroup container;
    @NotNull
    private final CreatePlayHandlerParam startParam;
    @NotNull
    private final IPlayHandlerCallback handlerCallback;
    @NotNull
    public static final String TAG = "FloatPlayBaseHandler";
    public static final Companion Companion = new Companion(null);

    protected final void setViewSize(@NotNull CreatePlayHandlerParam startParam, @NotNull View rootView2) {
        Intrinsics.checkParameterIsNotNull((Object)startParam, (String)"startParam");
        Intrinsics.checkParameterIsNotNull((Object)rootView2, (String)"rootView");
        View $this$updateLayoutParams$iv = rootView2;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
        ConstraintLayout.LayoutParams $this$updateLayoutParams = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl = false;
        if (!TextUtils.isEmpty((CharSequence)startParam.getWHRatio())) {
            $this$updateLayoutParams.dimensionRatio = "w,1:" + startParam.getWHRatio();
        }
        if (startParam.getGray() == 80) {
            $this$updateLayoutParams.topToTop = -1;
            $this$updateLayoutParams.bottomToBottom = 0;
            $this$updateLayoutParams.bottomMargin = startParam.getMarginY();
        } else if (startParam.getGray() == 48) {
            $this$updateLayoutParams.topToTop = 0;
            $this$updateLayoutParams.bottomToBottom = -1;
            $this$updateLayoutParams.topMargin = startParam.getMarginY();
        }
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }

    @Override
    @NotNull
    public String getPlayId() {
        return this.startParam.getPlayId();
    }

    @Override
    @NotNull
    public PlayState getPlayState() {
        return this.playState;
    }

    @Override
    @NotNull
    public FromSource getFromSource() {
        return this.startParam.getSource();
    }

    @Override
    public void stopPlay() {
        MLog.info((Object)TAG, (String)"stopPlay %s", (Object[])new Object[]{this.toString()});
        this.playState = PlayState.STOP;
        MsgDispatcher.getInstance().sendMessage(WalletBaseMsgDef.STOP_MINI_FLOAT_PLAY_VIEW, (Object)this.startParam);
    }

    @Override
    public void pausePlay() {
        MLog.info((Object)TAG, (String)"pausePlay %s", (Object[])new Object[]{this.toString()});
        this.playState = PlayState.PAUSE;
        MsgDispatcher.getInstance().sendMessage(WalletBaseMsgDef.SHOW_MINI_FLOAT_PLAY_VIEW, (Object)this.startParam);
        this.checkReportMiniServer();
    }

    @Override
    public void resumePlay() {
        MLog.info((Object)TAG, (String)"resumePlay %s", (Object[])new Object[]{this.toString()});
        if (this.playState == PlayState.PAUSE) {
            MsgDispatcher.getInstance().sendMessage(WalletBaseMsgDef.REMOVE_MINI_FLOAT_PLAY_VIEW, (Object)this.startParam);
        }
        this.playState = PlayState.START;
    }

    @Override
    public void destroy() {
        block5: {
            MLog.info((Object)TAG, (String)"destroy %s", (Object[])new Object[]{this.toString()});
            if (this.playState != PlayState.STOP) {
                MsgDispatcher.getInstance().sendMessage(WalletBaseMsgDef.STOP_MINI_FLOAT_PLAY_VIEW, (Object)this.startParam);
            }
            View $this$removeSelfFromParent$iv = (View)this.container;
            boolean $i$f$removeSelfFromParent = false;
            if ($this$removeSelfFromParent$iv.getParent() != null && $this$removeSelfFromParent$iv.getParent() instanceof ViewGroup) {
                try {
                    ViewParent viewParent = $this$removeSelfFromParent$iv.getParent();
                    if (viewParent == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
                    }
                    ((ViewGroup)viewParent).removeView($this$removeSelfFromParent$iv);
                }
                catch (Exception e$iv) {
                    MLog.error((Object)"removeSelfFromParent", (Throwable)e$iv);
                    if (!RuntimeContext.isLocalBuild()) break block5;
                    throw (Throwable)e$iv;
                }
            }
        }
        this.playState = PlayState.STOP;
        this.isDestroy = true;
    }

    @Override
    @NotNull
    public FloatPlayType getType() {
        return this.startParam.getType();
    }

    @Override
    public boolean interceptBack() {
        if (this.getPlayState() == PlayState.START) {
            this.pausePlay();
            return true;
        }
        return false;
    }

    @NotNull
    public String toString() {
        return this.hashCode() + " playId: " + this.getPlayId() + ", state: " + this.getPlayState() + ", isDestroy: " + this.isDestroy;
    }

    private final void checkReportMiniServer() {
        if (!this.hadGetReportConfig) {
            this.hadGetReportConfig = true;
            GetConfigReq req = new GetConfigReq.Builder().build();
            ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetConfigRes>(this){
                final /* synthetic */ BasePlayHandler this$0;

                public void onResponse(@NotNull GetConfigRes message, long code, @Nullable String msg) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    MLog.info((Object)"FloatPlayBaseHandler", (String)"checkReportMiniServer code: %d, msg: %s", (Object[])new Object[]{code, msg});
                    Boolean bl = message.report_user_minimize;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"message.report_user_minimize");
                    BasePlayHandler.access$setNeedReportServer$p(this.this$0, bl);
                    BasePlayHandler.access$reportMiniServer(this.this$0);
                }

                public void onError(@Nullable String reason, int code) {
                    MLog.error((Object)"FloatPlayBaseHandler", (String)"reportMiniServer code: %d, msg: %s", (Object[])new Object[]{code, reason});
                }
                {
                    this.this$0 = $outer;
                }
            });
        } else {
            this.reportMiniServer();
        }
    }

    private final void reportMiniServer() {
        if (!this.needReportServer) {
            MLog.info((Object)TAG, (String)"reportMiniServer", (Object[])new Object[0]);
            return;
        }
        ReportUserMinimizeReq req = new ReportUserMinimizeReq.Builder().act_type(Integer.valueOf(EOriginType.EOriginTypeGame.getValue())).game_id(this.startParam.getJump()).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<ReportUserMinimizeRes>(){

            public void onResponse(@NotNull ReportUserMinimizeRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                MLog.info((Object)"FloatPlayBaseHandler", (String)"reportMiniServer code: %d, msg: %s", (Object[])new Object[]{code, msg});
            }

            public void onError(@Nullable String reason, int code) {
                MLog.error((Object)"FloatPlayBaseHandler", (String)"reportMiniServer code: %d, msg: %s", (Object[])new Object[]{code, reason});
            }
        });
    }

    @NotNull
    protected final ViewGroup getContainer() {
        return this.container;
    }

    @NotNull
    protected final CreatePlayHandlerParam getStartParam() {
        return this.startParam;
    }

    @NotNull
    protected final IPlayHandlerCallback getHandlerCallback() {
        return this.handlerCallback;
    }

    public BasePlayHandler(@NotNull ViewGroup container, @NotNull CreatePlayHandlerParam startParam, @NotNull IPlayHandlerCallback handlerCallback) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)startParam, (String)"startParam");
        Intrinsics.checkParameterIsNotNull((Object)handlerCallback, (String)"handlerCallback");
        this.container = container;
        this.startParam = startParam;
        this.handlerCallback = handlerCallback;
        this.playState = PlayState.NONE;
        this.playState = PlayState.START;
        this.container.setEnabled(true);
        this.container.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(@Nullable View v, @Nullable MotionEvent event) {
                if (v == null || event == null) {
                    return false;
                }
                return false;
            }
        });
    }

    public static final /* synthetic */ boolean access$getNeedReportServer$p(BasePlayHandler $this) {
        return $this.needReportServer;
    }

    public static final /* synthetic */ void access$setNeedReportServer$p(BasePlayHandler $this, boolean bl) {
        $this.needReportServer = bl;
    }

    public static final /* synthetic */ void access$reportMiniServer(BasePlayHandler $this) {
        $this.reportMiniServer();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/wallet/floatplay/handler/BasePlayHandler$Companion;", "", "()V", "TAG", "", "wallet_billDebug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

