/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.coupon.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.wallet.R;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.bean.NoCouponBean;
import com.yy.hiyo.wallet.coupon.bean.CouponTabPageInfo;
import com.yy.hiyo.wallet.coupon.ui.CouponPagerAdapter;
import com.yy.hiyo.wallet.coupon.ui.ICouponListUiCallBack;
import com.yy.hiyo.wallet.coupon.ui.tab.CouponTabPage;
import java.util.ArrayList;
import java.util.List;

public class CouponListPage
extends YYFrameLayout {
    private Context mContext;
    private YYImageView mCouponBack;
    private YYViewPager mCouponPager;
    private SlidingTabLayout mCouponTab;
    private ICouponListUiCallBack mCallback;
    private CouponTabPage mAvailableTab;
    private CouponTabPage mUsedTab;
    private boolean isUsedFirstLoaded;

    public CouponListPage(Context context, ICouponListUiCallBack callBack) {
        super(context);
        this.mCallback = callBack;
        this.createView();
    }

    private void createView() {
        this.mContext = this.getContext();
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_coupon_list_page, (ViewGroup)this);
        this.mCouponBack = (YYImageView)this.findViewById(R.id.coupon_back);
        this.mCouponPager = (YYViewPager)this.findViewById(R.id.coupon_pager);
        this.mCouponTab = (SlidingTabLayout)this.findViewById(R.id.coupon_tab);
        this.initViewPager();
        this.mCouponBack.setOnClickListener(v -> {
            if (this.mCallback != null) {
                this.mCallback.onBackClick();
            }
        });
    }

    private void initViewPager() {
        CouponPagerAdapter couponPagerAdapter = new CouponPagerAdapter();
        ArrayList<CouponTabPageInfo> data = new ArrayList<CouponTabPageInfo>();
        this.mAvailableTab = new CouponTabPage(this.mContext, true, this.mCallback);
        this.mUsedTab = new CouponTabPage(this.mContext, false, this.mCallback);
        data.add(new CouponTabPageInfo(ResourceUtils.getString((int)R.string.tips_available), (View)this.mAvailableTab));
        data.add(new CouponTabPageInfo(ResourceUtils.getString((int)R.string.tips_used), (View)this.mUsedTab));
        couponPagerAdapter.setData(data);
        this.mCouponPager.setOffscreenPageLimit(1);
        this.mCouponPager.setAdapter((PagerAdapter)couponPagerAdapter);
        this.mCouponTab.setViewPager((ViewPager)this.mCouponPager);
        this.mCouponPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
                if (state == 0 && CouponListPage.this.mCouponPager.getCurrentItem() == 1 && !CouponListPage.this.isUsedFirstLoaded && CouponListPage.this.mCallback != null) {
                    CouponListPage.this.mCallback.queryCouponListAsync(true);
                }
            }
        });
        this.mAvailableTab.getStatusLayout().setOnStatusClickListener(v -> {
            if (this.mCallback != null) {
                this.mCallback.queryCouponListAsync(false);
            }
        });
        this.mUsedTab.getStatusLayout().setOnStatusClickListener(v -> {
            if (this.mCallback != null) {
                this.mCallback.queryCouponListAsync(true);
            }
        });
    }

    public void showLoading(boolean isUsed) {
        if (!isUsed) {
            this.mAvailableTab.getStatusLayout().showLoading();
        } else {
            this.mUsedTab.getStatusLayout().showLoading();
        }
    }

    public void hideLoading(boolean isUsed) {
        if (!isUsed) {
            this.mAvailableTab.getStatusLayout().hideLoading();
        } else {
            this.mUsedTab.getStatusLayout().hideLoading();
        }
    }

    public void setTabData(List<CouponBean> list, boolean isUsed, long couponId) {
        if (isUsed) {
            this.mUsedTab.setListData(list, couponId);
            this.isUsedFirstLoaded = true;
        } else {
            if (list != null && !list.isEmpty()) {
                list.add((CouponBean)new NoCouponBean());
            }
            this.mAvailableTab.setListData(list, couponId);
        }
    }

    public void processFailed(boolean isUsed) {
        this.hideLoading(isUsed);
        if (isUsed) {
            this.mUsedTab.getStatusLayout().showError();
        } else {
            this.mAvailableTab.getStatusLayout().showError();
        }
    }
}

