/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.wallet.coupon.ui;

import android.content.Context;
import android.os.Message;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.R;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.wallet.base.IPayService;
import com.yy.hiyo.wallet.base.pay.bean.CouponBean;
import com.yy.hiyo.wallet.base.pay.callback.IPayCallback;
import com.yy.hiyo.wallet.coupon.ui.CouponListWindow;
import com.yy.hiyo.wallet.coupon.ui.ICouponListUiCallBack;
import java.util.List;

public class CouponListController
extends DefaultController
implements ICouponListUiCallBack {
    private CouponListWindow mWindow;
    private Long mCouponId;

    public CouponListController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == AppbaseMsgDef.SHOW_WINDOW_COUPON_LIST) {
            if (this.mWindow == null) {
                this.mWindow = new CouponListWindow(this.mContext, this);
            }
            if (msg.obj instanceof Long) {
                this.mCouponId = (Long)msg.obj;
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            this.queryCouponListAsync(false);
        }
    }

    @Override
    public void onBackClick() {
        this.closeWindow();
    }

    @Override
    public void queryCouponListAsync(final boolean isUsed) {
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        if (this.mWindow != null && this.mWindow.getCouponListPage() != null) {
            this.mWindow.getCouponListPage().showLoading(isUsed);
        }
        ((IPayService)this.getServiceManager().getService(IPayService.class)).queryCouponListAsync(isUsed, (IPayCallback)new IPayCallback<List<CouponBean>>(){

            public void onSucceed(@Nullable List<CouponBean> data) {
                if (CouponListController.this.mWindow != null && CouponListController.this.mWindow.getCouponListPage() != null) {
                    CouponListController.this.mWindow.getCouponListPage().setTabData(data, isUsed, CouponListController.this.mCouponId);
                }
            }

            public void onFailed(int code, String msg) {
                if (CouponListController.this.mWindow != null && CouponListController.this.mWindow.getCouponListPage() != null) {
                    CouponListController.this.mWindow.getCouponListPage().processFailed(isUsed);
                }
            }
        });
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        this.mWindow = null;
    }

    private void closeWindow() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
        }
        this.mWindow = null;
    }
}

